/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.RenderableText;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;
import java.awt.Color;
import java.util.function.Consumer;

public class TablistScoreComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        if (!ctx.config.bool(IConfig.BooleanOption.TABLIST_HEALTH_ENABLE)) {
            return false;
        }
        ctx.profiler.push("tablist.score");
        int score = (Integer)ctx.property("score");
        if (((Boolean)ctx.property("rendertype.hearts")).booleanValue()) {
            boolean blink;
            ITextureSheet tex = this.tex(ctx).bind(ctx);
            long millis = ctx.data.millis();
            long visibilityId = (Long)ctx.property("visibilityid");
            long renderVisibilityId = (Long)ctx.property("player.rendervisibilityid");
            long lastHealthTime = (Long)ctx.property("player.lasthealthtime");
            long healthBlinkTime = (Long)ctx.property("player.healthblinktime");
            int lastHealth = (Integer)ctx.property("player.lasthealth");
            int displayHealth = (Integer)ctx.property("player.displayhealth");
            Consumer setLastHealthTime = (Consumer)ctx.property("player.setlasthealthtime");
            Consumer setHealthBlinkTime = (Consumer)ctx.property("player.sethealthblinktime");
            Consumer setRenderVisibilityId = (Consumer)ctx.property("player.setrendervisibilityid");
            Consumer setLastHealth = (Consumer)ctx.property("player.setlasthealth");
            Consumer setDisplayHealth = (Consumer)ctx.property("player.setdisplayhealth");
            if (visibilityId == renderVisibilityId) {
                if (score < lastHealth) {
                    setLastHealthTime.accept(millis);
                    setHealthBlinkTime.accept((long)ctx.data.guiTicks() + 20L);
                } else if (score > lastHealth) {
                    setLastHealthTime.accept(millis);
                    setHealthBlinkTime.accept((long)ctx.data.guiTicks() + 10L);
                }
            }
            if (millis - lastHealthTime > 1000L || visibilityId != renderVisibilityId) {
                setDisplayHealth.accept(score);
                setLastHealthTime.accept(millis);
            }
            setRenderVisibilityId.accept(visibilityId);
            setLastHealth.accept(score);
            int health = Math.max(score, displayHealth);
            int heartCount = ctx.math.ceil((float)Math.max(score, displayHealth) / 2.0f);
            int heartStack = Math.min((health - 1) / ctx.config.num(IConfig.IntegerOption.TABLIST_MAX_HEART_COUNT) / 2, 10);
            boolean bl = blink = healthBlinkTime > (long)ctx.data.guiTicks() && (healthBlinkTime - (long)ctx.data.guiTicks()) / 3L % 2L == 1L;
            if (heartCount > 0) {
                if (heartCount <= (heartStack + 1) * ctx.config.num(IConfig.IntegerOption.TABLIST_MAX_HEART_COUNT)) {
                    int max = ctx.config.bool(IConfig.BooleanOption.TABLIST_HEALTH_ALWAYS_MAX) ? ctx.config.num(IConfig.IntegerOption.TABLIST_MAX_HEART_COUNT) : Math.min(ctx.config.num(IConfig.IntegerOption.TABLIST_MAX_HEART_COUNT), heartCount);
                    for (int i = 0; i < max; ++i) {
                        int heartX = ctx.x + i * 8;
                        int heartValue = i * 2 + heartStack * ctx.config.num(IConfig.IntegerOption.TABLIST_MAX_HEART_COUNT) * 2 + 1;
                        tex.drawHeartBG(ctx, heartX, ctx.y, blink);
                        if (heartStack > 0 && heartValue >= health) {
                            tex.drawHeart(ctx, heartX, ctx.y, heartStack - 1, false, blink, false, ITextureSheet.HeartStyle.NORMAL);
                        }
                        if (blink && heartValue <= displayHealth) {
                            tex.drawHeart(ctx, heartX, ctx.y, heartStack, heartValue == displayHealth, true, false, ITextureSheet.HeartStyle.NORMAL);
                        }
                        if (heartValue > health) continue;
                        tex.drawHeart(ctx, heartX, ctx.y, heartStack, heartValue == health, false, false, ITextureSheet.HeartStyle.NORMAL);
                    }
                } else {
                    Object healthText = String.valueOf(score);
                    if ((Integer)ctx.property("maxX") - ctx.renderer.width(healthText, "hp") >= ctx.x) {
                        healthText = (String)healthText + "hp";
                    }
                    if (ctx.config.bool(IConfig.BooleanOption.DISABLE_EASTEREGGS)) {
                        ctx.renderer.text(ctx.poseStack, (String)healthText, ((Integer)ctx.property("maxX") + ctx.x - ctx.renderer.width(healthText)) / 2, ctx.y, 65280);
                    } else {
                        millis /= 40L;
                        RenderableText text = new RenderableText("").withAlignment(RenderableText.Alignment.CENTER).withShadow(ctx.config.bool(IConfig.BooleanOption.TEXT_SHADOW));
                        for (String chr : ((String)healthText).split("")) {
                            text.append(new RenderableText(chr).withColor(Color.HSBtoRGB((float)((millis -= 5L) % 360L) / 360.0f, 1.0f, 1.0f)));
                        }
                        text.render(ctx.poseStack, ctx.renderer, ((Integer)ctx.property("maxX") + ctx.x) / 2, ctx.y);
                    }
                }
            }
        } else {
            String text = (String)ctx.property("chatformatting.yellow") + score;
            ctx.renderer.text(ctx.poseStack, text, (Integer)ctx.property("maxX") - ctx.renderer.width(text), ctx.y, 0xFFFFFF);
        }
        return this.popReturn(ctx, true);
    }
}

