/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.texture;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.texture.StandardTextureSheet;
import dev.cheos.armorpointspp.core.texture.VanillaTextureSheet;
import java.util.List;

public interface ITextureSheet {
    public static final BiMap<String, ITextureSheet> sheets = HashBiMap.create();
    public static final ITextureSheet vanillaSheet = ITextureSheet.register("vanilla", new VanillaTextureSheet());
    public static final ITextureSheet defaultSheet = ITextureSheet.register("default", new StandardTextureSheet("icons"));
    public static final ITextureSheet hallowSheet = ITextureSheet.register("hallow", new StandardTextureSheet("hallow"));
    public static final List<ITextureSheet> builtins = ImmutableList.of((Object)defaultSheet, (Object)hallowSheet, (Object)vanillaSheet);

    public void drawOverlay(RenderContext var1, int var2, int var3, boolean var4, boolean var5, OverlaySprite var6);

    public void drawHeartBG(RenderContext var1, int var2, int var3, boolean var4);

    public void drawAbsorb(RenderContext var1, int var2, int var3, int var4, boolean var5);

    public void drawArmor(RenderContext var1, int var2, int var3, int var4, boolean var5);

    public void drawHeart(RenderContext var1, int var2, int var3, int var4, boolean var5, boolean var6, boolean var7, HeartStyle var8);

    public void drawAbsorbHeart(RenderContext var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

    public void drawToughness(RenderContext var1, int var2, int var3, int var4, boolean var5, boolean var6, boolean var7);

    public void drawMagicShield(RenderContext var1, int var2, int var3, int var4);

    public String texLocation();

    default public int spriteWidth() {
        return 9;
    }

    default public int spriteHeight() {
        return 9;
    }

    default public int texWidth() {
        return 256;
    }

    default public int texHeight() {
        return 128;
    }

    default public int getMaxHealthLevel() {
        return 10;
    }

    default public int getMaxArmorLevel() {
        return 12;
    }

    default public int getMaxToughnessLevel() {
        return 12;
    }

    default public ITextureSheet bind(RenderContext ctx) {
        ctx.renderer.setupTexture(this);
        return this;
    }

    default public ITextureSheet blit(RenderContext ctx, int x, int y, float u, float v, int w, int h) {
        ctx.renderer.blit(ctx.poseStack, x, y, u, v, w, h, this.texWidth(), this.texHeight());
        return this;
    }

    default public ITextureSheet blit(RenderContext ctx, int x, int y, float u, float v) {
        ctx.renderer.blit(ctx.poseStack, x, y, u, v, this.spriteWidth(), this.spriteHeight(), this.texWidth(), this.texHeight());
        return this;
    }

    default public ITextureSheet blitM(RenderContext ctx, int x, int y, float u, float v, int w, int h) {
        ctx.renderer.blitM(ctx.poseStack, x, y, u, v, w, h, this.texWidth(), this.texHeight());
        return this;
    }

    default public ITextureSheet blitM(RenderContext ctx, int x, int y, float u, float v) {
        ctx.renderer.blitM(ctx.poseStack, x, y, u, v, this.spriteWidth(), this.spriteHeight(), this.texWidth(), this.texHeight());
        return this;
    }

    public static ITextureSheet vanillaSheet() {
        return vanillaSheet;
    }

    public static ITextureSheet defaultSheet() {
        return defaultSheet;
    }

    public static ITextureSheet currentSheet(RenderContext ctx) {
        return (ITextureSheet)sheets.computeIfAbsent((Object)ctx.config.str(IConfig.StringOption.TEXTURE_SHEET), id -> ITextureSheet.register(new StandardTextureSheet((String)id)));
    }

    public static ITextureSheet register(ITextureSheet sheet) {
        return ITextureSheet.register(sheet.texLocation(), sheet);
    }

    public static ITextureSheet register(String id, ITextureSheet sheet) {
        if (sheets.putIfAbsent((Object)id, (Object)sheet) != null) {
            throw new IllegalStateException("Tried to register a texture sheet with the same id twice");
        }
        return sheet;
    }

    public static enum HeartStyle {
        NORMAL,
        POISON,
        WITHER;

    }

    public static enum OverlaySprite {
        FROSTBITE,
        FROSTBITE_FULL,
        FROSTBITE_ICON,
        PROTECTION,
        RESISTANCE_NONE,
        RESISTANCE_HALF,
        RESISTANCE_FULL;

    }
}

