/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.texture;

import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;

public class StandardTextureSheet
implements ITextureSheet {
    private final String location;

    public StandardTextureSheet(String location) {
        this.location = location;
    }

    @Override
    public void drawOverlay(RenderContext ctx, int x, int y, boolean half, boolean hardcore, ITextureSheet.OverlaySprite sprite) {
        switch (sprite) {
            case FROSTBITE: {
                this.blit(ctx, x, y, (half ? 9 : 0) + (hardcore ? 18 : 0), 117.0f);
                break;
            }
            case FROSTBITE_FULL: {
                this.blit(ctx, x, y, 36 + (half ? 9 : 0) + (hardcore ? 18 : 0), 117.0f);
                break;
            }
            case FROSTBITE_ICON: {
                ctx.poseStack.pushPose();
                ctx.poseStack.scale(0.5f, 0.5f, 1.0f);
                this.blit(ctx, 2 * x + 8, 2 * y + 1, 27.0f, 18.0f);
                ctx.poseStack.popPose();
                break;
            }
            case PROTECTION: {
                this.blit(ctx, x, y, 9.0f, 18.0f);
                break;
            }
            case RESISTANCE_FULL: {
                this.blit(ctx, x, y, 18.0f, 0.0f);
                break;
            }
            case RESISTANCE_HALF: {
                this.blit(ctx, x, y, 9.0f, 0.0f);
                break;
            }
            case RESISTANCE_NONE: {
                this.blit(ctx, x, y, 0.0f, 0.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown overlay sprite: " + sprite.name());
            }
        }
    }

    @Override
    public void drawHeartBG(RenderContext ctx, int x, int y, boolean bright) {
        this.blit(ctx, x, y, bright ? 18.0f : 0.0f, 18.0f);
    }

    @Override
    public void drawAbsorb(RenderContext ctx, int x, int y, int amount, boolean bright) {
        amount = ctx.math.clamp(amount, 1, 20);
        this.blit(ctx, x, y, (bright ? 18 : 0) + 9 * (amount % 2), 18 + 9 * ((amount + 1) / 2));
    }

    @Override
    public void drawArmor(RenderContext ctx, int x, int y, int spriteLevel, boolean half) {
        if (spriteLevel >= this.getMaxArmorLevel()) {
            half = false;
        }
        this.blit(ctx, x, y, (half ? 36 : 27) + 18 * ctx.math.clamp(spriteLevel, 0, this.getMaxArmorLevel()), 0.0f);
    }

    @Override
    public void drawHeart(RenderContext ctx, int x, int y, int spriteLevel, boolean half, boolean bright, boolean hardcore, ITextureSheet.HeartStyle style) {
        if (spriteLevel >= this.getMaxHealthLevel()) {
            half = false;
        }
        this.blit(ctx, x, y, (hardcore ? 144 : 36) + (half ? 9 : 0) + (bright ? 18 : 0) + (style == ITextureSheet.HeartStyle.POISON ? 36 : (style == ITextureSheet.HeartStyle.WITHER ? 72 : 0)), 18 + 9 * ctx.math.clamp(spriteLevel, 0, this.getMaxHealthLevel()));
    }

    @Override
    public void drawAbsorbHeart(RenderContext ctx, int x, int y, boolean half, boolean right, boolean hardcore) {
        this.blit(ctx, x, y, (hardcore ? 126 : 117) + (half && right ? 5 : 0), 117.0f, half ? (right ? 4 : 5) : this.spriteWidth(), 9);
    }

    @Override
    public void drawToughness(RenderContext ctx, int x, int y, int spriteLevel, boolean half, boolean icon, boolean mirror) {
        if (spriteLevel >= this.getMaxToughnessLevel()) {
            half = false;
        }
        if (icon) {
            ctx.poseStack.pushPose();
            ctx.poseStack.scale(0.5f, 0.5f, 1.0f);
            this.blit(ctx, 2 * x + 9, 2 * y + 8, 45 + 18 * ctx.math.clamp(spriteLevel, 0, 11), 9.0f);
            ctx.poseStack.popPose();
        } else if (mirror) {
            this.blitM(ctx, x, y, (half ? 36 : 27) + 18 * ctx.math.clamp(spriteLevel, 0, this.getMaxToughnessLevel()), 9.0f);
        } else {
            this.blit(ctx, x, y, (half ? 36 : 27) + 18 * ctx.math.clamp(spriteLevel, 0, this.getMaxToughnessLevel()), 9.0f);
        }
    }

    @Override
    public void drawMagicShield(RenderContext ctx, int x, int y, int spriteLevel) {
        this.blit(ctx, x, y, 108 - 9 * (spriteLevel % 5), 117.0f);
    }

    @Override
    public String texLocation() {
        return this.location;
    }
}

