/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.cheos.armorpointspp.core.adapter.IDataProvider;
import dev.cheos.armorpointspp.core.adapter.IEffectProvider;
import dev.cheos.armorpointspp.core.adapter.IEnchantmentProvider;
import dev.cheos.armorpointspp.core.adapter.IItemStack;
import dev.cheos.armorpointspp.core.adapter.IMobEffect;
import dev.cheos.armorpointspp.core.adapter.IMobEffectInstance;
import dev.cheos.armorpointspp.impl.EffectProviderImpl;
import dev.cheos.armorpointspp.impl.EnchantmentProviderImpl;
import dev.cheos.armorpointspp.impl.ItemStackImpl;
import dev.cheos.armorpointspp.impl.MobEffectInstanceImpl;
import dev.cheos.armorpointspp.impl.PotionCoreImpl;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class DataProviderImpl
implements IDataProvider {
    private final Cache<String, Boolean> effectActiveCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
    private final Minecraft minecraft = Minecraft.m_91087_();

    @Override
    public int armor() {
        return this.minecraft.f_91074_.m_21230_();
    }

    @Override
    public int maxArmor() {
        int n;
        Attribute attribute = Attributes.f_22284_;
        if (attribute instanceof RangedAttribute) {
            RangedAttribute ra = (RangedAttribute)attribute;
            n = Mth.m_14107_((double)ra.m_147362_());
        } else {
            n = 30;
        }
        return n;
    }

    @Override
    public double toughness() {
        return this.minecraft.f_91074_.m_21133_(Attributes.f_22285_);
    }

    @Override
    public double maxToughness() {
        double d;
        Attribute attribute = Attributes.f_22285_;
        if (attribute instanceof RangedAttribute) {
            RangedAttribute ra = (RangedAttribute)attribute;
            d = ra.m_147362_();
        } else {
            d = 20.0;
        }
        return d;
    }

    @Override
    public int guiTicks() {
        return this.minecraft.f_91065_.m_93079_();
    }

    @Override
    public int invulnTime() {
        return this.minecraft.f_91074_.f_19802_;
    }

    @Override
    public long millis() {
        return Util.m_137550_();
    }

    @Override
    public float health() {
        return this.minecraft.f_91074_.m_21223_();
    }

    @Override
    public float maxHealth() {
        return this.minecraft.f_91074_.m_21233_();
    }

    @Override
    public float absorption() {
        return this.minecraft.f_91074_.m_6103_();
    }

    @Override
    public float percentFrozen() {
        return this.minecraft.f_91074_.m_146889_();
    }

    @Override
    public IEffectProvider effects() {
        return EffectProviderImpl.INSTANCE;
    }

    @Override
    public IEnchantmentProvider enchantments() {
        return EnchantmentProviderImpl.INSTANCE;
    }

    @Override
    public boolean hidden() {
        return this.minecraft.f_91066_.f_92062_;
    }

    @Override
    public boolean isPotionCoreLoaded() {
        return false;
    }

    @Override
    public boolean isFullyFrozen() {
        return this.minecraft.f_91074_.m_146890_();
    }

    @Override
    public boolean isHardcore() {
        return this.minecraft.f_91073_.m_6106_().m_5466_();
    }

    @Override
    public boolean isEffectActive(String id) {
        try {
            return (Boolean)this.effectActiveCache.get((Object)id, () -> {
                ResourceLocation loc = new ResourceLocation(id);
                return ForgeRegistries.MOB_EFFECTS.containsKey(loc) && this.minecraft.f_91074_.m_21023_((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(loc));
            });
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @Override
    public boolean isEffectActive(IMobEffect effect) {
        return this.minecraft.f_91074_.m_21023_((MobEffect)effect.getEffect());
    }

    @Override
    public boolean shouldDrawSurvivalElements() {
        return this.minecraft.f_91072_.m_105205_() && this.minecraft.m_91288_() instanceof Player;
    }

    @Override
    public IMobEffectInstance getActiveEffect(IMobEffect effect) {
        return new MobEffectInstanceImpl(this.minecraft.f_91074_.m_21124_((MobEffect)effect.getEffect()));
    }

    @Override
    public IDataProvider.IPotionCore potionCore() {
        return PotionCoreImpl.INSTANCE;
    }

    @Override
    public Iterable<IItemStack> armorSlots() {
        return ItemStackImpl.wrap(this.minecraft.f_91074_.m_6168_());
    }
}

