/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.impl;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.cheos.armorpointspp.config.ApppConfig;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.adapter.IPoseStack;
import dev.cheos.armorpointspp.core.adapter.IRenderer;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;
import dev.cheos.armorpointspp.impl.PoseStackImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.common.util.Lazy;
import org.joml.Matrix4f;

public class RendererImpl
implements IRenderer {
    private static final ResourceLocation ICONS = new ResourceLocation("armorpointspp", "textures/gui/" + ITextureSheet.defaultSheet().texLocation() + ".png");
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final Lazy<ForgeGui> gui = Lazy.of(() -> (ForgeGui)this.minecraft.f_91065_);
    private ResourceLocation tex;

    @Override
    public void blit(IPoseStack poseStack, int x, int y, float u, float v, int width, int height, int texWidth, int texHeight) {
        ((PoseStackImpl)poseStack).getGraphics().m_280163_(this.tex, x, y, u, v, width, height, texWidth, texHeight);
    }

    @Override
    public void blit(IPoseStack poseStack, int x, int y, float u, float v, int width, int height) {
        this.blit(poseStack, x, y, u, v, width, height, 256, 128);
    }

    @Override
    public void blitM(IPoseStack poseStack, int x, int y, float u, float v, int width, int height, int texWidth, int texHeight) {
        Matrix4f mat = ((PoseStack)poseStack.getPoseStack()).m_85850_().m_252922_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.tex);
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(mat, (float)x, (float)y, 0.0f).m_7421_((u + (float)width) / (float)texWidth, v / (float)texHeight).m_5752_();
        bufferbuilder.m_252986_(mat, (float)x, (float)(y + height), 0.0f).m_7421_((u + (float)width) / (float)texWidth, (v + (float)height) / (float)texHeight).m_5752_();
        bufferbuilder.m_252986_(mat, (float)(x + width), (float)(y + height), 0.0f).m_7421_(u / (float)texWidth, (v + (float)height) / (float)texHeight).m_5752_();
        bufferbuilder.m_252986_(mat, (float)(x + width), (float)y, 0.0f).m_7421_(u / (float)texWidth, v / (float)texHeight).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    @Override
    public void blitM(IPoseStack poseStack, int x, int y, float u, float v, int width, int height) {
        this.blitM(poseStack, x, y, u, v, width, height, 256, 128);
    }

    @Override
    public void setColor(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    @Override
    public void setupAppp() {
        ((ForgeGui)this.gui.get()).setupOverlayRenderState(true, false);
        this.tex = ICONS;
    }

    @Override
    public void setupTexture(ITextureSheet texSheet) {
        ResourceLocation location = texSheet.texLocation().indexOf(58) == -1 ? new ResourceLocation("armorpointspp", "textures/gui/" + texSheet.texLocation() + ".png") : new ResourceLocation(texSheet.texLocation());
        ((ForgeGui)this.gui.get()).setupOverlayRenderState(true, false);
        this.tex = this.minecraft.m_91098_().m_213713_(location).isPresent() ? location : ICONS;
    }

    @Override
    public void setupVanilla() {
        ((ForgeGui)this.gui.get()).setupOverlayRenderState(true, false);
        this.tex = Gui.f_279580_;
    }

    @Override
    public void text(IPoseStack poseStack, String text, float x, float y, int color, IRenderer.TextRenderType renderType) {
        this.text(poseStack, text, x, y, color, renderType, ApppConfig.instance().bool(IConfig.BooleanOption.TEXT_SHADOW));
    }

    @Override
    public void text(IPoseStack poseStack, String text, float x, float y, int color, IRenderer.TextRenderType renderType, boolean shadow) {
        ((PoseStackImpl)poseStack).getGraphics().m_280614_(this.minecraft.f_91062_, RendererImpl.comp(renderType, text), (int)x, (int)y, color, shadow);
    }

    @Override
    public int width(Object ... objs) {
        if (objs == null) {
            return 0;
        }
        if (objs.length == 1) {
            return this.minecraft.f_91062_.m_92895_(String.valueOf(objs[0]));
        }
        StringBuilder s = new StringBuilder();
        for (Object obj : objs) {
            s.append(obj);
        }
        return this.minecraft.f_91062_.m_92895_(s.toString());
    }

    private static Component comp(IRenderer.TextRenderType type, String text) {
        return type == IRenderer.TextRenderType.LANG ? Component.m_237115_((String)text) : Component.m_237113_((String)text);
    }
}

