/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.mixin;

import dev.cheos.armorpointspp.Overlays;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.render.Components;
import dev.cheos.armorpointspp.mixin.HealthStateMixin;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerTabOverlay.class})
public class PlayerTabOverlayMixin {
    @Shadow
    private Map<UUID, PlayerTabOverlay.HealthState> f_244278_;
    @Shadow
    private Gui f_94520_;

    @Inject(method={"renderTablistScore"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTablistScore(Objective obj, int y, String name, int x, int maxX, UUID player, GuiGraphics graphics, CallbackInfo ci) {
        int score = obj.m_83313_().m_83471_(name, obj).m_83400_();
        PlayerTabOverlay.HealthState state = this.f_244278_.computeIfAbsent(player, k -> new PlayerTabOverlay.HealthState(score));
        HealthStateMixin extState = (HealthStateMixin)state;
        state.m_245265_(score, (long)this.f_94520_.m_93079_());
        RenderContext ctx = Overlays.ctx(graphics, x, y);
        ctx.putProperty("score", score);
        ctx.putProperty("rendertype.hearts", obj.m_83324_() == ObjectiveCriteria.RenderType.HEARTS);
        ctx.putProperty("visibilityid", 0L);
        ctx.putProperty("player.rendervisibilityid", 0L);
        ctx.putProperty("player.lasthealthtime", extState.getLastUpdateTick());
        ctx.putProperty("player.healthblinktime", extState.getBlinkUntilTick());
        ctx.putProperty("player.lasthealth", extState.getLastValue());
        ctx.putProperty("player.displayhealth", state.m_247739_());
        ctx.putProperty("player.setlasthealthtime", PlayerTabOverlayMixin.nil());
        ctx.putProperty("player.sethealthblinktime", PlayerTabOverlayMixin.nil());
        ctx.putProperty("player.setrendervisibilityid", PlayerTabOverlayMixin.nil());
        ctx.putProperty("player.setlasthealth", PlayerTabOverlayMixin.nil());
        ctx.putProperty("player.setdisplayhealth", PlayerTabOverlayMixin.nil());
        ctx.putProperty("chatformatting.yellow", ChatFormatting.YELLOW.toString());
        ctx.putProperty("maxX", maxX);
        if (Components.TABLIST_SCORE.render(ctx)) {
            ci.cancel();
        }
    }

    private static <T> Consumer<T> nil() {
        return v -> {};
    }
}

