/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.registry;

import com.legacy.dungeons_plus.registry.DPDamageTypes;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class DPDamageSources {
    @Nullable
    public static DPDamageSources instance;
    private final Registry<DamageType> damageTypes;
    private final DamageSource consumeSoul;

    public DPDamageSources(RegistryAccess registryAccess) {
        this.damageTypes = registryAccess.m_175515_(Registries.f_268580_);
        this.consumeSoul = this.source((ResourceKey<DamageType>)DPDamageTypes.CONSUME_SOUL.getKey());
    }

    private DamageSource source(ResourceKey<DamageType> type) {
        return new DamageSource((Holder)this.damageTypes.m_246971_(type));
    }

    private DamageSource source(ResourceKey<DamageType> type, @Nullable Entity causingEntity) {
        return new DamageSource((Holder)this.damageTypes.m_246971_(type), causingEntity);
    }

    private DamageSource source(ResourceKey<DamageType> type, @Nullable Entity directEntity, @Nullable Entity causingEntity) {
        return new DamageSource((Holder)this.damageTypes.m_246971_(type), directEntity, causingEntity);
    }

    public DamageSource consumeSoul() {
        return this.consumeSoul;
    }

    public DamageSource thrownItem(Entity directEntity, @Nullable Entity causingEntity, ItemStack thrownItem) {
        return new ThrownItemDamageSource((Holder<DamageType>)this.damageTypes.m_246971_(DPDamageTypes.WARPED_AXE.getKey()), directEntity, causingEntity, thrownItem);
    }

    public static class ThrownItemDamageSource
    extends DamageSource {
        @Nullable
        private final ItemStack thrownItem;

        public ThrownItemDamageSource(Holder<DamageType> type, @Nullable Entity directEntity, @Nullable Entity causingEntity, @Nullable ItemStack thrownItem) {
            super(type, directEntity, causingEntity);
            this.thrownItem = thrownItem;
        }

        public Component m_6157_(LivingEntity killedEntity) {
            Component attackerName = this.m_7639_() == null ? this.m_7640_().m_5446_() : this.m_7639_().m_5446_();
            ItemStack stack = this.thrownItem == null ? ItemStack.f_41583_ : this.thrownItem;
            String msg = "death.attack." + this.m_19385_();
            String msgWithItem = msg + ".item";
            return !stack.m_41619_() && stack.m_41788_() ? Component.m_237110_((String)msgWithItem, (Object[])new Object[]{killedEntity.m_5446_(), attackerName, stack.m_41611_()}) : Component.m_237110_((String)msg, (Object[])new Object[]{killedEntity.m_5446_(), attackerName});
        }
    }
}

