/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.capabilities;

import com.peeko32213.unusualprehistory.UnusualPrehistory;
import com.peeko32213.unusualprehistory.common.capabilities.UPCapabilities;
import com.peeko32213.unusualprehistory.common.entity.IHatchableEntity;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseAquaticAnimal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityTameableBaseDinosaurAnimal;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class UPAnimalCapability
implements INBTSerializable<CompoundTag> {
    private String embryoAnimal = "";
    private int timer = 0;
    private static final String BASE_EMBRYO = "";
    private static final int RESET_TIMER = 0;

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("animal", this.embryoAnimal);
        nbt.m_128405_("timer", this.timer);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.embryoAnimal = nbt.m_128461_("animal");
        this.timer = nbt.m_128451_("timer");
    }

    public static void tickAnimal(LivingEvent.LivingTickEvent event) {
        if (!(event.getEntity() instanceof Animal) || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)event.getEntity().m_9236_();
        LazyOptional animalCap = event.getEntity().getCapability(UPCapabilities.ANIMAL_CAPABILITY);
        animalCap.ifPresent(capability -> {
            if (capability.embryoAnimal == null || capability.getEmbryoAnimal().equals(BASE_EMBRYO)) {
                return;
            }
            if (capability.timer > 0) {
                --capability.timer;
                return;
            }
            if (capability.embryoAnimal != null && !capability.embryoAnimal.equals(BASE_EMBRYO)) {
                IHatchableEntity animal;
                ResourceLocation entityRl = new ResourceLocation(capability.embryoAnimal);
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityRl);
                LivingEntity livingEntity = (LivingEntity)entityType.m_20615_((Level)serverLevel);
                livingEntity.m_146884_(event.getEntity().m_20182_());
                livingEntity.m_20084_(UUID.randomUUID());
                if (livingEntity instanceof EntityTameableBaseDinosaurAnimal) {
                    animal = (EntityTameableBaseDinosaurAnimal)livingEntity;
                    animal.m_146762_(-24000);
                    ((EntityTameableBaseDinosaurAnimal)animal).determineVariant(1);
                }
                if (livingEntity instanceof EntityBaseDinosaurAnimal) {
                    animal = (EntityBaseDinosaurAnimal)livingEntity;
                    animal.m_146762_(-24000);
                    ((EntityBaseDinosaurAnimal)animal).determineVariant(1);
                }
                if (livingEntity instanceof EntityBaseAquaticAnimal) {
                    animal = (EntityBaseAquaticAnimal)livingEntity;
                    ((EntityBaseAquaticAnimal)animal).determineVariant(1);
                }
                serverLevel.m_7967_((Entity)livingEntity);
                capability.setEmbryoAnimal(BASE_EMBRYO);
                capability.setTimer(0);
            } else {
                UnusualPrehistory.LOGGER.error("Embryo is incorrect for {}", (Object)event.getEntity());
            }
        });
    }

    public static void tickWaterAnimal(LivingEvent.LivingTickEvent event) {
        if (!(event.getEntity() instanceof WaterAnimal) || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)event.getEntity().m_9236_();
        LazyOptional animalCap = event.getEntity().getCapability(UPCapabilities.ANIMAL_CAPABILITY);
        animalCap.ifPresent(capability -> {
            if (capability.embryoAnimal == null || capability.getEmbryoAnimal().equals(BASE_EMBRYO)) {
                return;
            }
            if (capability.timer > 0) {
                --capability.timer;
                return;
            }
            if (capability.embryoAnimal != null && !capability.embryoAnimal.equals(BASE_EMBRYO)) {
                IHatchableEntity animal;
                ResourceLocation entityRl = new ResourceLocation(capability.embryoAnimal);
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityRl);
                LivingEntity livingEntity = (LivingEntity)entityType.m_20615_((Level)serverLevel);
                livingEntity.m_146884_(event.getEntity().m_20182_());
                livingEntity.m_20084_(UUID.randomUUID());
                if (livingEntity instanceof EntityTameableBaseDinosaurAnimal) {
                    animal = (EntityTameableBaseDinosaurAnimal)livingEntity;
                    animal.m_146762_(-24000);
                    ((EntityTameableBaseDinosaurAnimal)animal).determineVariant(1);
                }
                if (livingEntity instanceof EntityBaseDinosaurAnimal) {
                    animal = (EntityBaseDinosaurAnimal)livingEntity;
                    animal.m_146762_(-24000);
                    ((EntityBaseDinosaurAnimal)animal).determineVariant(1);
                }
                if (livingEntity instanceof EntityBaseAquaticAnimal) {
                    animal = (EntityBaseAquaticAnimal)livingEntity;
                    ((EntityBaseAquaticAnimal)animal).determineVariant(1);
                }
                serverLevel.m_7967_((Entity)livingEntity);
                capability.setEmbryoAnimal(BASE_EMBRYO);
                capability.setTimer(0);
            } else {
                UnusualPrehistory.LOGGER.error("Embryo is incorrect for {}", (Object)event.getEntity());
            }
        });
    }

    public void setEmbryoAnimal(String embryoAnimal) {
        this.embryoAnimal = embryoAnimal;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public String getEmbryoAnimal() {
        return this.embryoAnimal;
    }

    public int getTimer() {
        return this.timer;
    }
}

