/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.peeko32213.unusualprehistory.common.data.LootFruitCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootFruitJsonManager
extends SimpleJsonResourceReloadListener {
    private static final Gson STANDARD_GSON = new Gson();
    public static final Logger LOGGER = LogManager.getLogger();
    public static Map<Item, List<LootFruitCodec>> trades = new HashMap<Item, List<LootFruitCodec>>();
    public static Map<Integer, List<LootFruitCodec>> tierTrades = new HashMap<Integer, List<LootFruitCodec>>();
    private final String folderName;

    public LootFruitJsonManager() {
        this("unusualprehistory/trades", STANDARD_GSON);
    }

    public LootFruitJsonManager(String folderName, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
    }

    public static Map<Item, List<LootFruitCodec>> getTrades() {
        return trades;
    }

    public static Map<Integer, List<LootFruitCodec>> getTierTrades() {
        return tierTrades;
    }

    public static void setTierTrades(Map<Integer, List<LootFruitCodec>> tierTrades) {
        LootFruitJsonManager.tierTrades = tierTrades;
    }

    public static void setTrades(Map<Item, List<LootFruitCodec>> trades) {
        LootFruitJsonManager.trades = trades;
    }

    public static List<LootFruitCodec> getLoot(Item item, List<LootFruitCodec> lootFruitCodecList) {
        return trades.getOrDefault(item, lootFruitCodecList);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        tierTrades.clear();
        trades.clear();
        HashMap trades = new HashMap();
        HashMap tradeTier = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            LootFruitCodec.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                LootFruitCodec lootFruitCodec = (LootFruitCodec)result.getFirst();
                List lootFruitCodecList = trades.getOrDefault(lootFruitCodec.getTradeItem(), new ArrayList());
                lootFruitCodecList.add(lootFruitCodec);
                trades.put(lootFruitCodec.getTradeItem(), lootFruitCodecList);
                List lootFruitCodecTier = tradeTier.getOrDefault(lootFruitCodec.getTier(), new ArrayList());
                lootFruitCodecTier.add(lootFruitCodec);
                tradeTier.put(lootFruitCodec.getTier(), lootFruitCodecTier);
            }).ifRight(partial -> LOGGER.error("Failed to parse recipe JSON for {} due to: {}", (Object)this.folderName, (Object)partial.message()));
        }
        LootFruitJsonManager.trades.putAll(trades);
        tierTrades.putAll(tradeTier);
        LOGGER.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)LootFruitJsonManager.trades.size());
    }
}

