/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.entity.msc.baby.EntityBeelzebufoTadpole;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRideGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityBeelzebufo
extends EntityBaseDinosaurAnimal
implements PlayerRideableJumping {
    private static final EntityDataAccessor<Byte> DATA_FLAG = SynchedEntityData.m_135353_(EntityBeelzebufo.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> IS_SWALLOWING = SynchedEntityData.m_135353_(EntityBeelzebufo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42579_, Items.f_42485_, Items.f_42581_});
    protected float playerJumpPendingScale;
    private boolean allowStandSliding;
    private int standCounter;
    protected boolean isJumping;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation BEELZE_BITE = RawAnimation.begin().thenLoop("animation.beelzebufo.bite");
    private static final RawAnimation BEELZE_WALK = RawAnimation.begin().thenLoop("animation.beelzebufo.walk");
    private static final RawAnimation BEELZE_SWIM = RawAnimation.begin().thenLoop("animation.beelzebufo.swim");
    private static final RawAnimation BEELZE_JUMP = RawAnimation.begin().thenPlay("animation.beelzebufo.jump");
    private static final RawAnimation BEELZE_JUMP_HOLD = RawAnimation.begin().thenLoop("animation.beelzebufo.jump_hold");
    private static final RawAnimation BEELZE_IDLE = RawAnimation.begin().thenPlay("animation.beelzebufo.idle");
    private int eatCooldown = 0;

    public EntityBeelzebufo(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22288_, 1.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new CustomRideGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new EatFoodGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34){

            @Override
            public boolean m_8036_() {
                Vec3 vec3d;
                if (this.f_25725_.m_20160_()) {
                    return false;
                }
                if (!this.f_25731_) {
                    if (this.f_25725_.m_21216_() >= 100) {
                        return false;
                    }
                    if (((EntityBeelzebufo)this.f_25725_).isHungry() ? this.f_25725_.m_217043_().m_188503_(60) != 0 : this.f_25725_.m_217043_().m_188503_(30) != 0) {
                        return false;
                    }
                }
                if ((vec3d = this.m_7037_()) == null) {
                    return false;
                }
                this.f_25726_ = vec3d.f_82479_;
                this.f_25727_ = vec3d.f_82480_;
                this.f_25728_ = vec3d.f_82481_;
                this.f_25731_ = false;
                return true;
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAG, (Object)0);
        this.f_19804_.m_135372_(IS_SWALLOWING, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setIsSwallowing(compound.m_128471_("swallowing"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("swallowing", this.isSwallowing());
    }

    private void attack(LivingEntity entity) {
        entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if ((this.m_6109_() || this.m_21515_()) && this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
            this.setStanding(false);
        }
        if (this.m_20096_() && this.isJumping()) {
            this.setIsJumping(false);
        }
        if (this.eatCooldown > 0) {
            --this.eatCooldown;
        }
    }

    public void m_7023_(Vec3 p_30633_) {
        if (this.m_6084_()) {
            LivingEntity livingentity = this.m_6688_();
            if (this.m_20160_() && this.isSaddled() && livingentity != null) {
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (this.m_20096_() && this.playerJumpPendingScale == 0.0f && this.isStanding() && !this.allowStandSliding) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.m_20096_()) {
                    double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + (double)this.m_285755_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.setIsJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.f_146794_ = this.m_6113_() * 0.1f;
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)f, p_30633_.f_82480_, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.m_20096_()) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setIsJumping(false);
                }
                this.m_267651_(false);
                this.m_146872_();
            } else {
                this.f_146794_ = 0.02f;
                super.m_7023_(p_30633_);
            }
        }
    }

    @Override
    public boolean m_7327_(Entity target) {
        boolean shouldHurt;
        LivingEntity livingEntity;
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        if (target instanceof LivingEntity) {
            livingEntity = (LivingEntity)target;
            damage += livingEntity.m_6336_().equals(MobType.f_21642_) ? damage : 0.0f;
            knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if (shouldHurt = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage)) {
            if (knockback > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, target);
            this.m_21335_(target);
        }
        if (shouldHurt && target instanceof LivingEntity) {
            livingEntity = (LivingEntity)target;
            this.m_5496_((SoundEvent)UPSounds.BEELZE_ATTACK.get(), 0.1f, 1.0f);
            if (this.f_19796_.m_188503_(15) == 0 && this.m_5448_() instanceof LivingEntity) {
                this.m_19998_((ItemLike)UPItems.FROG_SALIVA.get());
            }
        }
        return shouldHurt;
    }

    @Nullable
    public LivingEntity m_6688_() {
        for (Entity passenger : this.m_20197_()) {
            Player player;
            if (!(passenger instanceof Player) || (player = (Player)passenger).m_21205_().m_41720_() != UPItems.MEAT_ON_A_STICK.get() && player.m_21206_().m_41720_() != UPItems.MEAT_ON_A_STICK.get()) continue;
            return player;
        }
        return null;
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        float ySin = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float yCos = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        pPassenger.m_6034_(this.m_20185_() + (double)(0.5f * ySin), this.m_20186_() + this.m_6048_() + pPassenger.m_6049_() - (double)0.1f, this.m_20189_() - (double)(0.5f * yCos));
    }

    public double m_6048_() {
        if (this.m_20069_()) {
            return 0.3;
        }
        return 0.65;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (hand == InteractionHand.MAIN_HAND) {
            if (item == Items.f_42450_ && !this.isSaddled()) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.setSaddled(true);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == Items.f_42574_ && this.isSaddled()) {
                this.setSaddled(false);
                this.m_19998_((ItemLike)Items.f_42450_);
                return InteractionResult.SUCCESS;
            }
            if (!this.m_6898_(itemstack) && !player.m_6144_() && this.isSaddled()) {
                if (!this.m_9236_().f_46443_) {
                    player.m_20329_((Entity)this);
                    player.m_213846_((Component)Component.m_237115_((String)"unusualprehistory.beelzebufo.meat_stick").m_130940_(ChatFormatting.WHITE));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean isFood(Entity entity) {
        return entity instanceof Mob && !(entity instanceof EntityBeelzebufo) && entity.m_20206_() <= 1.0f || entity instanceof ItemEntity && ((ItemEntity)entity).m_32055_().m_150930_(Items.f_42485_);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42485_;
    }

    private Vec3 getMouthVec() {
        Vec3 vec3 = new Vec3(0.0, (double)(this.m_20206_() * 0.25f), (double)(this.m_20205_() * 0.8f)).m_82496_(this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
        return this.m_20182_().m_82549_(vec3);
    }

    public boolean swallowEntity(Entity entity) {
        this.setIsSwallowing(true);
        if (entity instanceof LivingEntity) {
            LivingEntity mob = (LivingEntity)entity;
            if (!entity.m_9236_().f_46443_) {
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)entity.m_9236_()), (Vec3)entity.m_20182_(), (int)((LivingEntity)entity).m_213860_());
                mob.m_142687_(Entity.RemovalReason.KILLED);
                this.m_19998_((ItemLike)UPItems.FROG_SALIVA.get());
            }
            this.m_146850_(GameEvent.f_157806_);
            this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
            this.setHungry(false);
            return true;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            this.m_7581_(item);
        }
        return false;
    }

    protected void m_7581_(ItemEntity itemEntity) {
        if (this.isHungry()) {
            this.m_21053_(itemEntity);
            this.m_7938_((Entity)itemEntity, 1);
            itemEntity.m_146870_();
            this.m_19998_((ItemLike)UPItems.FROG_SALIVA.get());
            this.m_146850_(GameEvent.f_157806_);
            this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
            this.setHungry(false);
        }
    }

    @Override
    public boolean m_8023_() {
        return super.m_8023_() || this.m_8077_();
    }

    @Override
    public boolean m_6785_(double d) {
        return !this.m_8077_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.BEELZE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.BEELZE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.BEELZE_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_215696_, 0.1f, 1.0f);
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 10;
    }

    @Override
    protected boolean canGetHungry() {
        return true;
    }

    @Override
    protected boolean hasTargets() {
        return true;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return true;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return UPTags.BEELZE_TARGETS;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.isSaddled() && !this.m_9236_().f_46443_) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
        this.setSaddled(false);
    }

    protected <E extends EntityBeelzebufo> PlayState Controller(AnimationState<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (this.isSwallowing()) {
            event.setAndContinue(BEELZE_BITE);
            event.getController().setAnimationSpeed(0.9);
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.isJumping && !this.m_20069_()) {
            event.setAndContinue(BEELZE_WALK);
            event.getController().setAnimationSpeed(0.8);
            return PlayState.CONTINUE;
        }
        if (this.m_20069_() && !this.isJumping()) {
            event.setAndContinue(BEELZE_SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.isJumping()) {
            event.setAndContinue(BEELZE_JUMP);
            return PlayState.CONTINUE;
        }
        event.setAndContinue(BEELZE_IDLE);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public double getTick(Object o) {
        return this.f_19797_;
    }

    public void m_7888_(int p_30591_) {
        if (this.isSaddled()) {
            if (p_30591_ < 0) {
                p_30591_ = 0;
            } else {
                this.allowStandSliding = true;
                this.stand();
            }
            this.playerJumpPendingScale = p_30591_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_30591_ / 90.0f;
        }
    }

    public void setStanding(boolean p_30666_) {
        this.setFlag(32, p_30666_);
    }

    private void stand() {
        if (this.m_6109_() || this.m_21515_()) {
            this.standCounter = 1;
            this.setStanding(true);
        }
    }

    protected boolean getFlag(int p_30648_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAG) & p_30648_) != 0;
    }

    public boolean isStanding() {
        return this.getFlag(32);
    }

    protected void setFlag(int p_30598_, boolean p_30599_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAG);
        if (p_30599_) {
            this.f_19804_.m_135381_(DATA_FLAG, (Object)((byte)(b0 | p_30598_)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAG, (Object)((byte)(b0 & ~p_30598_)));
        }
    }

    public boolean isSwallowing() {
        return (Boolean)this.f_19804_.m_135370_(IS_SWALLOWING);
    }

    public void setIsSwallowing(boolean swallowing) {
        this.f_19804_.m_135381_(IS_SWALLOWING, (Object)swallowing);
    }

    public boolean m_7132_() {
        return this.isSaddled();
    }

    public void m_7199_(int p_21695_) {
        this.allowStandSliding = true;
        this.stand();
    }

    public void m_8012_() {
    }

    protected double generateRandomJumpStrength() {
        return (double)0.4f + this.f_19796_.m_188500_() * 0.2 + this.f_19796_.m_188500_() * 0.2 + this.f_19796_.m_188500_() * 0.2;
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean p_30656_) {
        this.isJumping = p_30656_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    @Override
    public boolean m_142535_(float p_149499_, float p_149500_, DamageSource p_149501_) {
        int i = this.m_5639_(p_149499_, p_149500_);
        if (i <= 0) {
            return false;
        }
        this.m_6469_(p_149501_, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(p_149501_, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    protected int m_5639_(float p_149389_, float p_149390_) {
        return super.m_5639_(p_149389_, p_149390_) - 10;
    }

    class EatFoodGoal
    extends Goal {
        private final EntityBeelzebufo beelzebufo;
        private Entity food;
        private int executionCooldown = 50;

        public EatFoodGoal(EntityBeelzebufo beelzebufo) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.beelzebufo = beelzebufo;
        }

        public boolean m_8036_() {
            if (this.beelzebufo.eatCooldown > 0) {
                return false;
            }
            if (this.executionCooldown > 0) {
                --this.executionCooldown;
            } else {
                this.executionCooldown = 50 + EntityBeelzebufo.this.f_19796_.m_188503_(50);
                if (this.beelzebufo.isHungry()) {
                    List list = this.beelzebufo.m_9236_().m_6443_(Entity.class, this.beelzebufo.m_20191_().m_82377_(8.0, 8.0, 8.0), EntitySelector.f_20408_.and(entity -> entity != this.beelzebufo && this.beelzebufo.isFood((Entity)entity) && !(entity instanceof EntityBeelzebufoTadpole)));
                    list.sort(Comparator.comparingDouble(arg_0 -> ((EntityBeelzebufo)this.beelzebufo).m_20280_(arg_0)));
                    if (!list.isEmpty()) {
                        this.food = (Entity)list.get(0);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean m_8045_() {
            return this.food != null && this.food.m_6084_() && !this.beelzebufo.isHungry();
        }

        public void m_8041_() {
            this.executionCooldown = 5;
            EntityBeelzebufo.this.setIsSwallowing(false);
        }

        public void m_8037_() {
            this.beelzebufo.m_21573_().m_26519_(this.food.m_20185_(), this.food.m_20227_(0.5), this.food.m_20189_(), 1.0);
            this.beelzebufo.m_21391_(this.food, 10.0f, 10.0f);
            float eatDist = this.beelzebufo.m_20205_() * 0.65f + this.food.m_20205_();
            if (this.beelzebufo.m_20270_(this.food) < eatDist + 3.0f && this.beelzebufo.m_142582_(this.food) && this.beelzebufo.m_20270_(this.food) < eatDist) {
                if (this.food instanceof Player) {
                    this.food.m_6469_(this.beelzebufo.m_269291_().m_269333_((LivingEntity)this.beelzebufo), 12000.0f);
                } else if (this.beelzebufo.swallowEntity(this.food)) {
                    this.beelzebufo.m_146850_(GameEvent.f_157806_);
                    this.beelzebufo.m_5496_(SoundEvents.f_11912_, this.beelzebufo.m_6121_(), this.beelzebufo.m_6100_());
                    this.food.m_146870_();
                }
            }
        }
    }

    class IMeleeAttackGoal
    extends MeleeAttackGoal {
        public IMeleeAttackGoal(EntityBeelzebufo beelzebufo) {
            super((PathfinderMob)beelzebufo, 1.0, true);
        }

        protected double getAttackReachSqr(Entity p_25556_) {
            return this.f_25540_.m_20205_() * 2.0f * this.f_25540_.m_20205_() * 0.66f + p_25556_.m_20205_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                ((EntityBeelzebufo)this.f_25540_).setHungry(false);
                ((EntityBeelzebufo)this.f_25540_).attack(enemy);
                ((EntityBeelzebufo)this.f_25540_).setTimeTillHungry(this.f_25540_.m_217043_().m_188503_(100) + 100);
            }
        }
    }
}

