/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity.msc.baby;

import com.peeko32213.unusualprehistory.common.entity.EntityMegalania;
import com.peeko32213.unusualprehistory.common.entity.msc.util.BabyPanicGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.LandCreaturePathNavigation;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityTameableBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EntityBabyMegalania
extends EntityTameableBaseDinosaurAnimal {
    public static final int MAX_TADPOLE_AGE = Math.abs(-30000);
    public static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42581_});
    private int age;
    private static final RawAnimation BABY_WALK = RawAnimation.begin().thenLoop("animation.baby_megalania.walk");
    private static final RawAnimation BABY_IDLE = RawAnimation.begin().thenLoop("animation.baby_megalania.idle");
    private static final RawAnimation BABY_SWIM = RawAnimation.begin().thenLoop("animation.baby_megalania.swim");

    public EntityBabyMegalania(EntityType<? extends EntityTameableBaseDinosaurAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new LandCreaturePathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.18);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected void performAttack() {
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_146762_(this.age + 1);
        }
        super.m_8107_();
    }

    public InteractionResult m_6071_(Player p_218703_, InteractionHand p_218704_) {
        ItemStack itemstack = p_218703_.m_21120_(p_218704_);
        if (this.m_6898_(itemstack)) {
            this.eatFood(p_218703_, itemstack);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    private void eatFood(Player player, ItemStack stack) {
        this.decrementItem(player, stack);
        this.increaseAge((int)((float)(this.getTicksUntilGrowth() / 20) * 0.1f));
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
    }

    private void decrementItem(Player player, ItemStack stack) {
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
    }

    @Override
    public void m_7380_(CompoundTag p_218709_) {
        super.m_7380_(p_218709_);
        p_218709_.m_128405_("Age", this.age);
    }

    @Override
    public void m_7378_(CompoundTag p_218698_) {
        super.m_7378_(p_218698_);
        this.m_146762_(p_218698_.m_128451_("Age"));
    }

    public boolean isHotBiome() {
        if (this.m_21525_()) {
            return false;
        }
        if (this.m_9236_().m_46472_() == Level.f_46429_) {
            return true;
        }
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        return this.m_9236_().m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_263828_);
    }

    public boolean isColdBiome() {
        if (this.m_21525_()) {
            return false;
        }
        if (this.m_9236_().m_46472_() == Level.f_46429_) {
            return false;
        }
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        return ((Biome)this.m_9236_().m_204166_(new BlockPos(i, 0, k)).m_203334_()).m_198904_(new BlockPos(i, j, k));
    }

    private void setColdVariant() {
        this.setVariant(1);
    }

    private void setHotVariant() {
        this.setVariant(2);
    }

    private void setNetherVariant() {
        this.setVariant(3);
    }

    private void setNormalVariant() {
        this.setVariant(0);
    }

    @Override
    public void determineVariant(int variantChange) {
        if (this.m_9236_().m_46472_() == Level.f_46429_) {
            this.setNetherVariant();
        }
        if (this.isHotBiome()) {
            this.setHotVariant();
        } else if (this.isColdBiome()) {
            this.setColdVariant();
        } else {
            this.setNormalVariant();
        }
    }

    private void increaseAge(int seconds) {
        this.m_146762_(this.age + seconds * 20);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public void m_146762_(int age) {
        this.age = age;
        if (this.age >= MAX_TADPOLE_AGE) {
            this.growUp();
        }
    }

    private void growUp() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            EntityMegalania frog = (EntityMegalania)((EntityType)UPEntities.MEGALANIA.get()).m_20615_(this.m_9236_());
            if (frog == null) {
                return;
            }
            frog.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            frog.m_6518_((ServerLevelAccessor)server, this.m_9236_().m_6436_(frog.m_20183_()), MobSpawnType.CONVERSION, null, null);
            frog.m_21557_(this.m_21525_());
            frog.setVariant(this.getVariant());
            if (this.m_8077_()) {
                frog.m_6593_(this.m_7770_());
                frog.m_20340_(this.m_20151_());
            }
            frog.m_21530_();
            this.m_5496_(SoundEvents.f_12275_, 0.15f, 1.0f);
            server.m_47205_((Entity)frog);
            this.m_146870_();
        }
    }

    @Override
    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    private int getTicksUntilGrowth() {
        return Math.max(0, MAX_TADPOLE_AGE - this.age);
    }

    public boolean m_6149_() {
        return false;
    }

    protected <E extends EntityBabyMegalania> PlayState Controller(AnimationState<E> event) {
        if (this.m_20069_()) {
            event.setAndContinue(BABY_SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            event.setAndContinue(BABY_WALK);
            event.getController().setAnimationSpeed(1.5);
        } else {
            event.setAndContinue(BABY_IDLE);
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    @Override
    public double getTick(Object o) {
        return this.f_19797_;
    }
}

