/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.item;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class DinosaurWhistle
extends Item {
    private Supplier<? extends EntityType> toWhistle;
    private final int MAX_DISTANCE = 64;

    public DinosaurWhistle(Item.Properties pProperties, Supplier<? extends EntityType> toWhistle) {
        super(pProperties);
        this.toWhistle = toWhistle;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (itemStack.m_41782_()) {
            CompoundTag tag = itemStack.m_41783_();
            int currentCommand = tag.m_128451_("command");
            if (pPlayer.m_6144_()) {
                if (currentCommand + 1 >= 2) {
                    tag.m_128405_("command", 0);
                } else {
                    tag.m_128405_("command", currentCommand + 1);
                }
                int currentCommand2 = tag.m_128451_("command");
                MutableComponent component = Component.m_237113_((String)String.valueOf(currentCommand2)).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.ITALIC);
                pPlayer.m_213846_((Component)Component.m_237115_((String)("unusualprehistory.barina_whistle.command_" + currentCommand2)).m_130940_(ChatFormatting.BLACK));
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            LivingEntity livingEntity = (LivingEntity)this.toWhistle.get().m_20615_(pLevel);
            List toWhistleList = pLevel.m_6249_((Entity)livingEntity, pPlayer.m_20191_().m_82400_(10.0), EntitySelector.f_20406_.and(entity -> entity.m_6095_() == this.toWhistle.get()));
            if (currentCommand == 0) {
                this.performMoveCommand(pLevel, pPlayer, toWhistleList, itemStack);
            }
            if (currentCommand == 1) {
                this.performAttackCommand(pLevel, pPlayer, toWhistleList, itemStack);
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public InteractionResultHolder<ItemStack> performMoveCommand(Level level, Player player, List<Entity> toWhistleList, ItemStack itemStack) {
        BlockPos blockPlayerIsLookingAt = level.m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_(64.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
        toWhistleList.forEach(dino -> {
            ((Mob)dino).m_6710_(null);
            ((Mob)dino).m_21573_().m_26519_((double)blockPlayerIsLookingAt.m_123341_(), (double)blockPlayerIsLookingAt.m_123342_(), (double)blockPlayerIsLookingAt.m_123343_(), 2.0);
        });
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public InteractionResultHolder<ItemStack> performAttackCommand(Level level, Player player, List<Entity> toWhistleList, ItemStack itemStack) {
        BlockPos blockPlayerIsLookingAt = level.m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_(64.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
        List enemies = level.m_6443_(LivingEntity.class, new AABB(blockPlayerIsLookingAt).m_82377_(10.0, 10.0, 10.0), EntitySelector.f_20406_).stream().filter(e -> !toWhistleList.contains(e)).collect(Collectors.toList());
        toWhistleList.forEach(dino -> {
            enemies.sort(Comparator.comparingDouble(arg_0 -> ((Entity)dino).m_20280_(arg_0)));
            if (!enemies.isEmpty()) {
                ((Mob)dino).m_6710_((LivingEntity)enemies.get(0));
                enemies.remove(0);
            }
        });
        for (int j = 0; j < 10; ++j) {
            level.m_6493_((ParticleOptions)new ShriekParticleOption(j * 10), true, (double)blockPlayerIsLookingAt.m_123341_() + 0.5, (double)blockPlayerIsLookingAt.m_123342_() + 0.3, (double)blockPlayerIsLookingAt.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }
}

