/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.item.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.peeko32213.unusualprehistory.client.model.tool.HandmadeClubModel;
import com.peeko32213.unusualprehistory.client.render.tool.ToolRenderer;
import com.peeko32213.unusualprehistory.common.entity.msc.projectile.ThrowableFallingBlockEntity;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemHandmadeClub
extends SwordItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ItemHandmadeClub(Tier tier, int attackDamage, float attackSpeed) {
        super(tier, attackDamage, attackSpeed, new Item.Properties().m_41487_(1).m_41499_(tier.m_6609_() * 3));
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level pLevel = pContext.m_43725_();
        if (pLevel.f_46443_) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = pContext.m_8083_();
        BlockState state = pLevel.m_8055_(pos);
        ServerLevel level = (ServerLevel)pLevel;
        if (state.m_60713_(Blocks.f_50752_) || !state.m_204336_(UPTags.CLUB_WHITELIST_BLOCKS)) {
            return InteractionResult.FAIL;
        }
        ThrowableFallingBlockEntity fallingBlockEntity = ThrowableFallingBlockEntity.fall((Level)level, pos, state);
        Vec3 vec3 = new Vec3(0.0, 1.0, 0.0);
        Vec3 vec31 = vec3.m_82541_();
        fallingBlockEntity.m_20256_(vec31);
        fallingBlockEntity.setHurtsEntities(1.0f, 10);
        return super.m_6225_(pContext);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)super.m_43299_(), AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-3.4f, AttributeModifier.Operation.ADDITION));
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final ToolRenderer renderer = new ToolRenderer<ItemHandmadeClub>(new HandmadeClubModel());

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> PlayState.CONTINUE).triggerableAnim("animation.handmade_club.idle", DefaultAnimations.IDLE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

