/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class IncubatorRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ResourceLocation output;
    private final NonNullList<Ingredient> recipeItems;

    public IncubatorRecipe(ResourceLocation id, ResourceLocation output, NonNullList<Ingredient> recipeItems) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return !this.recipeItems.isEmpty() && ((Ingredient)this.recipeItems.get(0)).test(pContainer.m_8020_(0));
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation getOutput() {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public boolean m_5598_() {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public static class Serializer
    implements RecipeSerializer<IncubatorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("unusualprehistory", "incubating");

        public IncubatorRecipe fromJson(ResourceLocation id, JsonObject json) {
            ResourceLocation output = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new IncubatorRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        public IncubatorRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ResourceLocation output = buf.m_130281_();
            return new IncubatorRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(FriendlyByteBuf buf, IncubatorRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.m_130085_(recipe.output);
        }
    }

    public static class Type
    implements RecipeType<IncubatorRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "incubating";

        private Type() {
        }
    }
}

