/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleHelper;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ShieldControlData;
import com.brandon3055.draconicevolution.api.modules.data.ShieldData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class ShieldControlEntity
extends ModuleEntity<ShieldControlData> {
    public static final Set<ResourceKey<DamageType>> UNBLOCKABLE = Sets.newHashSet((Object[])new ResourceKey[]{DamageTypes.f_268722_, DamageTypes.f_268441_, DamageTypes.f_268612_, DamageTypes.f_286979_});
    public static final HashMap<ResourceKey<DamageType>, Double> ENV_SOURCES = new HashMap();
    private BooleanProperty shieldEnabled;
    private BooleanProperty alwaysVisible;
    private ShieldData shieldCache;
    private long lastHitTime;
    private double passivePowerCache = 0.0;
    private double shieldPoints;
    private double shieldBoost;
    private double maxBoost;
    private int boostTime = 0;
    private int shieldCapacity;
    private int shieldCoolDown;
    private byte envDmgCoolDown = 0;
    private boolean shieldVisible;
    private float shieldAnim;
    private float shieldHitIndicator;
    private int shieldColour;
    private int tick;
    private boolean conflict = false;

    public ShieldControlEntity(Module<ShieldControlData> module) {
        super(module);
        this.shieldColour = ShieldControlEntity.getDefaultShieldColour(module.getModuleTechLevel());
        this.shieldEnabled = new BooleanProperty("shield_mod.enabled", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
        this.addProperty(this.shieldEnabled);
        this.alwaysVisible = new BooleanProperty("shield_mod.always_visible", true).setFormatter(ConfigProperty.BooleanFormatter.YES_NO);
        this.addProperty(this.alwaysVisible);
        this.savePropertiesToItem = true;
    }

    @Override
    public void tick(ModuleContext moduleContext) {
        boolean enabled;
        StackModuleContext context;
        IOPStorage storage;
        block25: {
            block24: {
                storage = moduleContext.getOpStorage();
                if (!(moduleContext instanceof StackModuleContext)) break block24;
                context = (StackModuleContext)moduleContext;
                if (EffectiveSide.get().isServer() && storage != null) break block25;
            }
            return;
        }
        if (this.tick++ % 10 == 0) {
            this.clearCaches();
        }
        ShieldData data = this.getShieldData(context.getEntity());
        this.shieldCapacity = data.shieldCapacity();
        double chargeRate = data.shieldRecharge();
        boolean bl = enabled = this.shieldEnabled.getValue() && this.getShieldPoints() > 0.0;
        if (this.shieldPoints > (double)this.shieldCapacity) {
            this.shieldPoints = this.shieldCapacity;
        }
        if (this.shieldHitIndicator > 0.0f) {
            this.shieldHitIndicator -= 0.1f;
        }
        boolean bl2 = this.shieldVisible = enabled && (this.alwaysVisible.getValue() || System.currentTimeMillis() - this.lastHitTime < 5000L);
        if (this.shieldVisible && this.shieldAnim < 1.0f) {
            this.shieldAnim = Math.min(this.shieldAnim + 0.05f, 1.0f);
        } else if (!this.shieldVisible && this.shieldAnim > 0.0f) {
            this.shieldAnim = Math.max(this.shieldAnim - 0.05f, 0.0f);
        }
        if (this.envDmgCoolDown > 0) {
            this.envDmgCoolDown = (byte)(this.envDmgCoolDown - 1);
        }
        if (!context.isEquipped()) {
            return;
        }
        if (this.conflict) {
            this.shieldCapacity = 0;
            this.shieldPoints = 0.0;
            return;
        }
        if (enabled && storage.getOPStored() > 0L) {
            double passiveDraw = this.shieldPoints * this.shieldPoints * EquipCfg.shieldPassiveModifier;
            if (passiveDraw > 0.0) {
                this.passivePowerCache += passiveDraw;
                if (this.passivePowerCache >= 1.0) {
                    storage.modifyEnergyStored((long)(-((int)this.passivePowerCache)));
                    this.passivePowerCache %= 1.0;
                }
            }
        } else if (enabled && this.shieldPoints > 0.0) {
            this.shieldPoints = Math.max(0.0, this.shieldPoints - (double)this.shieldCapacity / 1200.0);
        }
        if (this.shieldBoost > 0.0) {
            --this.boostTime;
            if (this.boostTime == 0) {
                this.shieldBoost = 0.0;
            }
        }
        if (!enabled) {
            chargeRate *= 1.25;
        }
        if (this.shieldCoolDown > 0) {
            this.shieldCoolDown = Math.max(0, this.shieldCoolDown - (enabled ? 100 : 125));
        } else if (this.shieldPoints < (double)this.shieldCapacity && this.shieldCapacity > 0 && chargeRate > 0.0 && storage.getOPStored() > 0L) {
            double energyPerPoint = Math.max(chargeRate * (double)EquipCfg.energyShieldChg, (double)EquipCfg.energyShieldChg);
            long extracted = storage.modifyEnergyStored((long)(-((int)Math.max(1.0, Math.min(chargeRate, (double)this.shieldCapacity - this.shieldPoints) * energyPerPoint))));
            this.shieldPoints += (double)extracted / energyPerPoint;
        }
    }

    public double getShieldPoints() {
        return this.shieldPoints + this.shieldBoost;
    }

    public int getShieldCapacity() {
        return this.shieldCapacity;
    }

    public double getMaxShieldBoost() {
        return this.shieldBoost == 0.0 ? 0.0 : this.maxBoost;
    }

    public double getShieldBoost() {
        return this.shieldBoost;
    }

    public int getShieldCoolDown() {
        return this.shieldCoolDown;
    }

    public int getMaxShieldCoolDown() {
        return ((ShieldControlData)this.module.getData()).coolDownTicks() * 100;
    }

    public void setShieldCoolDown(int shieldCoolDown) {
        this.shieldCoolDown = shieldCoolDown;
    }

    public void tryBlockDamage(LivingAttackEvent event) {
        DamageSource source;
        block6: {
            block5: {
                source = event.getSource();
                if (!this.shieldEnabled.getValue() || source.m_269533_(DamageTypeTags.f_268738_)) break block5;
                if (!FastStream.of(UNBLOCKABLE).anyMatch(arg_0 -> ((DamageSource)source).m_276093_(arg_0))) break block6;
            }
            return;
        }
        if (this.blockEnvironmentalDamage(event, source)) {
            return;
        }
        float damage = this.applyDamageModifiers(source, event.getAmount());
        if ((double)damage <= this.getShieldPoints()) {
            LivingEntity entity = event.getEntity();
            event.setCanceled(true);
            this.subtractShieldPoints(damage);
            this.onShieldHit(entity, true);
        }
    }

    private boolean blockEnvironmentalDamage(LivingAttackEvent event, DamageSource source) {
        double value;
        LivingEntity entity = event.getEntity();
        if (source.m_269533_(DamageTypeTags.f_268745_) && this.getShieldPoints() > 10.0) {
            entity.m_20095_();
        }
        if ((value = ((Double)FastStream.of(ENV_SOURCES.entrySet()).filter(e -> source.m_276093_((ResourceKey)e.getKey())).map(Map.Entry::getValue).firstOrDefault((Object)0.0)).doubleValue()) != 0.0 && (value /= 20.0) <= this.getShieldPoints()) {
            this.subtractShieldPoints(value);
            event.setCanceled(true);
            this.lastHitTime = System.currentTimeMillis();
            this.shieldAnim = 1.0f;
            this.shieldHitIndicator = 1.0f;
            this.shieldCoolDown = this.getMaxShieldCoolDown();
            if (this.envDmgCoolDown == 0) {
                float hitPitch = 0.7f + (float)(Math.min(1.0, this.getShieldPoints() / (((double)this.shieldCapacity + this.getMaxShieldBoost()) * 0.1)) * 0.3);
                entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)DESounds.SHIELD_STRIKE.get(), SoundSource.PLAYERS, 0.25f, (0.95f + entity.m_9236_().f_46441_.m_188501_() * 0.1f) * hitPitch);
                this.envDmgCoolDown = (byte)40;
            }
            return true;
        }
        return false;
    }

    public void tryBlockDamage(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        if (!this.shieldEnabled.getValue() || UNBLOCKABLE.contains(source)) {
            return;
        }
        float damage = this.applyDamageModifiers(source, event.getAmount());
        LivingEntity entity = event.getEntity();
        if ((double)damage <= this.getShieldPoints()) {
            event.setCanceled(true);
            this.subtractShieldPoints(damage);
            this.onShieldHit(entity, true);
        } else if (this.getShieldPoints() > 0.0) {
            damage = (float)((double)damage - this.getShieldPoints());
            event.setAmount(damage);
            this.onShieldHit(entity, false);
            this.shieldPoints = 0.0;
            this.shieldBoost = 0.0;
        }
    }

    private void onShieldHit(LivingEntity entity, boolean damageBlocked) {
        this.lastHitTime = System.currentTimeMillis();
        this.shieldAnim = 1.0f;
        this.shieldHitIndicator = 1.0f;
        if (damageBlocked && (double)this.shieldCapacity + this.getMaxShieldBoost() > 0.0) {
            this.shieldCoolDown = this.getMaxShieldCoolDown();
            float hitPitch = 0.7f + (float)(Math.min(1.0, this.getShieldPoints() / (((double)this.shieldCapacity + this.getMaxShieldBoost()) * 0.1)) * 0.3);
            entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)DESounds.SHIELD_STRIKE.get(), SoundSource.PLAYERS, 1.0f, (0.95f + entity.m_9236_().f_46441_.m_188501_() * 0.1f) * hitPitch);
        }
    }

    private ShieldData getShieldData(LivingEntity entity) {
        if (this.shieldCache == null) {
            this.conflict = false;
            if (entity == null) {
                this.shieldCache = this.host.getModuleData(ModuleTypes.SHIELD_BOOST, new ShieldData(0, 0.0));
            } else {
                this.shieldCache = ModuleHelper.getCombinedEquippedData(entity, ModuleTypes.SHIELD_BOOST, new ShieldData(0, 0.0));
                this.conflict = ModuleHelper.getEquippedModules(entity, ModuleTypes.SHIELD_CONTROLLER).size() > 1;
            }
        }
        return this.shieldCache;
    }

    private float applyDamageModifiers(DamageSource source, float damage) {
        if (source.m_269533_(DamageTypeTags.f_268490_)) {
            damage *= 3.0f;
        }
        if (source.m_276093_(DamageTypes.f_268515_)) {
            damage *= 2.0f;
        }
        return damage;
    }

    public void boost(float shieldBoost, int boostTime) {
        this.shieldBoost += (double)shieldBoost;
        this.boostTime = Math.max(this.boostTime, boostTime);
        this.maxBoost = this.shieldBoost;
    }

    public void subtractShieldPoints(double points) {
        if (points > 0.0) {
            if (this.shieldBoost > 0.0) {
                double number = Math.min(this.shieldBoost, points);
                this.shieldBoost -= number;
                points -= number;
            }
            this.shieldPoints = Math.max(0.0, this.shieldPoints - points);
        }
    }

    public int getShieldColour() {
        return this.shieldEnabled.getValue() || this.shieldAnim > 0.0f ? this.shieldColour | (int)((double)(63.0f + 192.0f * this.shieldHitIndicator) * Math.min(1.0, this.getShieldPoints() / ((double)this.shieldCapacity * 0.1))) << 24 : 0xFFFFFF;
    }

    public boolean isShieldEnabled() {
        return this.shieldEnabled.getValue();
    }

    public float getShieldState() {
        return this.shieldAnim;
    }

    private static int getDefaultShieldColour(TechLevel techLevel) {
        return switch (techLevel) {
            default -> throw new IncompatibleClassChangeError();
            case TechLevel.DRACONIUM -> 32972;
            case TechLevel.WYVERN -> 9175205;
            case TechLevel.DRACONIC -> 0xFF9000;
            case TechLevel.CHAOTIC -> 12520460;
        };
    }

    @Override
    public void clearCaches() {
        this.shieldCache = null;
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128347_("boost", this.shieldBoost);
        compound.m_128347_("max_boost", this.maxBoost);
        compound.m_128405_("boost_time", this.boostTime);
        compound.m_128344_("env_cdwn", this.envDmgCoolDown);
        compound.m_128379_("visible", this.shieldVisible);
        compound.m_128350_("anim", this.shieldAnim);
        compound.m_128350_("hit", this.shieldHitIndicator);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.shieldBoost = compound.m_128459_("boost");
        this.maxBoost = compound.m_128459_("max_boost");
        this.boostTime = compound.m_128451_("boost_time");
        this.envDmgCoolDown = compound.m_128445_("env_cdwn");
        this.shieldVisible = compound.m_128471_("visible");
        this.shieldAnim = compound.m_128457_("anim");
        this.shieldHitIndicator = compound.m_128457_("hit");
    }

    @Override
    protected void readExtraData(CompoundTag nbt) {
        this.shieldCapacity = nbt.m_128451_("cap");
        this.shieldPoints = nbt.m_128459_("points");
        this.shieldCoolDown = nbt.m_128451_("cooldwn");
    }

    @Override
    protected CompoundTag writeExtraData(CompoundTag nbt) {
        nbt.m_128405_("cap", this.shieldCapacity);
        nbt.m_128347_("points", this.shieldPoints);
        nbt.m_128405_("cooldwn", this.shieldCoolDown);
        return nbt;
    }

    static {
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.f_268631_, 1.0);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.f_268468_, 0.5);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.f_268546_, 4.0);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.f_268434_, 1.0);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.f_268612_, 1.0);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.f_268613_, 0.0);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.f_268585_, 1.0);
    }
}

