/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.renderer;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlock;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlockEntity;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.ILDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.syncdata.IAutoPersistedSerializable;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public interface ISerializableRenderer
extends IConfigurable,
IRenderer,
IAutoPersistedSerializable,
ILDLRegisterClient {
    public static CompoundTag serializeWrapper(ISerializableRenderer renderer) {
        return renderer.serializeNBT();
    }

    @Nullable
    public static ISerializableRenderer deserializeWrapper(CompoundTag tag) {
        String type = tag.m_128461_("_type");
        AnnotationDetector.Wrapper<LDLRegisterClient, ? extends ISerializableRenderer> wrapper = AnnotationDetector.REGISTER_RENDERERS.get(type);
        if (wrapper != null) {
            ISerializableRenderer renderer = wrapper.creator().get();
            renderer.deserializeNBT(tag);
            renderer.initRenderer();
            return renderer;
        }
        return null;
    }

    default public void initRenderer() {
    }

    default public void createPreview(ConfiguratorGroup father) {
        TrackedDummyWorld level = new TrackedDummyWorld();
        level.addBlock(BlockPos.f_121853_, BlockInfo.fromBlock(RendererBlock.BLOCK));
        Optional.ofNullable(level.m_7702_(BlockPos.f_121853_)).ifPresent(blockEntity -> {
            if (blockEntity instanceof RendererBlockEntity) {
                RendererBlockEntity holder = (RendererBlockEntity)((Object)blockEntity);
                holder.setRenderer(this);
            }
        });
        SceneWidget sceneWidget = new SceneWidget(0, 0, 100, 100, level);
        sceneWidget.setRenderFacing(false);
        sceneWidget.setRenderSelect(false);
        sceneWidget.createScene(level);
        sceneWidget.getRenderer().setOnLookingAt(null);
        sceneWidget.setRenderedCore(Collections.singleton(BlockPos.f_121853_), null);
        sceneWidget.setBackground(new ColorBorderTexture(2, ColorPattern.T_WHITE.color));
        father.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", sceneWidget));
    }

    @Override
    default public void buildConfigurator(ConfiguratorGroup father) {
        this.createPreview(father);
        IConfigurable.super.buildConfigurator(father);
    }
}

