/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.shader.management;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.shader.Shaders;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL43;

@OnlyIn(value=Dist.CLIENT)
public class ShaderSSBO {
    public final int id;
    private boolean inValid = false;
    private static final int BUFFER_TYPE = 37074;

    public ShaderSSBO() {
        if (!Shaders.supportSSBO()) {
            String errorMessage = "need support for GL_ARB_shader_storage_buffer_object";
            LDLib.LOGGER.error(errorMessage);
            Minecraft.m_91087_().m_231412_(new CrashReport(errorMessage, (Throwable)new IllegalStateException(errorMessage)));
        }
        this.id = GL43.glGenBuffers();
    }

    public void close() {
        if (!this.inValid) {
            GL30.glDeleteBuffers((int)this.id);
            this.inValid = true;
        } else {
            LDLib.LOGGER.error("try closing an already closed ShaderStorageBufferObject");
        }
    }

    public void bindBuffer() {
        if (!this.inValid) {
            GL30.glBindBuffer((int)37074, (int)this.id);
        } else {
            LDLib.LOGGER.error("try to use an already close ShaderStorageBufferObject");
        }
    }

    public void unBindBuffer() {
        GL30.glBindBuffer((int)37074, (int)0);
    }

    public void bindToShader(int programIndex, int storageBlockIndex, int index) {
        this.bindBuffer();
        GL43.glShaderStorageBlockBinding((int)programIndex, (int)storageBlockIndex, (int)index);
        this.unBindBuffer();
    }

    public void bindIndex(int index) {
        this.bindBuffer();
        GL43.glBindBufferBase((int)37074, (int)index, (int)this.id);
        this.unBindBuffer();
    }

    public void getSubData(long offset, float[] data) {
        this.bindBuffer();
        GL43.glGetBufferSubData((int)37074, (long)offset, (float[])data);
        this.unBindBuffer();
    }

    public void createBufferData(long size, int mode) {
        this.bindBuffer();
        GL30.glBufferData((int)37074, (long)size, (int)mode);
        this.unBindBuffer();
    }

    public void createBufferData(FloatBuffer data, int mode) {
        this.bindBuffer();
        GL30.glBufferData((int)37074, (FloatBuffer)data, (int)mode);
        this.unBindBuffer();
    }

    public void bufferSubData(long offset, FloatBuffer data) {
        this.bindBuffer();
        GL30.glBufferSubData((int)37074, (long)offset, (FloatBuffer)data);
        this.unBindBuffer();
    }

    public void bufferSubData(long offset, ByteBuffer data) {
        this.bindBuffer();
        GL30.glBufferSubData((int)37074, (long)offset, (ByteBuffer)data);
        this.unBindBuffer();
    }

    public void bufferSubData(long offset, float[] data) {
        this.bindBuffer();
        GL30.glBufferSubData((int)37074, (long)offset, (float[])data);
        this.unBindBuffer();
    }

    public void bufferSubData(long offset, int[] data) {
        this.bindBuffer();
        GL30.glBufferSubData((int)37074, (long)offset, (int[])data);
        this.unBindBuffer();
    }
}

