/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.accessors;

import com.lowdragmc.lowdraglib.gui.editor.accessors.TypesAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.DefaultValue;
import com.lowdragmc.lowdraglib.gui.editor.configurator.BlockConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@ConfigAccessor
public class BlockStateAccessor
extends TypesAccessor<BlockState> {
    public BlockStateAccessor() {
        super(BlockState.class);
    }

    @Override
    public BlockState defaultValue(Field field, Class<?> type) {
        if (field.isAnnotationPresent(DefaultValue.class)) {
            DefaultValue annotation = field.getAnnotation(DefaultValue.class);
            return ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(annotation.stringValue()[0]))).m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public Configurator create(String name, Supplier<BlockState> supplier, Consumer<BlockState> consumer, boolean forceUpdate, Field field) {
        ConfiguratorGroup group = new ConfiguratorGroup(name);
        if (field.isAnnotationPresent(Configurable.class)) {
            Configurable configurable = field.getAnnotation(Configurable.class);
            group.setCollapse(configurable.collapse());
            group.setCanCollapse(configurable.canCollapse());
            group.setTips(configurable.tips());
        }
        ConfiguratorGroup propertyGroup = new ConfiguratorGroup("ldlib.gui.editor.blockstate.properties");
        ItemStackTransfer itemHandler = new ItemStackTransfer(supplier.get().m_60734_().m_5456_().m_7968_());
        SlotWidget slot = new SlotWidget(itemHandler, 0, 0, 0, false, false);
        slot.setClientSideWidget();
        Runnable updateProperty = () -> {
            propertyGroup.removeAllConfigurators();
            for (Property property : ((BlockState)supplier.get()).m_61147_()) {
                SelectorConfigurator<Comparable> propertySelector = new SelectorConfigurator<Comparable>(property.m_61708_(), () -> BlockStateAccessor.lambda$create$0((Supplier)supplier, property), arg_0 -> BlockStateAccessor.lambda$create$1((Supplier)supplier, property, consumer, arg_0), ((BlockState)supplier.get()).m_61143_(property), forceUpdate, property.m_6908_().stream().toList(), arg_0 -> ((Property)property).m_6940_(arg_0));
                propertyGroup.addConfigurators(propertySelector);
            }
            propertyGroup.computeLayout();
        };
        updateProperty.run();
        Consumer<BlockState> updateState = state -> {
            consumer.accept((BlockState)state);
            itemHandler.setStackInSlot(0, state.m_60734_().m_5456_().m_7968_());
            updateProperty.run();
        };
        group.addConfigurators(new BlockConfigurator("id", () -> ((BlockState)supplier.get()).m_60734_(), block -> updateState.accept(block.m_49966_()), Blocks.f_50016_, forceUpdate));
        group.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", slot));
        group.addConfigurators(propertyGroup);
        return group;
    }

    private static /* synthetic */ void lambda$create$1(Supplier supplier, Property property, Consumer consumer, Comparable value) {
        BlockState state = (BlockState)supplier.get();
        state = (BlockState)state.m_61124_(property, value);
        consumer.accept(state);
    }

    private static /* synthetic */ Comparable lambda$create$0(Supplier supplier, Property property) {
        return ((BlockState)supplier.get()).m_61143_(property);
    }
}

