/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import java.util.function.Supplier;

public class ButtonConfigurator
extends Configurator {
    public Supplier<String> textSupplier;
    public Runnable runnable;
    private int lines = 1;

    public ButtonConfigurator(String text, Runnable runnable) {
        this.textSupplier = () -> text;
        this.runnable = runnable;
    }

    public ButtonConfigurator(Supplier<String> textSupplier, Runnable runnable) {
        this.textSupplier = textSupplier;
        this.runnable = runnable;
    }

    @Override
    public void init(int width) {
        super.init(width);
        TextTexture textTexture = new TextTexture(this.textSupplier).setWidth(width - this.rightWidth - 4);
        this.lines = textTexture.getLines();
        this.addWidget(new ButtonWidget(2, 2, width - this.rightWidth - 4, 10 * this.lines, new GuiTextureGroup(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), textTexture), cd -> {
            if (this.runnable != null) {
                this.runnable.run();
            }
        }));
    }

    @Override
    public void computeHeight() {
        this.setSizeHeight(this.lines * 10 + 5);
    }
}

