/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;

public class Vector3iConfigurator
extends ValueConfigurator<Vector3i> {
    protected int min;
    protected int max;
    protected int wheel;

    public Vector3iConfigurator(String name, Supplier<Vector3i> supplier, Consumer<Vector3i> onUpdate, @NotNull Vector3i defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
        this.setWheel(1);
    }

    public Vector3iConfigurator setRange(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public Vector3iConfigurator setWheel(int wheel) {
        if (wheel == 0) {
            return this;
        }
        this.wheel = wheel;
        return this;
    }

    @Override
    protected void onValueUpdate(Vector3i newValue) {
        if (newValue == null) {
            newValue = (Vector3i)this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
    }

    @Override
    public void init(int width) {
        super.init(width);
        assert (this.value != null);
        int w = (width - this.leftWidth - this.rightWidth) / 3;
        NumberConfigurator x = new NumberConfigurator("x", () -> ((Vector3i)this.value).x, number -> {
            ((Vector3i)this.value).x = number.intValue();
            this.updateValue();
        }, ((Vector3i)this.defaultValue).x, this.forceUpdate);
        x.setRange(this.min, this.max);
        x.setWheel(this.wheel);
        x.setConfiguratorContainer(this.configuratorContainer);
        x.init(w);
        x.addSelfPosition(this.leftWidth, 0);
        this.addWidget(x);
        NumberConfigurator y = new NumberConfigurator("y", () -> ((Vector3i)this.value).y, number -> {
            ((Vector3i)this.value).y = number.intValue();
            this.updateValue();
        }, ((Vector3i)this.defaultValue).y, this.forceUpdate);
        y.setRange(this.min, this.max);
        y.setWheel(this.wheel);
        y.setConfiguratorContainer(this.configuratorContainer);
        y.init(w);
        y.addSelfPosition(this.leftWidth + w, 0);
        this.addWidget(y);
        NumberConfigurator z = new NumberConfigurator("z", () -> ((Vector3i)this.value).z, number -> {
            ((Vector3i)this.value).z = number.intValue();
            this.updateValue();
        }, ((Vector3i)this.defaultValue).z, this.forceUpdate);
        z.setRange(this.min, this.max);
        z.setWheel(this.wheel);
        z.setConfiguratorContainer(this.configuratorContainer);
        z.init(w);
        z.addSelfPosition(this.leftWidth + w * 2, 0);
        this.addWidget(z);
    }
}

