/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.utils;

import com.lowdragmc.lowdraglib.client.shader.LDLibRenderTypes;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.SceneEditorWidget;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Ray;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Transform;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.IScene;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneInteractable;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneRendering;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.SceneObject;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TransformGizmo
extends SceneObject
implements ISceneRendering,
ISceneInteractable {
    private static final VoxelShape xAxisCollider = Shapes.m_83048_((double)0.0, (double)-0.1, (double)-0.1, (double)1.2, (double)0.1, (double)0.1);
    private static final VoxelShape yAxisCollider = Shapes.m_83048_((double)-0.1, (double)0.0, (double)-0.1, (double)0.1, (double)1.2, (double)0.1);
    private static final VoxelShape zAxisCollider = Shapes.m_83048_((double)-0.1, (double)-0.1, (double)0.0, (double)0.1, (double)0.1, (double)1.2);
    private static final VoxelShape xRingCollider = TransformGizmo.createRingCollisionBox(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), 1.0, 16, 0.1);
    private static final VoxelShape yRingCollider = TransformGizmo.createRingCollisionBox(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), 1.0, 16, 0.1);
    private static final VoxelShape zRingCollider = TransformGizmo.createRingCollisionBox(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), 1.0, 16, 0.1);
    @Nullable
    private Transform targetTransform;
    @Nonnull
    private Mode mode = Mode.TRANSLATE;
    private boolean isMovingX;
    private boolean isMovingY;
    private boolean isMovingZ;
    private Vector3f moveDirection;
    private Vector2f startMouse;
    private float lastScale = 1.0f;

    public void setTargetTransform(@Nullable Transform targetTransform) {
        if (this.targetTransform == targetTransform) {
            return;
        }
        this.targetTransform = targetTransform;
        if (targetTransform != null) {
            this.transform().position(targetTransform.position());
            this.transform().rotation(targetTransform.rotation());
        }
    }

    public boolean hasTargetTransform() {
        return this.targetTransform != null;
    }

    public boolean isHoverAxis(Direction.Axis axis) {
        IScene scene = this.getScene();
        if (scene instanceof SceneEditorWidget) {
            SceneEditorWidget editor = (SceneEditorWidget)scene;
            if (this.targetTransform != null) {
                return switch (this.mode) {
                    default -> throw new IncompatibleClassChangeError();
                    case Mode.TRANSLATE -> editor.getMouseRay().map(ray -> ray.worldToLocal(this.transform()).toInfinite()).map(ray -> switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> ray.clip(xAxisCollider) != null;
                        case Direction.Axis.Y -> ray.clip(yAxisCollider) != null;
                        case Direction.Axis.Z -> ray.clip(zAxisCollider) != null;
                    }).orElse(false);
                    case Mode.ROTATE -> editor.getMouseRay().map(ray -> ray.worldToLocal(this.transform()).toInfinite()).map(ray -> switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> ray.clip(xRingCollider) != null;
                        case Direction.Axis.Y -> ray.clip(yRingCollider) != null;
                        case Direction.Axis.Z -> ray.clip(zRingCollider) != null;
                    }).orElse(false);
                    case Mode.SCALE -> editor.getMouseRay().map(ray -> ray.worldToLocal(this.transform()).toInfinite()).map(ray -> {
                        if (this.targetTransform == null) {
                            return false;
                        }
                        Vector3f scale = this.targetTransform.scale();
                        return switch (axis) {
                            default -> throw new IncompatibleClassChangeError();
                            case Direction.Axis.X -> ray.clip(Shapes.m_83048_((double)Math.min(0.2 + (double)scale.x, 0.0), (double)-0.1, (double)-0.1, (double)Math.max(0.2 + (double)scale.x, 0.0), (double)0.1, (double)0.1)) != null;
                            case Direction.Axis.Y -> ray.clip(Shapes.m_83048_((double)-0.1, (double)Math.min(0.2 + (double)scale.y, 0.0), (double)-0.1, (double)0.1, (double)Math.max(0.2 + (double)scale.y, 0.0), (double)0.1)) != null;
                            case Direction.Axis.Z -> ray.clip(Shapes.m_83048_((double)-0.1, (double)-0.1, (double)Math.min(0.2 + (double)scale.z, 0.0), (double)0.1, (double)0.1, (double)Math.max(0.2 + (double)scale.z, 0.0))) != null;
                        };
                    }).orElse(false);
                };
            }
        }
        return false;
    }

    @Override
    public void onTransformChanged() {
        super.onTransformChanged();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateFrame(float partialTicks) {
        super.updateFrame(partialTicks);
        IScene iScene = this.getScene();
        if (iScene instanceof SceneEditorWidget) {
            SceneEditorWidget editor = (SceneEditorWidget)iScene;
            float distance = editor.getRenderer().getEyePos().distance((Vector3fc)this.transform().position());
            float baseScale = 0.23f;
            float gizmoScale = distance * (float)Math.tan((double)(editor.getRenderer().getFov() * 0.5f) * Math.PI / 180.0) * baseScale;
            if (this.lastScale != gizmoScale) {
                this.transform().scale(new Vector3f(gizmoScale));
                this.lastScale = gizmoScale;
            }
            if (this.targetTransform == null) {
                return;
            }
            if (!this.transform().position().equals((Object)this.targetTransform.position())) {
                this.transform().position(this.targetTransform.position());
            }
            if (!this.transform().rotation().equals((Object)this.targetTransform.rotation())) {
                this.transform().rotation(this.targetTransform.rotation());
            }
            if (this.isMovingX || this.isMovingY || this.isMovingZ) {
                float projectedLength;
                Vector3f currentPosition = this.transform().position();
                Vector3f moveD = this.transform().localToWorldMatrix().transformDirection(new Vector3f((Vector3fc)this.moveDirection));
                Vector2f screenStart = editor.project(currentPosition);
                Vector2f screenEnd = editor.project(new Vector3f((Vector3fc)currentPosition).add((Vector3fc)moveD));
                Vector2f screenAxis = new Vector2f((Vector2fc)screenEnd).sub((Vector2fc)screenStart);
                if (!(screenAxis.length() > 0.0f)) {
                    return;
                }
                screenAxis.normalize();
                Vector2f mouseDelta = new Vector2f((float)editor.getLastMouseX(), (float)editor.getLastMouseY()).sub((Vector2fc)this.startMouse);
                if (this.mode == Mode.ROTATE) {
                    mouseDelta.set(-mouseDelta.y, mouseDelta.x);
                }
                if ((projectedLength = mouseDelta.dot((Vector2fc)screenAxis)) == 0.0f) {
                    return;
                }
                float distanceToCamera = editor.getRenderer().getEyePos().distance((Vector3fc)currentPosition);
                float fov = editor.getRenderer().getFov();
                int screenHeight = editor.getSizeHeight();
                float worldHeight = 2.0f * distanceToCamera * (float)Math.tan(Math.toRadians(fov / 2.0f));
                float pixelToWorldScale = worldHeight / (float)screenHeight;
                float scaleDelta = projectedLength * pixelToWorldScale;
                if (scaleDelta == 0.0f) {
                    return;
                }
                if (this.mode == Mode.TRANSLATE) {
                    Vector3f position = currentPosition.add((Vector3fc)new Vector3f((Vector3fc)moveD).mul(scaleDelta));
                    this.transform().position(position);
                    this.targetTransform.position(position);
                } else if (this.mode == Mode.SCALE) {
                    Vector3f localScale = this.targetTransform.localScale().add((Vector3fc)new Vector3f((Vector3fc)this.moveDirection).mul(scaleDelta));
                    this.targetTransform.localScale(localScale);
                } else if (this.mode == Mode.ROTATE) {
                    Quaternionf localRotation = this.transform().localRotation();
                    localRotation.rotateAxis(scaleDelta, (Vector3fc)this.moveDirection);
                    this.transform().localRotation(localRotation);
                    this.targetTransform.localRotation(localRotation);
                }
                this.startMouse.set((float)editor.getLastMouseX(), (float)editor.getLastMouseY());
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInternal(PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        if (this.targetTransform == null) {
            return;
        }
        VertexConsumer buffer = bufferSource.m_6299_(LDLibRenderTypes.noDepthLines());
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        int hoverColor = -1;
        boolean isHoverX = this.isHoverAxis(Direction.Axis.X);
        boolean isHoverY = !isHoverX && this.isHoverAxis(Direction.Axis.Y);
        boolean isHoverZ = !isHoverX && !isHoverY && this.isHoverAxis(Direction.Axis.Z);
        int xColor = !isHoverX ? -65536 : hoverColor;
        int yColor = !isHoverY ? -16711936 : hoverColor;
        int zColor = !isHoverZ ? -16776961 : hoverColor;
        float xR = ColorUtils.red(xColor);
        float xG = ColorUtils.green(xColor);
        float xB = ColorUtils.blue(xColor);
        float xA = ColorUtils.alpha(xColor);
        float yR = ColorUtils.red(yColor);
        float yG = ColorUtils.green(yColor);
        float yB = ColorUtils.blue(yColor);
        float yA = ColorUtils.alpha(yColor);
        float zR = ColorUtils.red(zColor);
        float zG = ColorUtils.green(zColor);
        float zB = ColorUtils.blue(zColor);
        float zA = ColorUtils.alpha(zColor);
        if (this.mode == Mode.SCALE || this.mode == Mode.TRANSLATE) {
            Vector3f scale = this.targetTransform.scale();
            RenderBufferUtils.drawLine(pose, buffer, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(this.mode == Mode.TRANSLATE ? 1.0f : scale.x, 0.0f, 0.0f), xR, xG, xB, xA, xR, xG, xB, xA);
            if (this.isMovingX) {
                RenderBufferUtils.drawLine(pose, buffer, new Vector3f(-50.0f, 0.0f, 0.0f), new Vector3f(50.0f, 0.0f, 0.0f), xR, xG, xB, xA, xR, xG, xB, xA);
            }
            RenderBufferUtils.drawLine(pose, buffer, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, this.mode == Mode.TRANSLATE ? 1.0f : scale.y, 0.0f), yR, yG, yB, yA, yR, yG, yB, yA);
            if (this.isMovingY) {
                RenderBufferUtils.drawLine(pose, buffer, new Vector3f(0.0f, -50.0f, 0.0f), new Vector3f(0.0f, 50.0f, 0.0f), yR, yG, yB, yA, yR, yG, yB, yA);
            }
            RenderBufferUtils.drawLine(pose, buffer, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, this.mode == Mode.TRANSLATE ? 1.0f : scale.z), zR, zG, zB, zA, zR, zG, zB, zA);
            if (this.isMovingZ) {
                RenderBufferUtils.drawLine(pose, buffer, new Vector3f(0.0f, 0.0f, -50.0f), new Vector3f(0.0f, 0.0f, 50.0f), zR, zG, zB, zA, zR, zG, zB, zA);
            }
            if (this.mode == Mode.TRANSLATE) {
                buffer = bufferSource.m_6299_(LDLibRenderTypes.positionColorNoDepth());
                RenderBufferUtils.shapeCone(poseStack, buffer, 1.0f, 0.0f, 0.0f, 0.05f, 0.15f, 10, xR, xG, xB, xA, Direction.Axis.X);
                RenderBufferUtils.shapeCircle(poseStack, buffer, 1.0f, 0.0f, 0.0f, 0.05f, 10, xR, xG, xB, xA, Direction.Axis.X);
                RenderBufferUtils.shapeCone(poseStack, buffer, 0.0f, 1.0f, 0.0f, 0.05f, 0.15f, 10, yR, yG, yB, yA, Direction.Axis.Y);
                RenderBufferUtils.shapeCircle(poseStack, buffer, 0.0f, 1.0f, 0.0f, 0.05f, 10, yR, yG, yB, yA, Direction.Axis.Y);
                RenderBufferUtils.shapeCone(poseStack, buffer, 0.0f, 0.0f, 1.0f, 0.05f, 0.15f, 10, zR, zG, zB, zA, Direction.Axis.Z);
                RenderBufferUtils.shapeCircle(poseStack, buffer, 0.0f, 0.0f, 1.0f, 0.05f, 10, zR, zG, zB, zA, Direction.Axis.Z);
            }
            if (this.mode == Mode.SCALE) {
                buffer = bufferSource.m_6299_(LDLibRenderTypes.positionColorNoDepth());
                RenderBufferUtils.drawCubeFace(poseStack, buffer, scale.x - 0.05f, -0.05f, -0.05f, scale.x + 0.05f, 0.05f, 0.05f, xR, xG, xB, xA, true);
                RenderBufferUtils.drawCubeFace(poseStack, buffer, -0.05f, scale.y - 0.05f, -0.05f, 0.05f, scale.y + 0.05f, 0.05f, yR, yG, yB, yA, true);
                RenderBufferUtils.drawCubeFace(poseStack, buffer, -0.05f, -0.05f, scale.z - 0.05f, 0.05f, 0.05f, scale.z + 0.05f, zR, zG, zB, zA, true);
            }
        }
        if (this.mode == Mode.ROTATE) {
            RenderBufferUtils.drawCircleLine(poseStack, buffer, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), 50, 1.0f, xR, xG, xB, xA);
            RenderBufferUtils.drawCircleLine(poseStack, buffer, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), 50, 1.0f, yR, yG, yB, yA);
            RenderBufferUtils.drawCircleLine(poseStack, buffer, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), 50, 1.0f, zR, zG, zB, zA);
            buffer = bufferSource.m_6299_(LDLibRenderTypes.positionColorNoDepth());
            RenderBufferUtils.drawCubeFace(poseStack, buffer, 0.95f, -0.05f, -0.05f, 1.05f, 0.05f, 0.05f, zR, zG, zB, zA, true);
            RenderBufferUtils.drawCubeFace(poseStack, buffer, -0.05f, 0.95f, -0.05f, 0.05f, 1.05f, 0.05f, xR, xG, xB, xA, true);
            RenderBufferUtils.drawCubeFace(poseStack, buffer, -0.05f, -0.05f, 0.95f, 0.05f, 0.05f, 1.05f, yR, yG, yB, yA, true);
        }
    }

    @Override
    public boolean onMouseClick(Ray mouseRay) {
        IScene iScene = this.getScene();
        if (iScene instanceof SceneEditorWidget) {
            SceneEditorWidget editor = (SceneEditorWidget)iScene;
            if (this.isHoverAxis(Direction.Axis.X)) {
                this.isMovingX = true;
                this.moveDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                this.startMouse = new Vector2f((float)editor.getLastMouseX(), (float)editor.getLastMouseY());
                return true;
            }
            if (this.isHoverAxis(Direction.Axis.Y)) {
                this.isMovingY = true;
                this.moveDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                this.startMouse = new Vector2f((float)editor.getLastMouseX(), (float)editor.getLastMouseY());
                return true;
            }
            if (this.isHoverAxis(Direction.Axis.Z)) {
                this.isMovingZ = true;
                this.moveDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                this.startMouse = new Vector2f((float)editor.getLastMouseX(), (float)editor.getLastMouseY());
                return true;
            }
        }
        return false;
    }

    @Override
    public void onMouseRelease(Ray mouseRay) {
        this.isMovingX = false;
        this.isMovingY = false;
        this.isMovingZ = false;
        this.startMouse = null;
        this.moveDirection = null;
    }

    public static VoxelShape createRingCollisionBox(Vector3f center, Vector3f normal, double radius, int segments, double thickness) {
        VoxelShape ringShape = Shapes.m_83040_();
        double angleStep = Math.PI * 2 / (double)segments;
        Vector3f u = new Vector3f();
        Vector3f v = new Vector3f();
        if (normal.equals((Object)new Vector3f(0.0f, 0.0f, 1.0f)) || normal.equals((Object)new Vector3f(0.0f, 0.0f, -1.0f))) {
            u.set(1.0f, 0.0f, 0.0f);
            v.set(0.0f, 1.0f, 0.0f);
        } else {
            if (Math.abs(normal.x) < Math.abs(normal.y) && Math.abs(normal.x) < Math.abs(normal.z)) {
                u.set(0.0f, -normal.z, normal.y).normalize();
            } else if (Math.abs(normal.y) < Math.abs(normal.x) && Math.abs(normal.y) < Math.abs(normal.z)) {
                u.set(-normal.z, 0.0f, normal.x).normalize();
            } else {
                u.set(-normal.y, normal.x, 0.0f).normalize();
            }
            v.set((Vector3fc)normal).cross((Vector3fc)u).normalize();
            u.cross((Vector3fc)normal, v).normalize();
        }
        for (int i = 0; i < segments; ++i) {
            double angle = (double)i * angleStep;
            double nextAngle = (double)(i + 1) * angleStep;
            Vector3f start = new Vector3f((Vector3fc)center).add((float)(radius * Math.cos(angle) * (double)u.x + radius * Math.sin(angle) * (double)v.x), (float)(radius * Math.cos(angle) * (double)u.y + radius * Math.sin(angle) * (double)v.y), (float)(radius * Math.cos(angle) * (double)u.z + radius * Math.sin(angle) * (double)v.z));
            Vector3f end = new Vector3f((Vector3fc)center).add((float)(radius * Math.cos(nextAngle) * (double)u.x + radius * Math.sin(nextAngle) * (double)v.x), (float)(radius * Math.cos(nextAngle) * (double)u.y + radius * Math.sin(nextAngle) * (double)v.y), (float)(radius * Math.cos(nextAngle) * (double)u.z + radius * Math.sin(nextAngle) * (double)v.z));
            double minX = (double)Math.min(start.x, end.x) - thickness / 2.0;
            double maxX = (double)Math.max(start.x, end.x) + thickness / 2.0;
            double minY = (double)Math.min(start.y, end.y) - thickness / 2.0;
            double maxY = (double)Math.max(start.y, end.y) + thickness / 2.0;
            double minZ = (double)Math.min(start.z, end.z) - thickness / 2.0;
            double maxZ = (double)Math.max(start.z, end.z) + thickness / 2.0;
            VoxelShape segmentBox = Shapes.m_83048_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            ringShape = Shapes.m_83110_((VoxelShape)ringShape, (VoxelShape)segmentBox);
        }
        return ringShape;
    }

    @Nullable
    public Transform getTargetTransform() {
        return this.targetTransform;
    }

    @Nonnull
    public Mode getMode() {
        return this.mode;
    }

    public void setMode(@Nonnull Mode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.mode = mode;
    }

    public static enum Mode {
        TRANSLATE,
        ROTATE,
        SCALE;

    }
}

