/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget.codeeditor;

import java.util.ArrayList;
import java.util.List;

public class Document {
    private final List<String> lines = new ArrayList<String>();

    public Document() {
        this.lines.add("");
    }

    public void insertText(int line, int column, String text) {
        String currentLine = this.lines.get(line);
        String newLine = currentLine.substring(0, column) + text + currentLine.substring(column);
        this.lines.set(line, newLine);
    }

    public void deleteText(int line, int column, int length) {
        String currentLine = this.lines.get(line);
        if (column + length > currentLine.length()) {
            length = currentLine.length() - column;
        }
        String newLine = currentLine.substring(0, column) + currentLine.substring(column + length);
        this.lines.set(line, newLine);
    }

    public String getLine(int line) {
        return this.lines.get(line);
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public void insertLine(int index, String text) {
        this.lines.add(index, text);
    }

    public void deleteLine(int index) {
        if (this.lines.size() > 1) {
            this.lines.remove(index);
        } else {
            this.lines.set(0, "");
        }
    }

    public void setLine(int index, String text) {
        this.lines.set(index, text);
    }

    public List<String> getLines() {
        return this.lines;
    }
}

