/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.LazyManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RPCMethod;
import com.lowdragmc.lowdraglib.syncdata.annotation.ReadOnlyManaged;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.field.RPCMethodMeta;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;

public class ManagedFieldUtils {
    public static ManagedKey[] getManagedFields(Class<?> clazz) {
        ArrayList<ManagedKey> managedFields = new ArrayList<ManagedKey>();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(Persisted.class) && !field.isAnnotationPresent(DescSynced.class)) continue;
            ManagedKey managedKey = ManagedFieldUtils.createKey(field);
            managedFields.add(managedKey);
        }
        return (ManagedKey[])managedFields.toArray(ManagedKey[]::new);
    }

    public static Map<String, RPCMethodMeta> getRPCMethods(Class<?> clazz) {
        HashMap<String, RPCMethodMeta> result = new HashMap<String, RPCMethodMeta>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(RPCMethod.class)) continue;
            RPCMethodMeta rpcMethod = new RPCMethodMeta(method);
            result.put(rpcMethod.getName(), rpcMethod);
        }
        return result;
    }

    public static ManagedKey createKey(Field field) {
        boolean isLazy = field.isAnnotationPresent(LazyManaged.class);
        boolean isDestSync = field.isAnnotationPresent(DescSynced.class);
        boolean isPersist = field.isAnnotationPresent(Persisted.class);
        boolean isDrop = field.isAnnotationPresent(DropSaved.class);
        boolean isReadOnlyManaged = field.isAnnotationPresent(ReadOnlyManaged.class);
        String name = field.getName();
        Type type = field.getGenericType();
        ManagedKey managedKey = new ManagedKey(name, isDestSync, isPersist, isDrop, isLazy, type, field);
        if (isPersist) {
            Persisted persisted = field.getAnnotation(Persisted.class);
            managedKey.setPersistentKey(persisted.key());
        }
        if (isReadOnlyManaged) {
            ReadOnlyManaged readOnlyManaged = field.getAnnotation(ReadOnlyManaged.class);
            Class<?> clazz = field.getDeclaringClass();
            Class<?> rawType = field.getType();
            try {
                Method onDirtyMethod = clazz.getDeclaredMethod(readOnlyManaged.onDirtyMethod(), rawType);
                Method serializeMethod = clazz.getDeclaredMethod(readOnlyManaged.serializeMethod(), rawType);
                Method deserializeMethod = clazz.getDeclaredMethod(readOnlyManaged.deserializeMethod(), CompoundTag.class);
                onDirtyMethod.setAccessible(true);
                serializeMethod.setAccessible(true);
                deserializeMethod.setAccessible(true);
                managedKey.setRedOnlyManaged(onDirtyMethod, serializeMethod, deserializeMethod);
            }
            catch (NoSuchMethodException e) {
                LDLib.LOGGER.warn("No such methods for @ReadOnlyManaged field {}", (Object)field);
            }
        }
        return managedKey;
    }

    public static FieldRefs getFieldRefs(ManagedKey[] keys, Object obj, FieldChangedCallback syncFieldChangedCallback, FieldChangedCallback persistedFieldChangedCallback) {
        ArrayList<IRef> syncedFields = new ArrayList<IRef>();
        ArrayList<IRef> persistedFields = new ArrayList<IRef>();
        ArrayList<IRef> nonLazyFields = new ArrayList<IRef>();
        HashMap<ManagedKey, IRef> fieldRefMap = new HashMap<ManagedKey, IRef>();
        for (ManagedKey key : keys) {
            IRef fieldObj = key.createRef(obj);
            fieldObj.markAsDirty();
            fieldRefMap.put(key, fieldObj);
            if (!fieldObj.isLazy()) {
                nonLazyFields.add(fieldObj);
            }
            int syncIndex = -1;
            int persistIndex = -1;
            if (key.isDestSync()) {
                syncIndex = syncedFields.size();
                syncedFields.add(fieldObj);
            }
            if (key.isPersist()) {
                persistIndex = persistedFields.size();
                persistedFields.add(fieldObj);
            }
            int finalSyncIndex = syncIndex;
            int finalPersistIndex = persistIndex;
            fieldObj.setOnSyncListener(changed -> syncFieldChangedCallback.onFieldChanged(fieldObj, finalSyncIndex, changed));
            fieldObj.setOnPersistedListener(changed -> persistedFieldChangedCallback.onFieldChanged(fieldObj, finalPersistIndex, changed));
        }
        return new FieldRefs((IRef[])syncedFields.toArray(IRef[]::new), (IRef[])persistedFields.toArray(IRef[]::new), (IRef[])nonLazyFields.toArray(IRef[]::new), fieldRefMap);
    }

    public static interface FieldChangedCallback {
        public void onFieldChanged(IRef var1, int var2, boolean var3);
    }

    public record FieldRefs(IRef[] syncedRefs, IRef[] persistedRefs, IRef[] nonLazyFields, Map<ManagedKey, IRef> fieldRefMap) {
    }
}

