/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.macro.MacroManager;
import io.yukkuric.hexparse.network.ClipboardMsgMode;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.MsgPullClipboard;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class CommandMacro {
    public static void init() {
        CommandMacro.initWith((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)"macro"), true);
        CommandMacro.initWith((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)"dialect"), false);
    }

    static void initWith(LiteralArgumentBuilder<CommandSourceStack> sub, boolean isMacro) {
        HexParseCommands.registerLine(ctx -> {
            ServerPlayer self = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (self == null) {
                return 0;
            }
            List<Pair<String, String>> entries = MacroManager.listMacros(self, isMacro);
            self.m_213846_((Component)Component.m_237110_((String)"hexparse.cmd.macro.list.title", (Object[])new Object[]{entries.size(), Component.m_237115_((String)("hexparse.cmd.macro.list.title." + (isMacro ? "macro" : "dialect")))}));
            for (Pair<String, String> pair : entries) {
                self.m_213846_((Component)Component.m_237110_((String)"hexparse.cmd.macro.list.kv", (Object[])new Object[]{MacroManager.showGold((String)pair.first()), MacroManager.showGold((String)pair.second())}));
            }
            return entries.size();
        }, (ArgumentBuilder[])new LiteralArgumentBuilder[]{sub, Commands.m_82127_((String)"list")});
        BiFunction<CommandContext, Boolean, Integer> generalModify = (ctx, isDefine) -> {
            ServerPlayer self = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (self == null) {
                return 0;
            }
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            if ((key = CommandMacro.wrapCheckMacroKey(self, key, isMacro)) == null) {
                return 0;
            }
            if (isDefine.booleanValue()) {
                if (MacroManager.willThisExceedLimit(self, key)) {
                    self.m_213846_((Component)Component.m_237115_((String)"hexparse.msg.error.macro.too_many.single").m_130940_(ChatFormatting.DARK_RED));
                    return 0;
                }
                if (key.length() > 1024) {
                    self.m_213846_((Component)Component.m_237115_((String)"hexparse.msg.error.macro.too_long.key").m_130940_(ChatFormatting.DARK_RED));
                    return 0;
                }
                String value = StringArgumentType.getString((CommandContext)ctx, (String)"value");
                if (value.length() > 1024) {
                    self.m_213846_((Component)Component.m_237110_((String)"hexparse.msg.error.macro.too_long", (Object[])new Object[]{value.length() - 1024}).m_130940_(ChatFormatting.GOLD));
                    value = value.substring(0, 1024);
                }
                MacroManager.modifyMacro(self, true, key, value);
            } else {
                MacroManager.modifyMacro(self, false, key, null);
            }
            return 1;
        };
        HexParseCommands.registerLine(ctx -> (Integer)generalModify.apply(ctx, true), (ArgumentBuilder[])new ArgumentBuilder[]{sub, Commands.m_82127_((String)"define"), Commands.m_82129_((String)"key", (ArgumentType)StringArgumentType.string()), Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString())});
        HexParseCommands.registerLine(ctx -> (Integer)generalModify.apply(ctx, false), (ArgumentBuilder[])new ArgumentBuilder[]{sub, Commands.m_82127_((String)"remove"), Commands.m_82129_((String)"key", (ArgumentType)StringArgumentType.string())});
        if (isMacro) {
            HexParseCommands.registerLine(ctx -> {
                ServerPlayer self = ((CommandSourceStack)ctx.getSource()).m_230896_();
                if (self == null) {
                    return 0;
                }
                String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
                if ((key = CommandMacro.wrapCheckMacroKey(self, key, isMacro)) == null) {
                    return 0;
                }
                MsgHandlers.SERVER.sendPacketToPlayer(self, new MsgPullClipboard(key, ClipboardMsgMode.MACRO_DEFINE));
                return 1;
            }, (ArgumentBuilder[])new ArgumentBuilder[]{sub, Commands.m_82127_((String)"define_clipboard"), Commands.m_82129_((String)"key", (ArgumentType)StringArgumentType.string())});
        }
    }

    static String wrapCheckMacroKey(ServerPlayer self, String key, boolean isMacro) {
        if (isMacro == MacroManager.isMacro(key)) {
            return key;
        }
        if (isMacro) {
            return "#" + key;
        }
        self.m_213846_((Component)Component.m_237110_((String)"hexparse.msg.error.invalid_dialect_key", (Object[])new Object[]{key}).m_130940_(ChatFormatting.DARK_RED));
        return null;
    }
}

