/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.forge;

import at.petrak.hexcasting.common.lib.HexRegistries;
import at.petrak.hexcasting.common.msgs.IMessage;
import com.mojang.brigadier.CommandDispatcher;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.IModHelpers;
import io.yukkuric.hexparse.actions.HexParsePatterns;
import io.yukkuric.hexparse.forge.config.HexParseConfigForge;
import io.yukkuric.hexparse.forge.events.MacroForgeHandler;
import io.yukkuric.hexparse.hooks.CommentIotaType;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.network.ISenderClient;
import io.yukkuric.hexparse.network.ISenderServer;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.MsgPullClipboard;
import io.yukkuric.hexparse.network.MsgPushClipboard;
import io.yukkuric.hexparse.network.macro.MsgPushMacro;
import io.yukkuric.hexparse.network.macro.MsgUpdateClientMacro;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="hexparse")
public final class HexParseForge {
    static Network NETWORK;
    static ModHelpers HELPERS;

    public HexParseForge() {
        NETWORK = new Network();
        HELPERS = new ModHelpers();
        HexParse.init();
        IEventBus evBus = MinecraftForge.EVENT_BUS;
        evBus.addListener(event -> HexParseCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher()));
        evBus.register(MacroForgeHandler.class);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(event -> {
            ResourceKey key = event.getRegistryKey();
            if (key.equals((Object)HexRegistries.ACTION)) {
                CommentIotaType.registerAction();
                HexParsePatterns.registerActions();
            } else if (key.equals((Object)HexRegistries.IOTA_TYPE)) {
                CommentIotaType.registerIota();
            }
        });
        ModLoadingContext ctx = ModLoadingContext.get();
        HexParseConfigForge.register(ctx);
    }

    public static class Network
    implements ISenderClient,
    ISenderServer {
        static final String PROTOCOL_VERSION = "1";
        static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("hexparse", "network"), () -> "1", "1"::equals, "1"::equals);

        static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> makeServerBoundHandler(BiConsumer<T, ServerPlayer> handler) {
            return (m, ctx) -> {
                handler.accept(m, ((NetworkEvent.Context)ctx.get()).getSender());
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            };
        }

        static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> makeClientBoundHandler(Consumer<T> consumer) {
            return (m, ctx) -> {
                consumer.accept(m);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            };
        }

        Network() {
            MsgHandlers.CLIENT = this;
            MsgHandlers.SERVER = this;
            int idx = 0;
            CHANNEL.registerMessage(idx++, MsgPullClipboard.class, MsgPullClipboard::serialize, MsgPullClipboard::deserialize, Network.makeClientBoundHandler(MsgPullClipboard::handle));
            CHANNEL.registerMessage(idx++, MsgPushClipboard.class, MsgPushClipboard::serialize, MsgPushClipboard::deserialize, Network.makeServerBoundHandler(MsgPushClipboard::handle));
            CHANNEL.registerMessage(idx++, MsgUpdateClientMacro.class, MsgUpdateClientMacro::serialize, MsgUpdateClientMacro::deserialize, Network.makeClientBoundHandler(MsgUpdateClientMacro::handle));
            CHANNEL.registerMessage(idx++, MsgPushMacro.class, MsgPushMacro::serialize, MsgPushMacro::deserialize, Network.makeServerBoundHandler(MsgPushMacro::handle));
        }

        @Override
        public void sendPacketToServer(IMessage packet) {
            CHANNEL.sendToServer((Object)packet);
        }

        @Override
        public void sendPacketToPlayer(ServerPlayer player, IMessage packet) {
            CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
        }
    }

    public static class ModHelpers
    implements IModHelpers {
        ModHelpers() {
            HexParse.HELPERS = this;
        }

        @Override
        public boolean modLoaded(String modId) {
            return ModList.get().isLoaded(modId);
        }
    }
}

