/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.forge.config;

import io.yukkuric.hexparse.config.HexParseConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class HexParseConfigForge
implements HexParseConfig.API {
    public final ForgeConfigSpec.BooleanValue CfgShowColorfulNested;
    public final ForgeConfigSpec.BooleanValue CfgShowUnknownNBT;
    public final ForgeConfigSpec.EnumValue<HexParseConfig.ParseGreatPatternMode> CfgParseGreatSpells;
    public final ForgeConfigSpec.EnumValue<HexParseConfig.CommentParsingMode> CfgCommentParsingMode;
    public final ForgeConfigSpec.EnumValue<HexParseConfig.CommentParsingMode> CfgIndentParsingMode;
    public final ForgeConfigSpec.IntValue CfgParserBaseCost;
    public final ForgeConfigSpec.IntValue CfgMaxBlankLine;
    private static final Pair<HexParseConfigForge, ForgeConfigSpec> CFG_REGISTRY = new ForgeConfigSpec.Builder().configure(HexParseConfigForge::new);

    @Override
    public HexParseConfig.ParseGreatPatternMode canParseGreatPatterns() {
        return (HexParseConfig.ParseGreatPatternMode)((Object)this.CfgParseGreatSpells.get());
    }

    @Override
    public HexParseConfig.CommentParsingMode getCommentParsingMode() {
        return (HexParseConfig.CommentParsingMode)((Object)this.CfgCommentParsingMode.get());
    }

    @Override
    public HexParseConfig.CommentParsingMode getIndentParsingMode() {
        return (HexParseConfig.CommentParsingMode)((Object)this.CfgIndentParsingMode.get());
    }

    @Override
    public int getMaxBlankLineCount() {
        return (Integer)this.CfgMaxBlankLine.get();
    }

    @Override
    public boolean showColorfulNested() {
        return (Boolean)this.CfgShowColorfulNested.get();
    }

    @Override
    public boolean showUnknownNBT() {
        return (Boolean)this.CfgShowUnknownNBT.get();
    }

    @Override
    public int parserBaseCost() {
        return (Integer)this.CfgParserBaseCost.get();
    }

    public HexParseConfigForge(ForgeConfigSpec.Builder builder) {
        this.CfgParseGreatSpells = builder.comment("can directly parse great spell patterns, without scrolls").defineEnum("ParseGreatSpells", (Enum)HexParseConfig.ParseGreatPatternMode.BY_SCROLL);
        this.CfgCommentParsingMode = builder.comment("how comments get parsed into iotas\nALL: including `comment_%s`s and `/* */`s & `//`s;\nMANUAL(default): only `comment_%s`s;\nDISABLED: no comments at all").defineEnum("CommentParsingMode", (Enum)HexParseConfig.CommentParsingMode.MANUAL);
        this.CfgIndentParsingMode = builder.comment("how indents get parsed into iotas\nALL(default): coding indents will be auto-converted into `tab_%d`;\nMANUAL: only `tab_%d`s accepted;\nDISABLED: no indents at all").defineEnum("IndentParsingMode", (Enum)HexParseConfig.CommentParsingMode.ALL);
        this.CfgMaxBlankLine = builder.comment("how many continuous blank lines are allowed in parsed spell; excess ones will be ignored").defineInRange("MaxBlankLines", 0, 0, Integer.MAX_VALUE);
        this.CfgParserBaseCost = builder.comment("cost to parse single keyword into iota").defineInRange("ParserBaseCost", 0, 0, 100000);
        this.CfgShowColorfulNested = builder.comment("display colorful nested lists and intro/retros").define("ShowColorfulNested", true);
        this.CfgShowUnknownNBT = builder.comment("display unsupported iota's inner data as `UNKNOWN(serialized NBT)` rather than simple `UNKNOWN`").define("ShowUnknownNBT", true);
    }

    public static void register(ModLoadingContext ctx) {
        HexParseConfig.bindConfigImp((HexParseConfig.API)CFG_REGISTRY.getKey());
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CFG_REGISTRY.getValue());
    }
}

