/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.hooks;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.server.ScrungledPatternsSave;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.parsers.IotaFactory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PatternMapper {
    public static final Map<String, CompoundTag> mapPatternMeta = new HashMap<String, CompoundTag>();
    public static final Map<String, CompoundTag> mapPattern = new HashMap<String, CompoundTag>();
    public static final Map<String, CompoundTag> mapPatternWorld = new HashMap<String, CompoundTag>();
    public static final Map<String, String> mapShort2Long = new HashMap<String, String>();

    static void _setMap(Map<String, CompoundTag> map, ResourceLocation id, String seq, HexDir dir) {
        String idLong = id.toString();
        String idShort = id.m_135815_();
        CompoundTag pattern = IotaFactory.makePattern(seq, dir);
        map.put(idLong, pattern);
        map.put(idShort, pattern);
        String replace = mapShort2Long.put(idShort, idLong);
        if (replace != null && !replace.equals(idLong)) {
            HexParse.LOGGER.error("Duplicate ID for {} and {}", (Object)idLong, (Object)replace);
        }
    }

    public static void init(ServerLevel level) {
        mapPattern.clear();
        mapPatternWorld.clear();
        mapShort2Long.clear();
        Registry registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        ServerLevel overworld = level.m_7654_().m_129783_();
        DimensionDataStorage ds = overworld.m_8895_();
        ScrungledPatternsSave perWorldPatterns = ScrungledPatternsSave.createFromScratch((long)level.m_7328_());
        ds.m_164855_("hexcasting.per-world-patterns.0.1.0", (SavedData)perWorldPatterns);
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            if (HexUtils.isOfTag((Registry)registry, (ResourceKey)key, (TagKey)HexTags.Actions.PER_WORLD_PATTERN)) {
                Pair perWorldEntry = perWorldPatterns.lookupReverse(key);
                if (perWorldEntry == null) continue;
                PatternMapper._setMap(mapPatternWorld, key.m_135782_(), (String)perWorldEntry.getFirst(), ((ScrungledPatternsSave.PerWorldEntry)perWorldEntry.getSecond()).canonicalStartDir());
                continue;
            }
            HexPattern pattern = ((ActionRegistryEntry)entry.getValue()).prototype();
            PatternMapper._setMap(mapPattern, key.m_135782_(), pattern.anglesSignature(), pattern.getStartDir());
        }
    }

    public static void initLocal() {
        Registry registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            Map<String, CompoundTag> mapper = HexUtils.isOfTag((Registry)registry, (ResourceKey)key, (TagKey)HexTags.Actions.PER_WORLD_PATTERN) ? mapPatternWorld : mapPattern;
            PatternMapper._setMap(mapper, key.m_135782_(), "", HexDir.EAST);
        }
    }

    static {
        mapPatternMeta.put("\\", IotaFactory.makePattern("qqqaw", HexDir.WEST));
        mapPatternMeta.put("del", IotaFactory.makePattern("eeedw", HexDir.EAST));
        mapPatternMeta.put("(", IotaFactory.makePattern("qqq", HexDir.WEST));
        mapPatternMeta.put(")", IotaFactory.makePattern("eee", HexDir.EAST));
    }
}

