/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.macro;

import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;

public class MacroClient {
    static final Gson GSON = new Gson();
    static final Path BASE_DIR = Minecraft.m_91087_().f_91069_.toPath().resolve("hexParse/macro");
    static final String SAVENAME = "macro.json";
    static final int MAX_BACKUP = 3;
    static final File SAVE_TARGET;
    static final File[] SAVE_BAKS;
    static final Map<String, String> macros;
    static boolean dirty;

    static void stepBackup(File frm, File to) {
        if (!frm.exists()) {
            return;
        }
        if (to.exists()) {
            to.delete();
        }
        frm.renameTo(to);
    }

    public static void save() {
        BASE_DIR.toFile().mkdirs();
        if (!dirty && SAVE_TARGET.exists()) {
            return;
        }
        for (int i = 2; i > 0; --i) {
            MacroClient.stepBackup(SAVE_BAKS[i - 1], SAVE_BAKS[i]);
        }
        MacroClient.stepBackup(SAVE_TARGET, SAVE_BAKS[0]);
        try (FileOutputStream fos = new FileOutputStream(SAVE_TARGET);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             BufferedWriter bw = new BufferedWriter(osw);){
            bw.write(GSON.toJson(macros));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    static boolean tryLoad(File f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void load() {
        macros.clear();
        dirty = false;
        BASE_DIR.toFile().mkdirs();
        if (MacroClient.tryLoad(SAVE_TARGET)) {
            return;
        }
        for (File t : SAVE_BAKS) {
            if (!MacroClient.tryLoad(t)) continue;
            return;
        }
        MacroClient.initExampleMacros();
    }

    public static void entryOp(boolean isDefine, String key, String value) {
        dirty = true;
        if (isDefine) {
            if (value == null) {
                value = "";
            }
            macros.put(key, value);
        } else {
            macros.remove(key);
        }
    }

    static void initExampleMacros() {
        dirty = true;
        macros.put("#my_aim", "get_caster,entity_pos/eye,get_caster,get_entity_look");
        macros.put("#is_sneaking", "get_caster,get_entity_height,num_1.75,less");
        macros.put("#hello_world", "(print)(comment_Hello,comment_World)for_each,pop");
        macros.put("#debug", "stack_len,last_n_list,print,splat");
        macros.put("#return", "(())splat,pop,eval");
    }

    public static boolean preMatch(String key) {
        return macros.containsKey(key);
    }

    public static CompoundTag serialize() {
        CompoundTag pack = new CompoundTag();
        for (Map.Entry<String, String> pair : macros.entrySet()) {
            pack.m_128359_(pair.getKey(), pair.getValue());
        }
        return pack;
    }

    static {
        macros = new HashMap<String, String>();
        dirty = false;
        SAVE_TARGET = BASE_DIR.resolve(SAVENAME).toFile();
        ArrayList<File> baks = new ArrayList<File>();
        for (int i = 1; i <= 3; ++i) {
            baks.add(BASE_DIR.resolve("%s.bak%s".formatted(SAVENAME, i)).toFile());
        }
        SAVE_BAKS = (File[])baks.toArray(File[]::new);
    }
}

