/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.macro;

import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.macro.MsgUpdateClientMacro;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class MacroManager {
    public static final int MAX_MACRO_COUNT = 1024;
    public static final int MAX_SINGLE_MACRO_SIZE = 1024;
    static final Map<ServerPlayer, CompoundTag> playerMacros = new HashMap<ServerPlayer, CompoundTag>();

    public static void receivePlayerMacros(ServerPlayer player, CompoundTag pack) {
        playerMacros.put(player, pack);
    }

    static CompoundTag getPool(ServerPlayer player) {
        return playerMacros.getOrDefault(player, null);
    }

    public static boolean isMacro(String key) {
        return key.startsWith("#");
    }

    public static List<Pair<String, String>> listMacros(ServerPlayer player, boolean isMacro) {
        CompoundTag pool = MacroManager.getPool(player);
        if (pool == null) {
            return List.of();
        }
        ArrayList<Pair<String, String>> res = new ArrayList<Pair<String, String>>();
        for (String k : pool.m_128431_()) {
            if (MacroManager.isMacro(k) != isMacro) continue;
            res.add((Pair<String, String>)Pair.of((Object)k, (Object)pool.m_128461_(k)));
        }
        return res;
    }

    public static String getMacro(ServerPlayer player, String key) {
        CompoundTag pool = MacroManager.getPool(player);
        if (pool == null) {
            return null;
        }
        if (!pool.m_128425_(key, 8)) {
            return null;
        }
        return pool.m_128461_(key);
    }

    public static boolean willThisExceedLimit(ServerPlayer player, String key) {
        CompoundTag pool = MacroManager.getPool(player);
        if (pool == null) {
            return false;
        }
        if (pool.m_128441_(key)) {
            return false;
        }
        return pool.m_128440_() >= 1024;
    }

    public static void modifyMacro(ServerPlayer player, boolean isDefine, String key, String value) {
        CompoundTag pool = MacroManager.getPool(player);
        if (pool == null) {
            return;
        }
        if (isDefine) {
            pool.m_128359_(key, value);
        } else {
            pool.m_128473_(key);
        }
        MsgHandlers.SERVER.sendPacketToPlayer(player, new MsgUpdateClientMacro(isDefine, key, value));
        if (isDefine) {
            player.m_213846_((Component)Component.m_237110_((String)"hexparse.cmd.macro.define", (Object[])new Object[]{MacroManager.showGold(key), MacroManager.showGold(value)}));
        } else {
            player.m_213846_((Component)Component.m_237110_((String)"hexparse.cmd.macro.remove", (Object[])new Object[]{MacroManager.showGold(key)}));
        }
    }

    public static MutableComponent showGold(String val) {
        return CodeHelpers.wrapClickCopy(Component.m_237113_((String)val).m_130940_(ChatFormatting.GOLD), val);
    }
}

