/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.misc;

import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.storage.ItemFocus;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import at.petrak.hexcasting.common.items.storage.ItemThoughtKnot;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.hooks.PatternMapper;
import io.yukkuric.hexparse.misc.StringProcessors;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public interface CodeHelpers {
    public static final WeakReference<MinecraftServer> refreshedWorld = new WeakReference<Object>(null);
    public static final WeakReference<Boolean> refreshedLocal = new WeakReference<Boolean>(false);

    public static void doExtractMedia(ServerPlayer caster, long amount) {
        CastingVM harness = IXplatAbstractions.INSTANCE.getStaffcastVM(caster, InteractionHand.MAIN_HAND);
        harness.getEnv().extractMedia(amount, false);
    }

    public static IOMethod getItemIO(ServerPlayer player) {
        if (player == null) {
            return null;
        }
        IOMethod ret = IOMethod.get(player.m_21205_());
        if (ret == null) {
            ret = IOMethod.get(player.m_21206_());
        }
        return ret;
    }

    public static void doParse(ServerPlayer player, String code, String rename) {
        IOMethod target = CodeHelpers.getItemIO(player);
        if (target == null) {
            return;
        }
        CompoundTag nbt = ParserMain.ParseCode(code, player);
        target.write(nbt);
        if (rename != null) {
            target.rename(rename);
        }
    }

    public static void doParse(ServerPlayer player, List<String> code, String rename) {
        IOMethod target = CodeHelpers.getItemIO(player);
        if (target == null) {
            return;
        }
        CompoundTag nbt = ParserMain.ParseCode(code, player);
        target.write(nbt);
        if (rename != null) {
            target.rename(rename);
        }
    }

    public static String readHand(ServerPlayer player) {
        return CodeHelpers.readHand(player, StringProcessors.READ_DEFAULT);
    }

    public static String readHand(ServerPlayer player, StringProcessors.F post) {
        IOMethod target = CodeHelpers.getItemIO(player);
        if (target == null) {
            return null;
        }
        CompoundTag iotaRoot = target.read();
        if (iotaRoot == null) {
            return null;
        }
        CodeHelpers.autoRefresh(player.m_20194_());
        return ParserMain.ParseIotaNbt(iotaRoot, player, post);
    }

    public static void autoRefresh(MinecraftServer server) {
        if (server != refreshedWorld.get()) {
            ServerLevel level = server.m_129783_();
            HexParse.LOGGER.info("auto refresh for server: %s, level: %s".formatted(server.m_7326_(), level));
            PatternMapper.init(level);
            refreshedLocal.refersTo(true);
            refreshedWorld.refersTo(server);
        }
    }

    public static void autoRefreshLocal() {
        if (((Boolean)refreshedLocal.get()).booleanValue()) {
            return;
        }
        PatternMapper.initLocal();
        refreshedLocal.refersTo(true);
    }

    public static void displayCode(ServerPlayer player, String code) {
        if (player == null || code == null) {
            return;
        }
        MutableComponent display = Component.m_237110_((String)"hexparse.cmd.read.display", (Object[])new Object[]{Component.m_237113_((String)code).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN);
        player.m_213846_((Component)CodeHelpers.wrapClickCopy(display, code));
    }

    public static MutableComponent wrapClickCopy(MutableComponent component, String code) {
        return component.m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, code)).m_131144_(HoverEvent.Action.f_130831_.m_130854_((Component)Component.m_237115_((String)"chat.copy.click"))));
    }

    public static class IOMethod {
        private final BiConsumer<ItemStack, CompoundTag> writer;
        private final Function<ItemStack, CompoundTag> reader;
        private ItemStack current;
        private static Map<Class<? extends IotaHolderItem>, IOMethod> ITEM_IO_TYPES = new HashMap<Class<? extends IotaHolderItem>, IOMethod>();

        public IOMethod(Class<? extends IotaHolderItem> cls, BiConsumer<ItemStack, CompoundTag> writer, Function<ItemStack, CompoundTag> reader) {
            this.reader = reader;
            this.writer = writer;
            ITEM_IO_TYPES.put(cls, this);
        }

        public void write(CompoundTag nbt) {
            this.writer.accept(this.current, nbt);
        }

        public CompoundTag read() {
            if (this.reader == null) {
                return ((IotaHolderItem)this.current.m_41720_()).readIotaTag(this.current);
            }
            return this.reader.apply(this.current);
        }

        public void bind(ItemStack stack) {
            this.current = stack;
        }

        public void rename(String newName) {
            this.current.m_41714_((Component)Component.m_237113_((String)newName));
        }

        public Iota readIota(ServerLevel world) {
            return ((IotaHolderItem)this.current.m_41720_()).readIota(this.current, world);
        }

        static IOMethod get(ItemStack stack) {
            if (stack == null) {
                return null;
            }
            IOMethod ret = ITEM_IO_TYPES.get(stack.m_41720_().getClass());
            if (ret != null) {
                ret.bind(stack);
            }
            return ret;
        }

        static {
            BiConsumer<ItemStack, CompoundTag> simpleWrite = (target, nbt) -> target.m_41784_().m_128365_("data", (Tag)nbt);
            new IOMethod(ItemFocus.class, simpleWrite, null);
            new IOMethod(ItemThoughtKnot.class, simpleWrite, null);
            new IOMethod(ItemSpellbook.class, (stack, nbt) -> {
                int idx = ItemSpellbook.getPage((ItemStack)stack, (int)1);
                String pageKey = String.valueOf(idx);
                NBTHelper.getOrCreateCompound((ItemStack)stack, (String)ItemSpellbook.TAG_PAGES).m_128365_(pageKey, (Tag)nbt);
            }, null);
        }
    }
}

