/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.network;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.common.msgs.IMessage;
import io.netty.buffer.ByteBuf;
import io.yukkuric.hexparse.commands.CommandMindStackIO;
import io.yukkuric.hexparse.macro.MacroManager;
import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.network.ClipboardMsgMode;
import io.yukkuric.hexparse.network.MsgHelpers;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.util.ArrayList;
import java.util.List;
import miyucomics.hexcellular.StateStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public record MsgPushClipboard(List<String> code, String rename, ClipboardMsgMode mode) implements IMessage
{
    public static final ResourceLocation ID = new ResourceLocation("hexparse", "clipboard/push");

    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(this.code.size());
        for (String f : this.code) {
            MsgHelpers.putString(buf, f);
        }
        MsgHelpers.putString(buf, this.rename);
        buf.writeByte(this.mode.ordinal());
    }

    public ResourceLocation getFabricId() {
        return ID;
    }

    public static MsgPushClipboard deserialize(ByteBuf buffer) {
        ClipboardMsgMode mode;
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        ArrayList<String> code = new ArrayList<String>();
        int len = buf.readInt();
        for (int i = 0; i < len; ++i) {
            code.add(MsgHelpers.getString(buf));
        }
        String name = MsgHelpers.getString(buf);
        try {
            mode = ClipboardMsgMode.values()[buf.readByte()];
        }
        catch (IndexOutOfBoundsException e) {
            mode = ClipboardMsgMode.DEFAULT;
        }
        catch (Throwable e) {
            mode = ClipboardMsgMode.INVALID;
        }
        return new MsgPushClipboard(code, name, mode);
    }

    public static void handle(MsgPushClipboard self, ServerPlayer sender) {
        if (self.mode == ClipboardMsgMode.INVALID) {
            return;
        }
        if (self.mode == ClipboardMsgMode.MACRO_DEFINE) {
            String macro = String.join((CharSequence)",", self.code);
            MacroManager.modifyMacro(sender, true, self.rename, macro);
        } else if (self.mode == ClipboardMsgMode.WRITE_PROPERTY) {
            CompoundTag nbt = ParserMain.ParseCode(self.code, sender);
            ServerLevel world = sender.m_284548_();
            StateStorage.Companion.setProperty(world, self.rename, IotaType.deserialize((CompoundTag)nbt, (ServerLevel)world));
        } else if (self.mode == ClipboardMsgMode.PUSH_MIND) {
            CompoundTag nbt = ParserMain.ParseCode(self.code, sender);
            CommandMindStackIO.INSTANCE.writeStackWithIota(sender, nbt);
        } else {
            CodeHelpers.doParse(sender, self.code, self.rename);
        }
    }
}

