/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers;

import io.yukkuric.hexparse.config.HexParseConfig;
import io.yukkuric.hexparse.misc.StringEscaper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ-\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ-\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ-\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0011\u0010\rJ#\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J%\u0010\u0015\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0007R&\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010(\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\"\u0010.\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010)\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\"\u00101\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u0010)\u001a\u0004\b2\u0010+\"\u0004\b3\u0010-R\"\u00104\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u0010)\u001a\u0004\b5\u0010+\"\u0004\b6\u0010-R\"\u00107\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u0010)\u001a\u0004\b8\u0010+\"\u0004\b9\u0010-R\"\u0010;\u001a\u00020:8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@\u00a8\u0006A"}, d2={"Lio/yukkuric/hexparse/parsers/CodeCutter;", "", "<init>", "()V", "", "comment", "commentToCommentString", "(Ljava/lang/String;)Ljava/lang/String;", "code", "", "commentsToIota", "Lkotlin/Pair;", "consumeBlockComment", "(Ljava/lang/String;Z)Lkotlin/Pair;", "consumeComment", "consumeLineComment", "addIndent", "consumeNewline", "consumeString", "(Ljava/lang/String;)Lkotlin/Pair;", "consumeToken", "consumeWhiteSpace", "", "splitCode", "(Ljava/lang/String;)Ljava/util/List;", "(Ljava/lang/String;ZZ)Ljava/util/List;", "match", "toIndent", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "VALID_WHITESPACE", "Ljava/util/HashSet;", "newLineThisTurn", "Z", "getNewLineThisTurn", "()Z", "setNewLineThisTurn", "(Z)V", "Ljava/util/regex/Pattern;", "pCommentBlock", "Ljava/util/regex/Pattern;", "getPCommentBlock", "()Ljava/util/regex/Pattern;", "setPCommentBlock", "(Ljava/util/regex/Pattern;)V", "pCommentLine", "getPCommentLine", "setPCommentLine", "pLineBreak", "getPLineBreak", "setPLineBreak", "pLineStart", "getPLineStart", "setPLineStart", "pTokens", "getPTokens", "setPTokens", "", "seqNewLineCount", "I", "getSeqNewLineCount", "()I", "setSeqNewLineCount", "(I)V", "hexParse-common"})
public final class CodeCutter {
    @NotNull
    public static final CodeCutter INSTANCE = new CodeCutter();
    @NotNull
    private static Pattern pCommentLine;
    @NotNull
    private static Pattern pLineBreak;
    @NotNull
    private static Pattern pCommentBlock;
    @NotNull
    private static Pattern pTokens;
    @NotNull
    private static Pattern pLineStart;
    private static boolean newLineThisTurn;
    private static int seqNewLineCount;
    @NotNull
    private static HashSet<Character> VALID_WHITESPACE;

    private CodeCutter() {
    }

    @NotNull
    public final Pattern getPCommentLine() {
        return pCommentLine;
    }

    public final void setPCommentLine(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"<set-?>");
        pCommentLine = pattern;
    }

    @NotNull
    public final Pattern getPLineBreak() {
        return pLineBreak;
    }

    public final void setPLineBreak(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"<set-?>");
        pLineBreak = pattern;
    }

    @NotNull
    public final Pattern getPCommentBlock() {
        return pCommentBlock;
    }

    public final void setPCommentBlock(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"<set-?>");
        pCommentBlock = pattern;
    }

    @NotNull
    public final Pattern getPTokens() {
        return pTokens;
    }

    public final void setPTokens(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"<set-?>");
        pTokens = pattern;
    }

    @NotNull
    public final Pattern getPLineStart() {
        return pLineStart;
    }

    public final void setPLineStart(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"<set-?>");
        pLineStart = pattern;
    }

    public final boolean getNewLineThisTurn() {
        return newLineThisTurn;
    }

    public final void setNewLineThisTurn(boolean bl) {
        newLineThisTurn = bl;
    }

    public final int getSeqNewLineCount() {
        return seqNewLineCount;
    }

    public final void setSeqNewLineCount(int n) {
        seqNewLineCount = n;
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitCode(@NotNull String code) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        HexParseConfig.CommentParsingMode commentMode = HexParseConfig.getCommentParsingMode();
        HexParseConfig.CommentParsingMode indentMode = HexParseConfig.getIndentParsingMode();
        return INSTANCE.splitCode(code, indentMode == HexParseConfig.CommentParsingMode.ALL, commentMode == HexParseConfig.CommentParsingMode.ALL);
    }

    private final String toIndent(String match) {
        String string = "tab_%d";
        Object[] objectArray = new Object[]{match.length()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    private final Pair<String, String> consumeToken(String code) {
        Matcher matcher = pTokens.matcher(code);
        if (!matcher.find()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = matcher.group();
        String string2 = code.substring(matcher.end());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        return new Pair((Object)string, (Object)string2);
    }

    private final String commentToCommentString(String comment) {
        return "c\"" + StringEscaper.Companion.escape(comment) + "\"";
    }

    private final Pair<String, String> consumeLineComment(String code, boolean commentsToIota) {
        Matcher matcher = pCommentLine.matcher(code);
        matcher.find();
        String string = matcher.group();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group()");
        String string2 = string;
        int n = 2;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        String commentContents = string3;
        String commentTokenIfRequested = commentsToIota ? this.commentToCommentString(commentContents) : null;
        String string4 = code.substring(matcher.end());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        return new Pair((Object)commentTokenIfRequested, (Object)string4);
    }

    private final Pair<String, String> consumeBlockComment(String code, boolean commentsToIota) {
        Pair pair;
        Matcher matcher = pCommentBlock.matcher(code);
        matcher.find();
        if (commentsToIota) {
            String match;
            String string = match = matcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"match");
            String string2 = string;
            int n = 2;
            int n2 = match.length() - 2;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string4 = match = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"match");
            String string5 = this.commentToCommentString(string4);
            String string6 = code.substring(matcher.end());
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
            pair = new Pair((Object)string5, (Object)string6);
        } else {
            String string = code.substring(matcher.end());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            pair = new Pair(null, (Object)string);
        }
        return pair;
    }

    private final Pair<String, String> consumeWhiteSpace(String code) {
        int index = 0;
        while (CollectionsKt.contains((Iterable)VALID_WHITESPACE, (Object)StringsKt.getOrNull((CharSequence)code, (int)index))) {
            ++index;
        }
        String string = code.substring(index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return new Pair(null, (Object)string);
    }

    private final Pair<String, String> consumeNewline(String code, boolean addIndent) {
        String string;
        String input = pLineBreak.matcher(code).replaceFirst("");
        newLineThisTurn = true;
        Matcher matcher = pLineStart.matcher(input);
        matcher.find();
        if (addIndent) {
            String string2 = matcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group()");
            string = this.toIndent(string2);
        } else {
            string = null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
        String string3 = input.substring(matcher.end());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        return new Pair((Object)string, (Object)string3);
    }

    private final Pair<String, String> consumeString(String code) {
        int index = 1;
        while (code.charAt(index) != '\"') {
            if (code.charAt(index) == '\\') {
                ++index;
            }
            if (++index < code.length()) continue;
            throw new IllegalArgumentException("unclosed string literal: " + code);
        }
        String string = StringsKt.substring((String)code, (IntRange)new IntRange(0, index));
        String string2 = code.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        return new Pair((Object)string, (Object)string2);
    }

    private final Pair<String, String> consumeComment(String code, boolean commentsToIota) {
        Pair<String, String> pair;
        Character c;
        Character c2 = c = StringsKt.getOrNull((CharSequence)code, (int)1);
        char c3 = '*';
        if (c2 != null && c2.charValue() == c3) {
            pair = this.consumeBlockComment(code, commentsToIota);
        } else {
            Character c4 = c;
            c3 = '/';
            if (c4 != null && c4.charValue() == c3) {
                pair = this.consumeLineComment(code, commentsToIota);
            } else {
                throw new IllegalArgumentException("invalid comment: " + code);
            }
        }
        return pair;
    }

    private final List<String> splitCode(String code, boolean addIndent, boolean commentsToIota) throws IllegalArgumentException {
        String code2 = code;
        List list = new ArrayList();
        seqNewLineCount = 0;
        while (((CharSequence)code2).length() > 0) {
            newLineThisTurn = false;
            char c = code2.charAt(0);
            Pair<String, String> pair = c == '/' ? this.consumeComment(code2, commentsToIota) : (c == '\"' ? this.consumeString(code2) : (VALID_WHITESPACE.contains(Character.valueOf(c)) ? this.consumeWhiteSpace(code2) : ((c == '\r' ? true : c == '\n') ? this.consumeNewline(code2, addIndent) : this.consumeToken(code2))));
            String token = (String)pair.component1();
            String newCode = (String)pair.component2();
            if (token != null) {
                if (newLineThisTurn) {
                    int n = seqNewLineCount;
                    if ((seqNewLineCount = n + 1) > HexParseConfig.getMaxBlankLineCount()) {
                        if (list.isEmpty()) {
                            token = null;
                        } else {
                            CollectionsKt.removeLastOrNull((List)list);
                        }
                    }
                } else {
                    seqNewLineCount = -1;
                }
            }
            if (Intrinsics.areEqual((Object)code2, (Object)newCode)) {
                String string = code2.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                newCode = string;
            }
            code2 = newCode;
            if (token == null) continue;
            list.add(token);
        }
        return list;
    }

    static /* synthetic */ List splitCode$default(CodeCutter codeCutter, String string, boolean bl, boolean bl2, int n, Object object) throws IllegalArgumentException {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return codeCutter.splitCode(string, bl, bl2);
    }

    static {
        Pattern pattern = Pattern.compile("//.*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"//.*\")");
        pCommentLine = pattern;
        Pattern pattern2 = Pattern.compile("\\r?\\n");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(\"\\\\r?\\\\n\")");
        pLineBreak = pattern2;
        Pattern pattern3 = Pattern.compile("(?s)/\\*.*?\\*/");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(\"(?s)/\\\\*.*?\\\\*/\")");
        pCommentBlock = pattern3;
        Pattern pattern4 = Pattern.compile("\\\\|\\(|\\)|\\[|]|[\\w./\\-:#\u0100-\uffff]+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(\"\\\\\\\\|\\\\(|\\\\)|\\\\\u2026w./\\\\-:#\\u0100-\\uffff]+\")");
        pTokens = pattern4;
        Pattern pattern5 = Pattern.compile("^[ \\t]*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern5, (String)"compile(\"^[ \\\\t]*\")");
        pLineStart = pattern5;
        Object[] objectArray = new Character[]{Character.valueOf(';'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('\t')};
        VALID_WHITESPACE = SetsKt.hashSetOf((Object[])objectArray);
    }
}

