/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers;

import io.yukkuric.hexparse.parsers.IotaFactory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class PluginIotaFactory
extends IotaFactory {
    public static final String TYPE_IOTA_TYPE = "moreiotas:iota_type";
    public static final String TYPE_ENTITY_TYPE = "moreiotas:entity_type";
    public static final String TYPE_ITEM_TYPE = "moreiotas:item_type";
    public static final String TYPE_STRING = "moreiotas:string";
    public static final String TYPE_GATE = "hexal:gate";
    public static final String TYPE_MOTE = "hexal:item";
    public static final String TYPE_PROP = "hexcellular:property";

    public static CompoundTag makeIotaType(String type) {
        return PluginIotaFactory.makeType(TYPE_IOTA_TYPE, (Tag)StringTag.m_129297_((String)type));
    }

    public static CompoundTag makeEntityType(String type) {
        return PluginIotaFactory.makeType(TYPE_ENTITY_TYPE, (Tag)StringTag.m_129297_((String)type));
    }

    public static CompoundTag makeItemType(String type, boolean isBlock) {
        CompoundTag body = new CompoundTag();
        body.m_128359_(isBlock ? "block" : "item", type);
        return PluginIotaFactory.makeType(TYPE_ITEM_TYPE, (Tag)body);
    }

    public static CompoundTag makeItemType(String type) {
        return PluginIotaFactory.makeItemType(type, false);
    }

    public static CompoundTag makeBlockType(String type) {
        return PluginIotaFactory.makeItemType(type, true);
    }

    public static CompoundTag makeString(String data) {
        return PluginIotaFactory.makeType(TYPE_STRING, (Tag)StringTag.m_129297_((String)data));
    }

    public static CompoundTag makeProperty(CompoundTag packed) {
        return PluginIotaFactory.makeType(TYPE_PROP, (Tag)packed);
    }

    public static CompoundTag makeGate(int id, Vec3 pos, Entity binder) {
        byte type = 0;
        if (binder != null) {
            type = 2;
            if (pos == null) {
                pos = Vec3.f_82478_;
            }
        } else if (pos != null) {
            type = 1;
        }
        CompoundTag payload = new CompoundTag();
        payload.m_128405_("index", id);
        payload.m_128344_("target_type", type);
        if (pos != null) {
            payload.m_128347_("target_x", pos.f_82479_);
            payload.m_128347_("target_y", pos.f_82480_);
            payload.m_128347_("target_z", pos.f_82481_);
        }
        if (binder != null) {
            payload.m_128362_("target_uuid", binder.m_20148_());
            payload.m_128359_("target_name", binder.m_7755_().getString());
        }
        return PluginIotaFactory.makeType(TYPE_GATE, (Tag)payload);
    }
}

