/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers.str2nbt;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import io.yukkuric.hexparse.config.HexParseConfig;
import io.yukkuric.hexparse.misc.NumEvaluatorBrute;
import io.yukkuric.hexparse.misc.StringEscaper;
import io.yukkuric.hexparse.parsers.IotaFactory;
import io.yukkuric.hexparse.parsers.str2nbt.BaseConstParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public class ConstParsers {
    public static BaseConstParser TO_TAB = new BaseConstParser.Comment("tab"){

        @Override
        public CompoundTag parse(String node) {
            int indent = 0;
            try {
                indent = Integer.parseInt(node.substring(4));
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
            return IotaFactory.makeTab(indent);
        }

        @Override
        public boolean ignored() {
            return HexParseConfig.getIndentParsingMode() == HexParseConfig.CommentParsingMode.DISABLED;
        }
    };
    public static BaseConstParser TO_COMMENT = new BaseConstParser.Comment("comment_"){

        @Override
        public CompoundTag parse(String node) {
            return IotaFactory.makeComment(node.substring(8));
        }
    };
    public static BaseConstParser TO_SCOMMENT = new BaseConstParser.Comment("c\""){

        @Override
        public CompoundTag parse(String node) {
            return IotaFactory.makeComment(StringEscaper.Companion.unescape(node.substring(1)));
        }
    };
    public static BaseConstParser TO_VEC = new BaseConstParser.Prefix("vec"){

        @Override
        public CompoundTag parse(String node) {
            String[] frags = node.split("_");
            double[] axes = new double[3];
            for (int i = 1; i <= 3; ++i) {
                axes[i - 1] = 0.0;
                if (i >= frags.length) continue;
                try {
                    axes[i - 1] = Double.parseDouble(frags[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return IotaType.serialize((Iota)new Vec3Iota(new Vec3(axes[0], axes[1], axes[2])));
        }
    };
    public static BaseConstParser TO_NUM_PATTERN = new BaseConstParser.Prefix("num"){

        @Override
        public CompoundTag parse(String node) {
            double num = 0.0;
            try {
                num = Double.parseDouble(node.split("_")[1]);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
            String seq = NumEvaluatorBrute.getAnglesFromNum(num);
            return IotaFactory.makePattern(seq, num < 0.0 ? HexDir.NORTH_EAST : HexDir.SOUTH_EAST);
        }
    };
    public static BaseConstParser TO_NUM = new BaseConstParser.Regex("^[0-9.\\-]+(e[0-9.\\-]+)?$"){

        @Override
        public CompoundTag parse(String node) {
            try {
                return IotaFactory.makeNum(Double.parseDouble(node));
            }
            catch (NumberFormatException e) {
                return IotaFactory.makeNum(Double.NaN);
            }
        }
    };
    public static BaseConstParser TO_RAW_PATTERN = new BaseConstParser.Regex("^_[wedsaq]*$"){

        @Override
        public CompoundTag parse(String node) {
            return IotaFactory.makePattern(node.substring(1), HexDir.EAST);
        }
    };
    public static BaseConstParser TO_MASK = new BaseConstParser.Regex("^mask_[-v]+$"){

        @Override
        public CompoundTag parse(String node) {
            StringBuilder seq = new StringBuilder();
            boolean line = true;
            HexDir start = HexDir.EAST;
            if (node.charAt(5) == 'v') {
                line = false;
                seq.append('a');
                start = HexDir.SOUTH_EAST;
            }
            for (char c : node.substring(6).toCharArray()) {
                if (c == '-') {
                    seq.append(line ? (char)'w' : 'e');
                    line = true;
                    continue;
                }
                seq.append(line ? "ea" : "da");
                line = false;
            }
            return IotaFactory.makePattern(seq.toString(), start);
        }
    };
}

