/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;

@OnlyIn(value=Dist.CLIENT)
public interface Mesh {
    public void initialize();

    public void draw(PoseStack var1, VertexConsumer var2, DrawingFunction var3, int var4, float var5, float var6, float var7, float var8, int var9);

    public void drawPosed(PoseStack var1, VertexConsumer var2, DrawingFunction var3, int var4, float var5, float var6, float var7, float var8, int var9, Armature var10, OpenMatrix4f[] var11);

    @OnlyIn(value=Dist.CLIENT)
    @FunctionalInterface
    public static interface DrawingFunction {
        public static final DrawingFunction NEW_ENTITY = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> builder.m_5954_(posX, posY, posZ, r, g, b, a, u, v, overlay, packedLight, normX, normY, normZ);
        public static final DrawingFunction POSITION_TEX_COLOR_NORMAL = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> {
            builder.m_5483_((double)posX, (double)posY, (double)posZ);
            builder.m_7421_(u, v);
            builder.m_85950_(r, g, b, a);
            builder.m_5601_(normX, normY, normZ);
            builder.m_5752_();
        };
        public static final DrawingFunction POSITION_TEX_COLOR_LIGHTMAP = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> {
            builder.m_5483_((double)posX, (double)posY, (double)posZ);
            builder.m_7421_(u, v);
            builder.m_85950_(r, g, b, a);
            builder.m_85969_(packedLight);
            builder.m_5752_();
        };
        public static final DrawingFunction POSITION_COLOR_LIGHTMAP = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> {
            builder.m_5483_((double)posX, (double)posY, (double)posZ);
            builder.m_85950_(r, g, b, a);
            builder.m_85969_(packedLight);
            builder.m_5752_();
        };
        public static final DrawingFunction POSITION_COLOR_NORMAL = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> {
            builder.m_5483_((double)posX, (double)posY, (double)posZ);
            builder.m_85950_(r, g, b, a);
            builder.m_5601_(normX, normY, normZ);
            builder.m_5752_();
        };
        public static final DrawingFunction POSITION_COLOR_TEX_LIGHTMAP = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> {
            builder.m_5483_((double)posX, (double)posY, (double)posZ);
            builder.m_85950_(r, g, b, a);
            builder.m_7421_(u, v);
            builder.m_85969_(packedLight);
            builder.m_5752_();
        };

        public void draw(VertexConsumer var1, float var2, float var3, float var4, float var5, float var6, float var7, int var8, float var9, float var10, float var11, float var12, float var13, float var14, int var15);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record RenderProperties(ResourceLocation customTexturePath, Vec3f customColor, boolean isTransparent) {

        public static class Builder {
            protected String customTexturePath;
            protected Vec3f customColor = new Vec3f();
            protected boolean isTransparent;

            public Builder customTexturePath(String path) {
                this.customTexturePath = path;
                return this;
            }

            public Builder transparency(boolean isTransparent) {
                this.isTransparent = isTransparent;
                return this;
            }

            public Builder customColor(float r, float g, float b) {
                this.customColor.x = r;
                this.customColor.y = g;
                this.customColor.z = b;
                return this;
            }

            public RenderProperties build() {
                return new RenderProperties(this.customTexturePath == null ? null : ResourceLocation.parse((String)this.customTexturePath), this.customColor, this.isTransparent);
            }

            public static Builder create() {
                return new Builder();
            }
        }
    }
}

