/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.MeshPart;
import yesman.epicfight.api.client.model.MeshPartDefinition;
import yesman.epicfight.api.client.model.StaticMesh;
import yesman.epicfight.api.client.model.VertexBuilder;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.EpicFightVertexFormatElement;
import yesman.epicfight.client.renderer.shader.AnimationShaderInstance;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.main.EpicFightSharedConstants;

@OnlyIn(value=Dist.CLIENT)
public class SkinnedMesh
extends StaticMesh<SkinnedMeshPart> {
    protected final float[] weights;
    protected final int[] affectingJointCounts;
    protected final int[][] affectingWeightIndices;
    protected final int[][] affectingJointIndices;
    private final int maxJointCount;
    private int arrayObjectId;
    private boolean bufferInitialized;
    private VertexBuffer<Float> positionsBuffer;
    private VertexBuffer<Float> uvsBuffer;
    private VertexBuffer<Byte> normalsBuffer;
    private VertexBuffer<Short> jointsBuffer;
    private VertexBuffer<Float> weightsBuffer;
    private static final Vec4f TRANSFORM = new Vec4f();
    private static final Vec4f POS = new Vec4f();
    private static final Vec4f TOTAL_POS = new Vec4f();
    private static final Vec4f NORM = new Vec4f();
    private static final Vec4f TOTAL_NORM = new Vec4f();
    protected static final Vector4f POSITION = new Vector4f();
    protected static final Vector3f NORMAL = new Vector3f();
    protected static final OpenMatrix4f[] FINAL_POSES = OpenMatrix4f.allocateMatrixArray(1000);
    protected static final OpenMatrix4f[] NORMAL_POSES = OpenMatrix4f.allocateMatrixArray(1000);

    public SkinnedMesh(@Nullable Map<String, Number[]> arrayMap, @Nullable Map<MeshPartDefinition, List<VertexBuilder>> partBuilders, @Nullable SkinnedMesh parent, Mesh.RenderProperties properties) {
        super(arrayMap, partBuilders, parent, properties);
        this.weights = parent == null ? ParseUtil.unwrapFloatWrapperArray(arrayMap.get("weights")) : parent.weights;
        int[] nArray = this.affectingJointCounts = parent == null ? ParseUtil.unwrapIntWrapperArray(arrayMap.get("vcounts")) : parent.affectingJointCounts;
        if (parent != null) {
            this.affectingJointIndices = parent.affectingJointIndices;
            this.affectingWeightIndices = parent.affectingWeightIndices;
        } else {
            int[] vindices = ParseUtil.unwrapIntWrapperArray(arrayMap.get("vindices"));
            this.affectingJointIndices = new int[this.affectingJointCounts.length][];
            this.affectingWeightIndices = new int[this.affectingJointCounts.length][];
            int idx = 0;
            for (int i = 0; i < this.affectingJointCounts.length; ++i) {
                int count = this.affectingJointCounts[i];
                int[] jointId = new int[count];
                int[] weights = new int[count];
                for (int j = 0; j < count; ++j) {
                    jointId[j] = vindices[idx * 2];
                    weights[j] = vindices[idx * 2 + 1];
                    ++idx;
                }
                this.affectingJointIndices[i] = jointId;
                this.affectingWeightIndices[i] = weights;
            }
        }
        int maxJointId = 0;
        int[][] nArray2 = this.affectingJointIndices;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            int[] i2;
            for (int j : i2 = nArray2[i]) {
                if (maxJointId >= j) continue;
                maxJointId = j;
            }
        }
        this.maxJointCount = maxJointId;
        if (RenderSystem.isOnRenderThread()) {
            this.initBuffers();
        } else {
            RenderSystem.recordRenderCall(this::initBuffers);
        }
    }

    public void initBuffers() {
        this.positionsBuffer = new VertexBuffer<Float>(5126, 3, false, ByteBuffer::putFloat);
        this.uvsBuffer = new VertexBuffer<Float>(5126, 2, false, ByteBuffer::putFloat);
        this.normalsBuffer = new VertexBuffer<Byte>(5120, 3, true, ByteBuffer::put);
        this.jointsBuffer = new VertexBuffer<Short>(5122, 3, false, ByteBuffer::putShort);
        this.weightsBuffer = new VertexBuffer<Float>(5126, 3, false, ByteBuffer::putFloat);
        this.arrayObjectId = GlStateManager._glGenVertexArrays();
        ArrayList positionList = Lists.newArrayList();
        ArrayList uvList = Lists.newArrayList();
        ArrayList normalList = Lists.newArrayList();
        ArrayList jointList = Lists.newArrayList();
        ArrayList weightList = Lists.newArrayList();
        HashMap vertexBuilderMap = Maps.newHashMap();
        int currentBoundVao = GlStateManager._getInteger((int)34229);
        int currentBoundVbo = GlStateManager._getInteger((int)34966);
        GlStateManager._glBindVertexArray((int)this.arrayObjectId);
        for (SkinnedMeshPart part : this.parts.values()) {
            part.createVbo(vertexBuilderMap, this.positions, this.uvs, this.normals, this.weights, this.affectingJointCounts, this.affectingJointIndices, this.affectingWeightIndices, positionList, uvList, normalList, jointList, weightList);
        }
        this.positionsBuffer.bindVertexData(positionList);
        this.uvsBuffer.bindVertexData(uvList);
        this.normalsBuffer.bindVertexData(normalList);
        this.jointsBuffer.bindVertexData(jointList);
        this.weightsBuffer.bindVertexData(weightList);
        GlStateManager._glBindVertexArray((int)currentBoundVao);
        GlStateManager._glBindBuffer((int)34962, (int)currentBoundVbo);
        this.bufferInitialized = true;
    }

    public void pointPositionsBuffer(int attrIndex) {
        this.positionsBuffer.vertexAttribPointer(attrIndex);
    }

    public void uvPositionsBuffer(int attrIndex) {
        this.uvsBuffer.vertexAttribPointer(attrIndex);
    }

    public void normalPositionsBuffer(int attrIndex) {
        this.normalsBuffer.vertexAttribPointer(attrIndex);
    }

    public void jointPositionsBuffer(int attrIndex) {
        this.jointsBuffer.vertexAttribPointer(attrIndex);
    }

    public void weightPositionsBuffer(int attrIndex) {
        this.weightsBuffer.vertexAttribPointer(attrIndex);
    }

    public void destroy() {
        if (!this.bufferInitialized) {
            return;
        }
        this.positionsBuffer.destroy();
        this.uvsBuffer.destroy();
        this.normalsBuffer.destroy();
        this.jointsBuffer.destroy();
        this.weightsBuffer.destroy();
        this.parts.values().forEach(part -> RenderSystem.glDeleteBuffers((int)part.indexBufferId));
        RenderSystem.glDeleteVertexArrays((int)this.arrayObjectId);
        this.arrayObjectId = -1;
    }

    @Override
    protected Map<String, SkinnedMeshPart> createModelPart(Map<MeshPartDefinition, List<VertexBuilder>> partBuilders) {
        HashMap parts = Maps.newHashMap();
        partBuilders.forEach((partDefinition, vertexBuilder) -> parts.put(partDefinition.partName(), new SkinnedMeshPart((List<VertexBuilder>)vertexBuilder, partDefinition.renderProperties(), partDefinition.getModelPartAnimationProvider())));
        return parts;
    }

    @Override
    protected SkinnedMeshPart getOrLogException(Map<String, SkinnedMeshPart> parts, String name) {
        if (!parts.containsKey(name)) {
            if (EpicFightSharedConstants.IS_DEV_ENV) {
                EpicFightMod.LOGGER.debug("Cannot find the mesh part named " + name + " in " + this.getClass().getCanonicalName());
            }
            return null;
        }
        return parts.get(name);
    }

    @Override
    public void getVertexPosition(int positionIndex, Vector4f dest, @Nullable OpenMatrix4f[] poses) {
        int index = positionIndex * 3;
        POS.set(this.positions[index], this.positions[index + 1], this.positions[index + 2], 1.0f);
        TOTAL_POS.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = 0; i < this.affectingJointCounts[positionIndex]; ++i) {
            int jointIndex = this.affectingJointIndices[positionIndex][i];
            int weightIndex = this.affectingWeightIndices[positionIndex][i];
            float weight = this.weights[weightIndex];
            Vec4f.add(OpenMatrix4f.transform(poses[jointIndex], POS, TRANSFORM).scale(weight), TOTAL_POS, TOTAL_POS);
        }
        dest.set(SkinnedMesh.TOTAL_POS.x, SkinnedMesh.TOTAL_POS.y, SkinnedMesh.TOTAL_POS.z, 1.0f);
    }

    @Override
    public void getVertexNormal(int positionIndex, int normalIndex, Vector3f dest, @Nullable OpenMatrix4f[] poses) {
        int index = normalIndex * 3;
        NORM.set(this.normals[index], this.normals[index + 1], this.normals[index + 2], 1.0f);
        TOTAL_NORM.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = 0; i < this.affectingJointCounts[positionIndex]; ++i) {
            int jointIndex = this.affectingJointIndices[positionIndex][i];
            int weightIndex = this.affectingWeightIndices[positionIndex][i];
            float weight = this.weights[weightIndex];
            Vec4f.add(OpenMatrix4f.transform(poses[jointIndex], NORM, TRANSFORM).scale(weight), TOTAL_NORM, TOTAL_NORM);
        }
        dest.set(SkinnedMesh.TOTAL_NORM.x, SkinnedMesh.TOTAL_NORM.y, SkinnedMesh.TOTAL_NORM.z);
    }

    @Override
    public void draw(PoseStack poseStack, VertexConsumer bufferbuilder, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a, int overlay) {
        for (SkinnedMeshPart part : this.parts.values()) {
            part.draw(poseStack, bufferbuilder, drawingFunction, packedLight, r, g, b, a, overlay);
        }
    }

    @Override
    public void drawPosed(PoseStack poseStack, VertexConsumer bufferbuilder, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a, int overlay, Armature armature, OpenMatrix4f[] poses) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        for (SkinnedMeshPart part : this.parts.values()) {
            if (part.isHidden()) continue;
            OpenMatrix4f transform = part.getVanillaPartTransform();
            for (int i = 0; i < poses.length; ++i) {
                FINAL_POSES[i].load(poses[i]);
                if (armature != null) {
                    FINAL_POSES[i].mulBack(armature.searchJointById(i).getToOrigin());
                }
                if (transform != null) {
                    FINAL_POSES[i].mulBack(transform);
                }
                SkinnedMesh.NORMAL_POSES[i] = FINAL_POSES[i].removeTranslation();
            }
            for (VertexBuilder vi : part.getVertices()) {
                this.getVertexPosition(vi.position, POSITION, FINAL_POSES);
                this.getVertexNormal(vi.position, vi.normal, NORMAL, NORMAL_POSES);
                POSITION.mul((Matrix4fc)matrix4f);
                NORMAL.mul((Matrix3fc)matrix3f);
                drawingFunction.draw(bufferbuilder, SkinnedMesh.POSITION.x, SkinnedMesh.POSITION.y, SkinnedMesh.POSITION.z, SkinnedMesh.NORMAL.x, SkinnedMesh.NORMAL.y, SkinnedMesh.NORMAL.z, packedLight, r, g, b, a, this.uvs[vi.uv * 2], this.uvs[vi.uv * 2 + 1], overlay);
            }
        }
    }

    public void draw(PoseStack poseStack, MultiBufferSource bufferSources, RenderType renderType, int packedLight, float r, float g, float b, float a, int overlay, Armature armature, OpenMatrix4f[] poses) {
        if (ClientConfig.activateAnimationShader && armature.getJointNumber() <= 50) {
            renderType.m_110185_();
            AnimationShaderInstance animationShader = EpicFightRenderTypes.getAnimationShader(renderType);
            this.drawWithShader(poseStack, animationShader, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, overlay, armature, poses);
            renderType.m_110188_();
        } else {
            this.drawPosed(poseStack, bufferSources.m_6299_(EpicFightRenderTypes.getTriangulated(renderType)), Mesh.DrawingFunction.NEW_ENTITY, packedLight, r, g, b, a, overlay, armature, poses);
        }
    }

    public void drawWithShader(PoseStack poseStack, ShaderInstance shader, int packedLight, float r, float g, float b, float a, int overlay, Armature armature, OpenMatrix4f[] poses) {
        AnimationShaderInstance animationShader = EpicFightRenderTypes.getAnimationShader(shader);
        this.drawWithShader(poseStack, animationShader, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, armature, poses);
    }

    public void drawWithShader(PoseStack poseStack, AnimationShaderInstance animationShaderInstance, int packedLight, float r, float g, float b, float a, int overlay, Armature armature, OpenMatrix4f[] poses) {
        if (this.arrayObjectId < 0) {
            throw new IllegalStateException("Mesh destroyed");
        }
        if (animationShaderInstance == null) {
            return;
        }
        for (int i = 0; i < 12; ++i) {
            int j = RenderSystem.getShaderTexture((int)i);
            animationShaderInstance._setSampler("Sampler" + i, j);
        }
        if (animationShaderInstance.getModelViewMatrixUniform() != null) {
            animationShaderInstance.getModelViewMatrixUniform().m_5679_(poseStack.m_85850_().m_252922_());
        }
        if (animationShaderInstance.getProjectionMatrixUniform() != null) {
            animationShaderInstance.getProjectionMatrixUniform().m_5679_(RenderSystem.getProjectionMatrix());
        }
        if (animationShaderInstance.getNormalMatrixUniform() != null) {
            animationShaderInstance.getNormalMatrixUniform().m_200759_(poseStack.m_85850_().m_252943_());
        }
        if (animationShaderInstance.getInverseViewRotationMatrixUniform() != null) {
            animationShaderInstance.getInverseViewRotationMatrixUniform().m_200759_(RenderSystem.getInverseViewRotationMatrix());
        }
        if (animationShaderInstance.getColorModulatorUniform() != null) {
            animationShaderInstance.getColorModulatorUniform().m_5941_(RenderSystem.getShaderColor());
        }
        if (animationShaderInstance.getGlintAlphaUniform() != null) {
            animationShaderInstance.getGlintAlphaUniform().m_5985_(RenderSystem.getShaderGlintAlpha());
        }
        if (animationShaderInstance.getFogStartUniform() != null) {
            animationShaderInstance.getFogStartUniform().m_5985_(RenderSystem.getShaderFogStart());
        }
        if (animationShaderInstance.getFogEndUniform() != null) {
            animationShaderInstance.getFogEndUniform().m_5985_(RenderSystem.getShaderFogEnd());
        }
        if (animationShaderInstance.getFogColorUniform() != null) {
            animationShaderInstance.getFogColorUniform().m_5941_(RenderSystem.getShaderFogColor());
        }
        if (animationShaderInstance.getFogShapeUniform() != null) {
            animationShaderInstance.getFogShapeUniform().m_142617_(RenderSystem.getShaderFogShape().m_202324_());
        }
        if (animationShaderInstance.getTextureMatrixUniform() != null) {
            animationShaderInstance.getTextureMatrixUniform().m_5679_(RenderSystem.getTextureMatrix());
        }
        if (animationShaderInstance.getGameTimeUniform() != null) {
            animationShaderInstance.getGameTimeUniform().m_5985_(RenderSystem.getShaderGameTime());
        }
        if (animationShaderInstance.getScreenSizeUniform() != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            animationShaderInstance.getScreenSizeUniform().m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        if (animationShaderInstance.getColorUniform() != null) {
            animationShaderInstance.getColorUniform().m_5805_(r, g, b, a);
        }
        if (animationShaderInstance.getOverlayUniform() != null) {
            animationShaderInstance.getOverlayUniform().m_142326_(overlay & 0xFFFF, overlay >> 16 & 0xFFFF);
        }
        if (animationShaderInstance.getLightUniform() != null) {
            animationShaderInstance.getLightUniform().m_142326_(packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
        }
        animationShaderInstance.setupShaderLights();
        int currentBoundVao = GlStateManager._getInteger((int)34229);
        int currentBoundVbo = GlStateManager._getInteger((int)34966);
        GlStateManager._glBindVertexArray((int)this.arrayObjectId);
        EpicFightVertexFormatElement.bindDrawing(this);
        for (SkinnedMeshPart part : this.parts.values()) {
            part.drawWithShader(animationShaderInstance, r, g, b, a, armature, poses);
        }
        EpicFightVertexFormatElement.unbindDrawing();
        GlStateManager._glBindVertexArray((int)currentBoundVao);
        GlStateManager._glBindBuffer((int)34962, (int)currentBoundVbo);
    }

    public int getMaxJointCount() {
        return this.maxJointCount;
    }

    public JsonObject toJsonObject() {
        int i;
        int k;
        int i2;
        JsonObject root = new JsonObject();
        JsonObject vertices = new JsonObject();
        float[] positions = (float[])this.positions.clone();
        float[] normals = (float[])this.normals.clone();
        for (i2 = 0; i2 < positions.length / 3; ++i2) {
            k = i2 * 3;
            Vec4f posVector = new Vec4f(positions[k], positions[k + 1], positions[k + 2], 1.0f);
            posVector.transform(JsonAssetLoader.MINECRAFT_TO_BLENDER_COORD);
            positions[k] = posVector.x;
            positions[k + 1] = posVector.y;
            positions[k + 2] = posVector.z;
        }
        for (i2 = 0; i2 < normals.length / 3; ++i2) {
            k = i2 * 3;
            Vec4f normVector = new Vec4f(normals[k], normals[k + 1], normals[k + 2], 1.0f);
            normVector.transform(JsonAssetLoader.MINECRAFT_TO_BLENDER_COORD);
            normals[k] = normVector.x;
            normals[k + 1] = normVector.y;
            normals[k + 2] = normVector.z;
        }
        IntArrayList affectingJointAndWeightIndices = new IntArrayList();
        for (i = 0; i < this.affectingJointCounts.length; ++i) {
            for (int j = 0; j < this.affectingJointCounts[j]; ++j) {
                affectingJointAndWeightIndices.add(this.affectingJointIndices[i][j]);
                affectingJointAndWeightIndices.add(this.affectingWeightIndices[i][j]);
            }
        }
        vertices.add("positions", (JsonElement)ParseUtil.farrayToJsonObject(positions, 3));
        vertices.add("uvs", (JsonElement)ParseUtil.farrayToJsonObject(this.uvs, 2));
        vertices.add("normals", (JsonElement)ParseUtil.farrayToJsonObject(normals, 3));
        vertices.add("vcounts", (JsonElement)ParseUtil.iarrayToJsonObject(this.affectingJointCounts, 1));
        vertices.add("weights", (JsonElement)ParseUtil.farrayToJsonObject(this.weights, 1));
        vertices.add("vindices", (JsonElement)ParseUtil.iarrayToJsonObject(affectingJointAndWeightIndices.toIntArray(), 1));
        if (!this.parts.isEmpty()) {
            JsonObject parts = new JsonObject();
            for (Map.Entry partEntry : this.parts.entrySet()) {
                IntArrayList indicesArray = new IntArrayList();
                for (VertexBuilder vertexIndicator : ((SkinnedMeshPart)partEntry.getValue()).getVertices()) {
                    indicesArray.add(vertexIndicator.position);
                    indicesArray.add(vertexIndicator.uv);
                    indicesArray.add(vertexIndicator.normal);
                }
                parts.add((String)partEntry.getKey(), (JsonElement)ParseUtil.iarrayToJsonObject(indicesArray.toIntArray(), 3));
            }
            vertices.add("parts", (JsonElement)parts);
        } else {
            i = 0;
            int[] indices = new int[this.vertexCount * 3];
            for (SkinnedMeshPart part : this.parts.values()) {
                for (VertexBuilder vertexIndicator : part.getVertices()) {
                    indices[i * 3] = vertexIndicator.position;
                    indices[i * 3 + 1] = vertexIndicator.uv;
                    indices[i * 3 + 2] = vertexIndicator.normal;
                    ++i;
                }
            }
            vertices.add("indices", (JsonElement)ParseUtil.iarrayToJsonObject(indices, 3));
        }
        root.add("vertices", (JsonElement)vertices);
        if (this.renderProperties != null) {
            JsonObject renderProperties = new JsonObject();
            renderProperties.addProperty("texture_path", this.renderProperties.customTexturePath().toString());
            renderProperties.addProperty("transparent", Boolean.valueOf(this.renderProperties.isTransparent()));
            root.add("render_properties", (JsonElement)renderProperties);
        }
        return root;
    }

    @OnlyIn(value=Dist.CLIENT)
    private class VertexBuffer<T extends Number> {
        private int vertexBufferIds = GlStateManager._glGenBuffers();
        private final int glType;
        private final int size;
        private final boolean normalize;
        private final BiConsumer<ByteBuffer, T> bufferUploader;

        public VertexBuffer(int glType, int size, boolean normalize, BiConsumer<ByteBuffer, T> bufferUploader) {
            this.glType = glType;
            this.size = size;
            this.normalize = normalize;
            this.bufferUploader = bufferUploader;
        }

        public void bindVertexData(List<T> data) {
            if (this.vertexBufferIds < 0) {
                throw new RuntimeException("vertex buffer is already destroyed");
            }
            ByteBuffer buf = ByteBuffer.allocateDirect(data.size() * 4).order(ByteOrder.nativeOrder());
            for (Number f : data) {
                this.bufferUploader.accept(buf, (ByteBuffer)((Object)f));
            }
            buf.flip();
            GlStateManager._glBindBuffer((int)34962, (int)this.vertexBufferIds);
            GlStateManager._glBufferData((int)34962, (ByteBuffer)buf, (int)35044);
            GlStateManager._glBindBuffer((int)34962, (int)0);
        }

        public void vertexAttribPointer(int attrIndex) {
            if (this.vertexBufferIds < 0) {
                throw new RuntimeException("vertex buffer is already destroyed");
            }
            GlStateManager._glBindBuffer((int)34962, (int)this.vertexBufferIds);
            switch (this.glType) {
                case 5126: 
                case 5130: {
                    GlStateManager._vertexAttribPointer((int)attrIndex, (int)this.size, (int)this.glType, (boolean)this.normalize, (int)0, (long)0L);
                    break;
                }
                case 5120: 
                case 5122: 
                case 5124: {
                    if (this.normalize) {
                        GlStateManager._vertexAttribPointer((int)attrIndex, (int)this.size, (int)this.glType, (boolean)true, (int)0, (long)0L);
                        break;
                    }
                    GlStateManager._vertexAttribIPointer((int)attrIndex, (int)this.size, (int)this.glType, (int)0, (long)0L);
                }
            }
        }

        public void destroy() {
            RenderSystem.glDeleteBuffers((int)this.vertexBufferIds);
            this.vertexBufferIds = -1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class SkinnedMeshPart
    extends MeshPart {
        private int indexBufferId;

        public SkinnedMeshPart(@Nullable List<VertexBuilder> animatedMeshPartList, @Nullable Mesh.RenderProperties renderProperties, Supplier<OpenMatrix4f> vanillaPartTracer) {
            super(animatedMeshPartList, renderProperties, vanillaPartTracer);
        }

        private void createVbo(Map<VertexBuilder, Integer> vertexBuilderMap, float[] positions, float[] uvs, float[] normals, float[] weights, int[] affectingJointCounts, int[][] affectingJointIndices, int[][] affectingWeightsIndices, List<Float> position, List<Float> uv, List<Byte> normal, List<Short> joint, List<Float> weight) {
            ByteBuffer indicesBuffer = ByteBuffer.allocateDirect(this.getVertices().size() * 4).order(ByteOrder.nativeOrder());
            for (VertexBuilder vb : this.getVertices()) {
                if (vertexBuilderMap.containsKey(vb)) {
                    indicesBuffer.putInt(vertexBuilderMap.get(vb));
                    continue;
                }
                int next = vertexBuilderMap.size();
                indicesBuffer.putInt(next);
                vertexBuilderMap.put(vb, next);
                position.add(Float.valueOf(positions[vb.position * 3]));
                position.add(Float.valueOf(positions[vb.position * 3 + 1]));
                position.add(Float.valueOf(positions[vb.position * 3 + 2]));
                uv.add(Float.valueOf(uvs[vb.uv * 2]));
                uv.add(Float.valueOf(uvs[vb.uv * 2 + 1]));
                normal.add(SkinnedMeshPart.packNormal(normals[vb.normal * 3]));
                normal.add(SkinnedMeshPart.packNormal(normals[vb.normal * 3 + 1]));
                normal.add(SkinnedMeshPart.packNormal(normals[vb.normal * 3 + 2]));
                joint.add(affectingJointCounts[vb.position] > 0 ? (short)affectingJointIndices[vb.position][0] : (short)-1);
                joint.add(affectingJointCounts[vb.position] > 1 ? (short)affectingJointIndices[vb.position][1] : (short)-1);
                joint.add(affectingJointCounts[vb.position] > 2 ? (short)affectingJointIndices[vb.position][2] : (short)-1);
                weight.add(Float.valueOf(affectingJointCounts[vb.position] > 0 ? weights[affectingWeightsIndices[vb.position][0]] : 0.0f));
                weight.add(Float.valueOf(affectingJointCounts[vb.position] > 1 ? weights[affectingWeightsIndices[vb.position][1]] : 0.0f));
                weight.add(Float.valueOf(affectingJointCounts[vb.position] > 2 ? weights[affectingWeightsIndices[vb.position][2]] : 0.0f));
            }
            indicesBuffer.flip();
            this.indexBufferId = GlStateManager._glGenBuffers();
            GlStateManager._glBindBuffer((int)34963, (int)this.indexBufferId);
            GlStateManager._glBufferData((int)34963, (ByteBuffer)indicesBuffer, (int)35044);
            GlStateManager._glBindBuffer((int)34963, (int)0);
        }

        @Override
        public void draw(PoseStack poseStack, VertexConsumer bufferBuilder, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a, int overlay) {
            if (this.isHidden()) {
                return;
            }
            Vector4f color = this.getColor(r, g, b, a);
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
            for (VertexBuilder vi : this.getVertices()) {
                SkinnedMesh.this.getVertexPosition(vi.position, POSITION);
                SkinnedMesh.this.getVertexNormal(vi.normal, NORMAL);
                POSITION.mul((Matrix4fc)matrix4f);
                NORMAL.mul((Matrix3fc)matrix3f);
                drawingFunction.draw(bufferBuilder, POSITION.x(), POSITION.y(), POSITION.z(), NORMAL.x(), NORMAL.y(), NORMAL.z(), packedLight, color.x, color.y, color.z, color.w, SkinnedMesh.this.uvs[vi.uv * 2], SkinnedMesh.this.uvs[vi.uv * 2 + 1], overlay);
            }
        }

        public void drawWithShader(AnimationShaderInstance animationShaderInstance, float r, float g, float b, float a, Armature armature, OpenMatrix4f[] poses) {
            boolean hasCustomColor;
            int i;
            if (this.isHidden()) {
                return;
            }
            OpenMatrix4f transform = this.getVanillaPartTransform();
            for (i = 0; i < poses.length; ++i) {
                FINAL_POSES[i].load(poses[i]);
                if (armature != null) {
                    FINAL_POSES[i].mulBack(armature.searchJointById(i).getToOrigin());
                }
                if (transform == null) continue;
                FINAL_POSES[i].mulBack(transform);
            }
            for (i = 0; i < poses.length; ++i) {
                if (animationShaderInstance.getPoses(i) == null) continue;
                animationShaderInstance.getPoses(i).m_5679_(OpenMatrix4f.exportToMojangMatrix(FINAL_POSES[i]));
            }
            boolean bl = hasCustomColor = this.renderProperties != null && this.renderProperties.customColor() != null;
            if (hasCustomColor) {
                animationShaderInstance.getColorUniform().m_5805_(this.renderProperties.customColor().x, this.renderProperties.customColor().y, this.renderProperties.customColor().z, 1.0f);
            }
            animationShaderInstance._getVertexFormat().m_166912_();
            animationShaderInstance._apply();
            GlStateManager._glBindBuffer((int)34963, (int)this.indexBufferId);
            RenderSystem.drawElements((int)VertexFormat.Mode.TRIANGLES.f_166946_, (int)this.getVertices().size(), (int)VertexFormat.IndexType.INT.f_166923_);
            GlStateManager._glBindBuffer((int)34963, (int)0);
            animationShaderInstance._clear();
            animationShaderInstance._getVertexFormat().m_86024_();
            if (hasCustomColor) {
                animationShaderInstance.getColorUniform().m_5805_(r, g, b, a);
            }
        }

        static byte packNormal(float f) {
            return (byte)((int)(Mth.m_14036_((float)f, (float)-1.0f, (float)1.0f) * 127.0f) & 0xFF);
        }
    }
}

