/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.exception.AnimationInvokeException;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.gui.datapack.screen.DatapackEditScreen;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.main.EpicFightSharedConstants;

public class InstantiateInvoker {
    private static final BiMap<String, Class<?>> PRIMITIVE_KEYWORDS = HashBiMap.create();
    private static final BiMap<Class<?>, Class<?>> RETURN_TYPE_MAPPER = HashBiMap.create();
    private static final Map<Class<?>, Function<String, Object>> STRING_TO_OBJECT_PARSER = Maps.newHashMap();

    private static AssetAccessor<? extends Armature> getArmature(String id) {
        if (EpicFightSharedConstants.isPhysicalClient()) {
            return DatapackEditScreen.getCurrentScreen() != null ? DatapackEditScreen.getArmature(id) : Armatures.getOrCreate(ResourceLocation.parse((String)id), Armature::new);
        }
        return Armatures.getOrCreate(ResourceLocation.parse((String)id), Armature::new);
    }

    public static void registerPrimitive(String keyword, Class<?> clz, Function<String, Object> decoder) {
        PRIMITIVE_KEYWORDS.put((Object)keyword, clz);
        STRING_TO_OBJECT_PARSER.put(clz, decoder);
    }

    public static void registerReturnTypeMapper(Class<?> clz, Class<?> returnClz) {
        RETURN_TYPE_MAPPER.put(clz, returnClz);
    }

    public static void registerKeyword(Class<?> clz, Function<String, Object> decoder) {
        STRING_TO_OBJECT_PARSER.put(clz, decoder);
    }

    public static <T> Result<T> invoke(String invocationCommand, @Nullable Class<T> hint) throws Exception {
        if (invocationCommand.matches("\\(.+\\)") || invocationCommand.matches("\\(.+\\)\\#.+")) {
            return InstantiateInvoker.invokeInstance(invocationCommand, hint);
        }
        if (invocationCommand.matches("\\[.+\\]") || invocationCommand.matches("\\[.+\\]\\#.+")) {
            return InstantiateInvoker.invokeArray(invocationCommand, hint);
        }
        String[] param = InstantiateInvoker.splitExceptWrapper(invocationCommand, '#', true);
        String sValue = param[0];
        String sType = param[1];
        if (PRIMITIVE_KEYWORDS.containsKey((Object)sType)) {
            Class type = (Class)PRIMITIVE_KEYWORDS.get((Object)sType);
            return Result.of(type, STRING_TO_OBJECT_PARSER.get(type).apply(sValue));
        }
        Class<?> type = Class.forName(sType);
        if (STRING_TO_OBJECT_PARSER.containsKey(type)) {
            if (RETURN_TYPE_MAPPER.containsKey(type)) {
                return Result.of((Class)RETURN_TYPE_MAPPER.get(type), STRING_TO_OBJECT_PARSER.get(type).apply(sValue));
            }
            return Result.of(type, STRING_TO_OBJECT_PARSER.get(type).apply(sValue));
        }
        throw new AnimationInvokeException("Can't find the matching type for the command " + invocationCommand);
    }

    public static <T> Result<T> invokeInstance(String invocationCommand, @Nullable Class<?> hint) throws Exception {
        Class<?> type;
        if (!invocationCommand.matches("\\(.+\\)") && !invocationCommand.matches("\\(.+\\)\\#.+")) {
            throw new IllegalStateException("Invalid instantiate invocation command: " + invocationCommand);
        }
        String[] param$type = InstantiateInvoker.splitExceptWrapper(invocationCommand, '#', true);
        String sParams = param$type[0];
        Class<?> clazz = type = param$type.length > 1 ? Class.forName(param$type[1]) : hint;
        if (type == null) {
            throw new AnimationInvokeException("Can't find the type in command " + invocationCommand);
        }
        String[] params = InstantiateInvoker.splitExceptWrapper(sParams, ',', false);
        Object[] oArgs = new Object[params.length];
        Class[] oArgClss = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Result<T> result = InstantiateInvoker.invoke(params[i], null);
            oArgs[i] = result.result;
            oArgClss[i] = result.type;
            for (Class clazz2 : STRING_TO_OBJECT_PARSER.keySet()) {
                if (result.type.equals(clazz2) || !clazz2.isAssignableFrom(result.type)) continue;
                oArgClss[i] = clazz2;
            }
        }
        Constructor<?> constructor = null;
        try {
            if (hint == null) {
                throw new NoSuchMethodException();
            }
            constructor = hint.getConstructor(oArgClss);
        }
        catch (NoSuchMethodException e) {
            constructor = type.getConstructor(oArgClss);
        }
        return Result.of(type, constructor.newInstance(oArgs));
    }

    public static <T> Result<T[]> invokeArray(String invocationCommand, @Nullable Class<?> hint) throws Exception {
        Class<?> type;
        if (!invocationCommand.matches("\\[.+\\]") && !invocationCommand.matches("\\[.+\\]\\#.+")) {
            throw new AnimationInvokeException("Invalid array invocation command: " + invocationCommand);
        }
        String[] param$type = InstantiateInvoker.splitExceptWrapper(invocationCommand, '#', true);
        String sParams = param$type[0];
        Class<?> clazz = type = param$type.length > 1 ? Class.forName(param$type[1]) : hint;
        if (type == null) {
            throw new AnimationInvokeException("Can't find the type in command " + invocationCommand);
        }
        String[] params = InstantiateInvoker.splitExceptWrapper(sParams, ',', false);
        ArrayList resultArray = Lists.newArrayList();
        Object[] result = (Object[])Array.newInstance(type, params.length);
        for (int i = 0; i < params.length; ++i) {
            Object obj = InstantiateInvoker.invoke((String)params[i], type).result;
            if (obj.getClass() != type) {
                throw new AnimationInvokeException("Heterogeneous array elements for the command " + invocationCommand);
            }
            resultArray.add(obj);
            result[i] = obj;
        }
        return Result.of(type.arrayType(), resultArray.toArray(result));
    }

    private static String[] splitExceptWrapper(String sArgs, char keyword, boolean skipWrapper) {
        ArrayList sArgsList = Lists.newArrayList();
        int arrayNestCounter = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sArgs.length(); ++i) {
            char c = sArgs.charAt(i);
            if (c == keyword) {
                if (arrayNestCounter < 1) {
                    sArgsList.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '[' || c == '(') {
                if (!skipWrapper || arrayNestCounter > 0) {
                    sb.append(c);
                }
                ++arrayNestCounter;
                continue;
            }
            if (c == ']' || c == ')') {
                if (skipWrapper && --arrayNestCounter <= 0) continue;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (!sb.isEmpty()) {
            sArgsList.add(sb.toString());
        }
        return sArgsList.toArray(new String[0]);
    }

    static {
        InstantiateInvoker.registerPrimitive("B", Byte.TYPE, Byte::parseByte);
        InstantiateInvoker.registerPrimitive("C", Character.TYPE, s -> Character.valueOf(s.charAt(0)));
        InstantiateInvoker.registerPrimitive("D", Double.TYPE, Double::parseDouble);
        InstantiateInvoker.registerPrimitive("F", Float.TYPE, Float::parseFloat);
        InstantiateInvoker.registerPrimitive("I", Integer.TYPE, Integer::parseInt);
        InstantiateInvoker.registerPrimitive("J", Long.TYPE, Long::parseLong);
        InstantiateInvoker.registerPrimitive("S", Short.TYPE, Short::parseShort);
        InstantiateInvoker.registerPrimitive("Z", Boolean.TYPE, Boolean::parseBoolean);
        InstantiateInvoker.registerReturnTypeMapper(Armature.class, AssetAccessor.class);
        InstantiateInvoker.registerKeyword(String.class, s -> s);
        InstantiateInvoker.registerKeyword(Collider.class, s -> ColliderPreset.get(ResourceLocation.parse((String)s)));
        InstantiateInvoker.registerKeyword(Joint.class, s -> {
            String[] armature$joint = s.split("\\.");
            AssetAccessor<? extends Armature> armature = InstantiateInvoker.getArmature(armature$joint[0]);
            return armature.get().searchJointByName(armature$joint[1]);
        });
        InstantiateInvoker.registerKeyword(Armature.class, s -> InstantiateInvoker.getArmature(s));
        InstantiateInvoker.registerKeyword(InteractionHand.class, InteractionHand::valueOf);
    }

    public static class Result<T> {
        final Class<T> type;
        final T result;

        Result(Class<T> type, T result) {
            this.type = type;
            this.result = result;
        }

        public static <T> Result<T> of(Class<T> type, T value) {
            return new Result<T>(type, value);
        }

        public Class<T> getType() {
            return this.type;
        }

        public T getResult() {
            return this.result;
        }
    }
}

