/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.utils.math.Vec3f;

public interface PacketBufferCodec<T> {
    public static final PacketBufferCodec<Boolean> BOOLEAN = new PacketBufferCodec<Boolean>(){

        @Override
        public void encode(Boolean obj, FriendlyByteBuf buffer) {
            buffer.writeBoolean(obj.booleanValue());
        }

        @Override
        public Boolean decode(FriendlyByteBuf buffer) {
            return buffer.readBoolean();
        }
    };
    public static final PacketBufferCodec<Integer> INTEGER = new PacketBufferCodec<Integer>(){

        @Override
        public void encode(Integer obj, FriendlyByteBuf buffer) {
            buffer.writeInt(obj.intValue());
        }

        @Override
        public Integer decode(FriendlyByteBuf buffer) {
            return buffer.readInt();
        }
    };
    public static final PacketBufferCodec<Float> FLOAT = new PacketBufferCodec<Float>(){

        @Override
        public void encode(Float obj, FriendlyByteBuf buffer) {
            buffer.writeFloat(obj.floatValue());
        }

        @Override
        public Float decode(FriendlyByteBuf buffer) {
            return Float.valueOf(buffer.readFloat());
        }
    };
    public static final PacketBufferCodec<Double> DOUBLE = new PacketBufferCodec<Double>(){

        @Override
        public void encode(Double obj, FriendlyByteBuf buffer) {
            buffer.writeDouble(obj.doubleValue());
        }

        @Override
        public Double decode(FriendlyByteBuf buffer) {
            return buffer.readDouble();
        }
    };
    public static final PacketBufferCodec<Vec3> VEC3 = new PacketBufferCodec<Vec3>(){

        @Override
        public void encode(Vec3 obj, FriendlyByteBuf buffer) {
            buffer.writeDouble(obj.f_82479_);
            buffer.writeDouble(obj.f_82480_);
            buffer.writeDouble(obj.f_82481_);
        }

        @Override
        public Vec3 decode(FriendlyByteBuf buffer) {
            return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    };
    public static final PacketBufferCodec<Vec3f> VEC3F = new PacketBufferCodec<Vec3f>(){

        @Override
        public void encode(Vec3f obj, FriendlyByteBuf buffer) {
            buffer.writeFloat(obj.x);
            buffer.writeFloat(obj.y);
            buffer.writeFloat(obj.z);
        }

        @Override
        public Vec3f decode(FriendlyByteBuf buffer) {
            return new Vec3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };

    public void encode(T var1, FriendlyByteBuf var2);

    public T decode(FriendlyByteBuf var1);
}

