/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils.math;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4i;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;

public class MathUtils {
    public static final Vec3 XP = new Vec3(1.0, 0.0, 0.0);
    public static final Vec3 XN = new Vec3(-1.0, 0.0, 0.0);
    public static final Vec3 YP = new Vec3(0.0, 1.0, 0.0);
    public static final Vec3 YN = new Vec3(0.0, -1.0, 0.0);
    public static final Vec3 ZP = new Vec3(0.0, 0.0, 1.0);
    public static final Vec3 ZN = new Vec3(0.0, 0.0, -1.0);
    private static final Matrix4f BUFFER = new Matrix4f();
    private static final OpenMatrix4f OPEN_MATRIX_BUFFER = new OpenMatrix4f();

    public static OpenMatrix4f getModelMatrixIntegral(float xPosO, float xPos, float yPosO, float yPos, float zPosO, float zPos, float xRotO, float xRot, float yRotO, float yRot, float partialTick, float scaleX, float scaleY, float scaleZ) {
        OpenMatrix4f modelMatrix = new OpenMatrix4f();
        Vec3f translation = new Vec3f(-(xPosO + (xPos - xPosO) * partialTick), yPosO + (yPos - yPosO) * partialTick, -(zPosO + (zPos - zPosO) * partialTick));
        float partialXRot = Mth.m_14189_((float)partialTick, (float)xRotO, (float)xRot);
        float partialYRot = Mth.m_14189_((float)partialTick, (float)yRotO, (float)yRot);
        modelMatrix.translate(translation).rotateDeg(-partialYRot, Vec3f.Y_AXIS).rotateDeg(-partialXRot, Vec3f.X_AXIS).scale(scaleX, scaleY, scaleZ);
        return modelMatrix;
    }

    public static double bezierCurve(double t) {
        double p1 = 0.0;
        double p2 = 0.0;
        double p3 = 1.0;
        double p4 = 1.0;
        double v1 = p1;
        double v2 = 3.0 * (p2 - p1);
        double v3 = 3.0 * (p1 - 2.0 * p2 + p3);
        double v4 = p4 - p1 + 3.0 * (p2 - p3);
        return v1 + t * v2 + t * t * v3 + t * t * t * v4;
    }

    public static float bezierCurve(float t) {
        return (float)MathUtils.bezierCurve((double)t);
    }

    public static int getSign(double value) {
        return value > 0.0 ? 1 : -1;
    }

    public static Vec3 getVectorForRotation(float pitch, float yaw) {
        float f = pitch * (float)Math.PI / 180.0f;
        float f1 = -yaw * (float)Math.PI / 180.0f;
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static float lerpBetween(float f1, float f2, float zero2one) {
        float f = 0.0f;
        for (f = f2 - f1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return f1 + zero2one * f;
    }

    public static float rotlerp(float from, float to, float limit) {
        float f1;
        float f = Mth.m_14177_((float)(to - from));
        if (f > limit) {
            f = limit;
        }
        if (f < -limit) {
            f = -limit;
        }
        for (f1 = from + f; f1 >= 180.0f; f1 -= 360.0f) {
        }
        while (f1 <= -180.0f) {
            f1 += 360.0f;
        }
        return f1;
    }

    public static float rotWrap(double d) {
        while (d >= 180.0) {
            d -= 360.0;
        }
        while (d < -180.0) {
            d += 360.0;
        }
        return (float)d;
    }

    public static float wrapRadian(float pValue) {
        float maxRot = (float)Math.PI * 2;
        float f = pValue % maxRot;
        if ((double)f >= Math.PI) {
            f -= maxRot;
        }
        if ((double)f < -Math.PI) {
            f += maxRot;
        }
        return f;
    }

    public static float lerpDegree(float from, float to, float progression) {
        if (org.joml.Math.abs((float)((from = Mth.m_14177_((float)from)) - (to = Mth.m_14177_((float)to)))) > 180.0f) {
            if (to < 0.0f) {
                from -= 360.0f;
            } else if (to > 0.0f) {
                from += 360.0f;
            }
        }
        return Mth.m_14179_((float)progression, (float)from, (float)to);
    }

    public static Vec3 getNearestVector(Vec3 from, Vec3 ... vectors) {
        double minLength = 1000000.0;
        int index = 0;
        for (int i = 0; i < vectors.length; ++i) {
            double distSqr;
            if (vectors[i] == null || !((distSqr = from.m_82557_(vectors[i])) < minLength)) continue;
            minLength = distSqr;
            index = i;
        }
        return vectors[index];
    }

    public static Vec3 getNearestVector(Vec3 from, List<Vec3> vectors) {
        return MathUtils.getNearestVector(from, vectors.toArray(new Vec3[0]));
    }

    public static float greatest(float ... dList) {
        float max = -1000000.0f;
        for (float d : dList) {
            if (!(max < d)) continue;
            max = d;
        }
        return max;
    }

    public static float least(float ... dList) {
        float min = 1000000.0f;
        for (float d : dList) {
            if (!(min > d)) continue;
            min = d;
        }
        return min;
    }

    public static double greatest(double ... dList) {
        double max = -1000000.0;
        for (double d : dList) {
            if (!(max < d)) continue;
            max = d;
        }
        return max;
    }

    public static double least(double ... dList) {
        double min = 1000000.0;
        for (double d : dList) {
            if (!(min > d)) continue;
            min = d;
        }
        return min;
    }

    @Deprecated(forRemoval=true)
    public static void translateStack(PoseStack poseStack, OpenMatrix4f mat) {
        poseStack.m_252880_(mat.m30, mat.m31, mat.m32);
    }

    @Deprecated(forRemoval=true)
    public static void rotateStack(PoseStack poseStack, OpenMatrix4f mat) {
        OpenMatrix4f.transpose(mat, OPEN_MATRIX_BUFFER);
        poseStack.m_252781_(MathUtils.getQuaternionFromMatrix(OPEN_MATRIX_BUFFER));
    }

    @Deprecated(forRemoval=true)
    public static void scaleStack(PoseStack poseStack, OpenMatrix4f mat) {
        OpenMatrix4f.transpose(mat, OPEN_MATRIX_BUFFER);
        Vector3f vector = MathUtils.getScaleVectorFromMatrix(OPEN_MATRIX_BUFFER);
        poseStack.m_85841_(vector.x(), vector.y(), vector.z());
    }

    public static void mulStack(PoseStack poseStack, OpenMatrix4f mat) {
        OpenMatrix4f.exportToMojangMatrix(mat, BUFFER);
        poseStack.m_252931_(BUFFER);
    }

    public static double getAngleBetween(Vec3f a, Vec3f b) {
        double cos = a.x * b.x + a.y * b.y + a.z * b.z;
        return org.joml.Math.acos((double)cos);
    }

    public static double getAngleBetween(Vec3 a, Vec3 b) {
        double cos = a.f_82479_ * b.f_82479_ + a.f_82480_ * b.f_82480_ + a.f_82481_ * b.f_82481_;
        return org.joml.Math.acos((double)cos);
    }

    public static float getAngleBetween(Quaternionf a, Quaternionf b) {
        float dot = a.w * b.w + a.x * b.x + a.y * b.y + a.z * b.z;
        return 2.0f * (org.joml.Math.safeAcos((float)((float)MathUtils.getSign(dot) * b.w)) - org.joml.Math.safeAcos((float)a.w));
    }

    public static double getXRotOfVector(Vec3 vec) {
        Vec3 normalized = vec.m_82541_();
        return -(org.joml.Math.atan2((double)normalized.f_82480_, (double)((float)org.joml.Math.sqrt((double)(normalized.f_82479_ * normalized.f_82479_ + normalized.f_82481_ * normalized.f_82481_)))) * 57.29577951308232);
    }

    public static double getYRotOfVector(Vec3 vec) {
        Vec3 normalized = vec.m_82541_();
        return org.joml.Math.atan2((double)normalized.f_82481_, (double)normalized.f_82479_) * 57.29577951308232 - 90.0;
    }

    private static Quaternionf getQuaternionFromMatrix(OpenMatrix4f mat) {
        Quaternionf quat = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        quat.setFromUnnormalized((Matrix4fc)OpenMatrix4f.exportToMojangMatrix(mat.transpose(null)));
        return quat;
    }

    public static Vec3f lerpVector(Vec3f start, Vec3f end, float delta) {
        return MathUtils.lerpVector(start, end, delta, new Vec3f());
    }

    public static Vec3f lerpVector(Vec3f start, Vec3f end, float delta, Vec3f dest) {
        if (dest == null) {
            dest = new Vec3f();
        }
        dest.x = start.x + (end.x - start.x) * delta;
        dest.y = start.y + (end.y - start.y) * delta;
        dest.z = start.z + (end.z - start.z) * delta;
        return dest;
    }

    public static Vec3 lerpVector(Vec3 start, Vec3 end, float delta) {
        return new Vec3(start.f_82479_ + (end.f_82479_ - start.f_82479_) * (double)delta, start.f_82480_ + (end.f_82480_ - start.f_82480_) * (double)delta, start.f_82481_ + (end.f_82481_ - start.f_82481_) * (double)delta);
    }

    public static Vector3f lerpMojangVector(Vector3f start, Vector3f end, float delta) {
        float x = start.x() + (end.x() - start.x()) * delta;
        float y = start.y() + (end.y() - start.y()) * delta;
        float z = start.z() + (end.z() - start.z()) * delta;
        return new Vector3f(x, y, z);
    }

    public static Vec3 projectVector(Vec3 from, Vec3 to) {
        double dot = to.m_82526_(from);
        double normalScale = 1.0 / (to.f_82479_ * to.f_82479_ + to.f_82480_ * to.f_82480_ + to.f_82481_ * to.f_82481_);
        return new Vec3(dot * to.f_82479_ * normalScale, dot * to.f_82480_ * normalScale, dot * to.f_82481_ * normalScale);
    }

    public static Vec3f projectVector(Vec3f from, Vec3f to, Vec3f dest) {
        if (dest == null) {
            dest = new Vec3f();
        }
        float dot = Vec3f.dot(to, from);
        float normalScale = 1.0f / (to.x * to.x + to.y * to.y + to.z * to.z);
        dest.x = dot * to.x * normalScale;
        dest.y = dot * to.y * normalScale;
        dest.z = dot * to.z * normalScale;
        return dest;
    }

    public static void setQuaternion(Quaternionf quat, float x, float y, float z, float w) {
        quat.set(x, y, z, w);
    }

    public static Quaternionf mulQuaternion(Quaternionf left, Quaternionf right, Quaternionf dest) {
        if (dest == null) {
            dest = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        }
        float f = left.x();
        float f1 = left.y();
        float f2 = left.z();
        float f3 = left.w();
        float f4 = right.x();
        float f5 = right.y();
        float f6 = right.z();
        float f7 = right.w();
        float i = f3 * f4 + f * f7 + f1 * f6 - f2 * f5;
        float j = f3 * f5 - f * f6 + f1 * f7 + f2 * f4;
        float k = f3 * f6 + f * f5 - f1 * f4 + f2 * f7;
        float r = f3 * f7 - f * f4 - f1 * f5 - f2 * f6;
        dest.set(i, j, k, r);
        return dest;
    }

    public static Quaternionf lerpQuaternion(Quaternionf from, Quaternionf to, float delta) {
        return MathUtils.lerpQuaternion(from, to, delta, null);
    }

    public static Quaternionf lerpQuaternion(Quaternionf from, Quaternionf to, float delta, Quaternionf dest) {
        float resultZ;
        float resultY;
        float resultX;
        float resultW;
        if (dest == null) {
            dest = new Quaternionf();
        }
        float fromX = from.x();
        float fromY = from.y();
        float fromZ = from.z();
        float fromW = from.w();
        float toX = to.x();
        float toY = to.y();
        float toZ = to.z();
        float toW = to.w();
        float dot = fromW * toW + fromX * toX + fromY * toY + fromZ * toZ;
        float blendI = 1.0f - delta;
        if (dot < 0.0f) {
            resultW = blendI * fromW + delta * -toW;
            resultX = blendI * fromX + delta * -toX;
            resultY = blendI * fromY + delta * -toY;
            resultZ = blendI * fromZ + delta * -toZ;
        } else {
            resultW = blendI * fromW + delta * toW;
            resultX = blendI * fromX + delta * toX;
            resultY = blendI * fromY + delta * toY;
            resultZ = blendI * fromZ + delta * toZ;
        }
        dest.set(resultX, resultY, resultZ, resultW);
        dest.normalize();
        return dest;
    }

    private static Vector3f getScaleVectorFromMatrix(OpenMatrix4f mat) {
        Vec3f a = new Vec3f(mat.m00, mat.m10, mat.m20);
        Vec3f b = new Vec3f(mat.m01, mat.m11, mat.m21);
        Vec3f c = new Vec3f(mat.m02, mat.m12, mat.m22);
        return new Vector3f(a.length(), b.length(), c.length());
    }

    public static <T> Set<Set<T>> getSubset(Collection<T> collection) {
        HashSet<Set<T>> subsets = new HashSet<Set<T>>();
        ArrayList<T> asList = new ArrayList<T>(collection);
        MathUtils.createSubset(0, asList, new HashSet(), subsets);
        return subsets;
    }

    private static <T> void createSubset(int idx, List<T> elements, Set<T> parent, Set<Set<T>> subsets) {
        for (int i = idx; i < elements.size(); ++i) {
            HashSet<T> subset = new HashSet<T>(parent);
            subset.add(elements.get(i));
            subsets.add(subset);
            MathUtils.createSubset(i + 1, elements, subset, subsets);
        }
    }

    public static int getLeastAngleVectorIdx(Vec3f src, Vec3f ... candidates) {
        int leastVectorIdx = -1;
        int current = 0;
        float maxDot = -10000.0f;
        for (Vec3f normzlizedVec : Stream.of(candidates).map(vec -> vec.normalize()).collect(Collectors.toList())) {
            float dot = Vec3f.dot(src, normzlizedVec);
            if (maxDot < dot) {
                maxDot = dot;
                leastVectorIdx = current;
            }
            ++current;
        }
        return leastVectorIdx;
    }

    public static Vec3f getLeastAngleVector(Vec3f src, Vec3f ... candidates) {
        return candidates[MathUtils.getLeastAngleVectorIdx(src, candidates)];
    }

    public static int packColor(int r, int g, int b, int a) {
        int ir = r << 16;
        int ig = g << 8;
        int ib = b;
        int ia = a << 24;
        return ir | ig | ib | ia;
    }

    public static void unpackColor(int packedColor, Vector4i result) {
        int b = packedColor & 0xFF;
        int g = (packedColor & 0xFF00) >>> 8;
        int r = (packedColor & 0xFF0000) >>> 16;
        int a = (packedColor & 0xFF000000) >>> 24;
        result.x = r;
        result.y = g;
        result.z = b;
        result.w = a;
    }

    private MathUtils() {
    }
}

