/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@OnlyIn(value=Dist.CLIENT)
public class ClientEngine {
    private static ClientEngine instance = new ClientEngine();
    public Minecraft minecraft;
    public RenderEngine renderEngine;
    public ControllEngine controllEngine;
    private boolean vanillaModelDebuggingMode = false;

    public static ClientEngine getInstance() {
        return instance;
    }

    public ClientEngine() {
        instance = this;
        this.minecraft = Minecraft.m_91087_();
        this.renderEngine = new RenderEngine();
        this.controllEngine = new ControllEngine();
    }

    public boolean switchVanillaModelDebuggingMode() {
        this.vanillaModelDebuggingMode = !this.vanillaModelDebuggingMode;
        return this.vanillaModelDebuggingMode;
    }

    public boolean isVanillaModelDebuggingMode() {
        return this.vanillaModelDebuggingMode;
    }

    @Nullable
    public LocalPlayerPatch getPlayerPatch() {
        return EpicFightCapabilities.getEntityPatch((Entity)this.minecraft.f_91074_, LocalPlayerPatch.class);
    }

    public boolean isBattleMode() {
        LocalPlayerPatch localPlayerPatch = EpicFightCapabilities.getEntityPatch((Entity)this.minecraft.f_91074_, LocalPlayerPatch.class);
        if (localPlayerPatch == null) {
            return false;
        }
        return localPlayerPatch.isEpicFightMode();
    }
}

