/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.gui.screen.config.IngameConfigurationScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.ChargeableSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillExecuteEvent;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@OnlyIn(value=Dist.CLIENT)
public class ControllEngine {
    private final Set<Object> packets = Sets.newHashSet();
    private final Minecraft minecraft;
    private LocalPlayer player;
    private LocalPlayerPatch playerpatch;
    private int weaponInnatePressCounter = 0;
    private int sneakPressCounter = 0;
    private int moverPressCounter = 0;
    private int lastHotbarLockedTime;
    private boolean weaponInnatePressToggle = false;
    private boolean sneakPressToggle = false;
    private boolean moverPressToggle = false;
    private boolean attackLightPressToggle = false;
    private boolean hotbarLocked;
    private boolean chargeKeyUnpressed;
    private int reserveCounter;
    private KeyMapping reservedKey;
    private SkillSlot reservedOrChargingSkillSlot;
    private KeyMapping currentChargingKey;
    public Options options;

    public ControllEngine() {
        Events.controllEngine = this;
        this.minecraft = Minecraft.m_91087_();
        this.options = this.minecraft.f_91066_;
    }

    public void setPlayerPatch(LocalPlayerPatch playerpatch) {
        this.weaponInnatePressCounter = 0;
        this.weaponInnatePressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.attackLightPressToggle = false;
        this.player = (LocalPlayer)playerpatch.getOriginal();
        this.playerpatch = playerpatch;
    }

    public LocalPlayerPatch getPlayerPatch() {
        return this.playerpatch;
    }

    public boolean canPlayerMove(EntityState playerState) {
        return !playerState.movementLocked() || this.player.m_245714_() != null;
    }

    public boolean canPlayerRotate(EntityState playerState) {
        return !playerState.turningLocked() || this.player.m_245714_() != null;
    }

    public void handleEpicFightKeyMappings() {
        SkillContainer skill;
        if (this.playerpatch == null) {
            return;
        }
        if (ControllEngine.isKeyPressed(EpicFightKeyMappings.SKILL_EDIT, false) && this.playerpatch.getSkillCapability() != null) {
            Minecraft.m_91087_().m_91152_((Screen)new SkillEditScreen((Player)this.player, this.playerpatch.getSkillCapability()));
        }
        if (ControllEngine.isKeyPressed(EpicFightKeyMappings.OPEN_CONFIG_SCREEN, false)) {
            Minecraft.m_91087_().m_91152_((Screen)new IngameConfigurationScreen(null));
        }
        if (ControllEngine.isKeyPressed(EpicFightKeyMappings.SWITCH_VANILLA_MODEL_DEBUGGING, false)) {
            boolean flag = ClientEngine.getInstance().switchVanillaModelDebuggingMode();
            this.minecraft.f_91068_.m_90913_(flag ? "debug.vanilla_model_debugging.on" : "debug.vanilla_model_debugging.off", new Object[0]);
        }
        while (ControllEngine.isKeyPressed(EpicFightKeyMappings.ATTACK, true)) {
            if (!this.playerpatch.isEpicFightMode() || this.currentChargingKey == EpicFightKeyMappings.ATTACK) continue;
            boolean shouldPlayAttackAnimation = true;
            if (this.options.f_92096_.getKey() == EpicFightKeyMappings.ATTACK.getKey()) {
                Entity hitEntity;
                if (this.minecraft.f_91077_.m_6662_() == HitResult.Type.ENTITY && !((hitEntity = ((EntityHitResult)this.minecraft.f_91077_).m_82443_()) instanceof LivingEntity) && !(hitEntity instanceof PartEntity)) {
                    shouldPlayAttackAnimation = false;
                }
                if (shouldPlayAttackAnimation) {
                    if (this.playerpatch.isTargetLockedOn()) {
                        shouldPlayAttackAnimation = true;
                    } else if (ClientConfig.combatPreferredItems.contains(this.player.m_21205_().m_41720_())) {
                        if (this.playerpatch.getTarget() != null) {
                            shouldPlayAttackAnimation = true;
                        } else if (this.minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                            BlockPos bp = ((BlockHitResult)this.minecraft.f_91077_).m_82425_();
                            BlockState bs = this.minecraft.f_91073_.m_8055_(bp);
                            shouldPlayAttackAnimation = !this.player.m_21205_().m_41720_().m_6777_(bs, this.player.m_9236_(), bp, (Player)this.player) || !this.player.m_21205_().m_41735_(bs);
                        } else {
                            shouldPlayAttackAnimation = true;
                        }
                    } else {
                        shouldPlayAttackAnimation = this.minecraft.f_91077_.m_6662_() != HitResult.Type.BLOCK;
                    }
                }
                if (shouldPlayAttackAnimation) {
                    ControllEngine.makeUnpressed(this.options.f_92096_);
                }
            }
            if (!shouldPlayAttackAnimation) continue;
            if (!EpicFightKeyMappings.ATTACK.getKey().equals((Object)EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey())) {
                SkillSlots slot;
                SkillSlots skillSlots = slot = !this.player.m_20096_() && !this.player.m_20069_() && this.player.m_20184_().f_82480_ > 0.03 ? SkillSlots.AIR_ATTACK : SkillSlots.BASIC_ATTACK;
                if (this.playerpatch.getSkill(slot).sendExecuteRequest(this.playerpatch, this).isExecutable()) {
                    this.player.m_36334_();
                    this.attackLightPressToggle = false;
                    this.releaseAllServedKeys();
                } else if (!this.player.m_5833_() && slot == SkillSlots.BASIC_ATTACK) {
                    this.reserveKey(slot, EpicFightKeyMappings.ATTACK);
                }
                this.lockHotkeys();
                this.attackLightPressToggle = false;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
                continue;
            }
            if (this.weaponInnatePressToggle) continue;
            this.weaponInnatePressToggle = true;
        }
        while (ControllEngine.isKeyPressed(EpicFightKeyMappings.DODGE, true)) {
            if (!this.playerpatch.isEpicFightMode() || this.currentChargingKey == EpicFightKeyMappings.DODGE) continue;
            if (EpicFightKeyMappings.DODGE.getKey().m_84873_() == this.options.f_92090_.getKey().m_84873_()) {
                if (this.player.m_20202_() != null || this.sneakPressToggle) continue;
                this.sneakPressToggle = true;
                continue;
            }
            SkillSlots skillCategory = this.playerpatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
            skill = this.playerpatch.getSkill(skillCategory);
            if (!skill.sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) continue;
            this.reserveKey(SkillSlots.DODGE, EpicFightKeyMappings.DODGE);
        }
        while (ControllEngine.isKeyPressed(EpicFightKeyMappings.GUARD, true)) {
        }
        while (ControllEngine.isKeyPressed(EpicFightKeyMappings.WEAPON_INNATE_SKILL, true)) {
            if (!this.playerpatch.isEpicFightMode() || this.currentChargingKey == EpicFightKeyMappings.WEAPON_INNATE_SKILL || EpicFightKeyMappings.ATTACK.getKey().equals((Object)EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey())) continue;
            if (this.playerpatch.getSkill(SkillSlots.WEAPON_INNATE).sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) {
                if (this.player.m_5833_()) continue;
                this.reserveKey(SkillSlots.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
                continue;
            }
            this.lockHotkeys();
        }
        while (ControllEngine.isKeyPressed(EpicFightKeyMappings.MOVER_SKILL, true)) {
            if (!this.playerpatch.isEpicFightMode() || this.playerpatch.isChargingSkill()) continue;
            if (EpicFightKeyMappings.MOVER_SKILL.getKey().m_84873_() == this.options.f_92089_.getKey().m_84873_()) {
                SkillExecuteEvent event;
                SkillContainer skillContainer = this.playerpatch.getSkill(SkillSlots.MOVER);
                if (!skillContainer.canExecute(this.playerpatch, event = new SkillExecuteEvent(this.playerpatch, skillContainer)) || this.player.m_20202_() != null || this.moverPressToggle) continue;
                this.moverPressToggle = true;
                continue;
            }
            SkillContainer skill2 = this.playerpatch.getSkill(SkillSlots.MOVER);
            skill2.sendExecuteRequest(this.playerpatch, this);
        }
        while (ControllEngine.isKeyPressed(EpicFightKeyMappings.SWITCH_MODE, false)) {
            if (EpicFightGameRules.CAN_SWITCH_PLAYER_MODE.getRuleValue(((LocalPlayer)this.playerpatch.getOriginal()).m_9236_()).booleanValue()) {
                this.playerpatch.toggleMode();
                continue;
            }
            this.minecraft.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"epicfight.messages.mode_switching_disabled").m_130940_(ChatFormatting.RED));
        }
        while (ControllEngine.isKeyPressed(EpicFightKeyMappings.LOCK_ON, false)) {
            this.playerpatch.toggleLockOn();
        }
        if (this.playerpatch.getEntityState().inaction() || !this.playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).canBePlacedOffhand()) {
            ControllEngine.makeUnpressed(this.minecraft.f_91066_.f_92093_);
        }
        if (!this.playerpatch.isEpicFightMode() || Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (this.player.f_19797_ - this.lastHotbarLockedTime > 20 && this.hotbarLocked) {
            this.unlockHotkeys();
        }
        if (this.weaponInnatePressToggle) {
            if (!ControllEngine.isKeyDown(EpicFightKeyMappings.WEAPON_INNATE_SKILL)) {
                this.attackLightPressToggle = true;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey().equals((Object)EpicFightKeyMappings.ATTACK.getKey())) {
                if (this.weaponInnatePressCounter > ClientConfig.longPressCounter) {
                    if (this.playerpatch.getSkill(SkillSlots.WEAPON_INNATE).sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) {
                        if (!this.player.m_5833_()) {
                            this.reserveKey(SkillSlots.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
                        }
                    } else {
                        this.lockHotkeys();
                    }
                    this.weaponInnatePressToggle = false;
                    this.weaponInnatePressCounter = 0;
                } else {
                    ++this.weaponInnatePressCounter;
                }
            }
        }
        if (this.attackLightPressToggle) {
            SkillSlots slot;
            SkillSlots skillSlots = slot = !this.player.m_20096_() && !this.player.m_20069_() && this.player.m_20184_().f_82480_ > 0.03 ? SkillSlots.AIR_ATTACK : SkillSlots.BASIC_ATTACK;
            if (this.playerpatch.getSkill(slot).sendExecuteRequest(this.playerpatch, this).isExecutable()) {
                this.player.m_36334_();
                this.releaseAllServedKeys();
            } else if (!this.player.m_5833_() && slot == SkillSlots.BASIC_ATTACK) {
                this.reserveKey(slot, EpicFightKeyMappings.ATTACK);
            }
            this.lockHotkeys();
            this.attackLightPressToggle = false;
            this.weaponInnatePressToggle = false;
            this.weaponInnatePressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!ControllEngine.isKeyDown(this.options.f_92090_)) {
                SkillSlots skillSlot = this.playerpatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
                skill = this.playerpatch.getSkill(skillSlot);
                if (skill.sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) {
                    this.reserveKey(skillSlot, this.options.f_92090_);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > ClientConfig.longPressCounter) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.currentChargingKey != null) {
            SkillContainer skill3 = this.playerpatch.getSkill(this.reservedOrChargingSkillSlot);
            Skill skill4 = skill3.getSkill();
            if (skill4 instanceof ChargeableSkill) {
                ChargeableSkill chargingSkill = (ChargeableSkill)((Object)skill4);
                if (!ControllEngine.isKeyDown(this.currentChargingKey)) {
                    this.chargeKeyUnpressed = true;
                }
                if (this.chargeKeyUnpressed && this.playerpatch.getSkillChargingTicks() > chargingSkill.getMinChargingTicks()) {
                    if (skill3.getSkill() != null) {
                        skill3.sendExecuteRequest(this.playerpatch, this);
                    }
                    this.releaseAllServedKeys();
                }
                if (this.playerpatch.getSkillChargingTicks() >= chargingSkill.getAllowedMaxChargingTicks()) {
                    this.releaseAllServedKeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.reservedKey != null) {
            if (this.reserveCounter > 0) {
                SkillContainer skill5 = this.playerpatch.getSkill(this.reservedOrChargingSkillSlot);
                --this.reserveCounter;
                if (skill5.getSkill() != null && skill5.sendExecuteRequest(this.playerpatch, this).isExecutable()) {
                    this.releaseAllServedKeys();
                    this.lockHotkeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (!this.playerpatch.getEntityState().canSwitchHoldingItem() || this.hotbarLocked) {
            for (int i = 0; i < 9; ++i) {
                while (this.options.f_92056_[i].m_90859_()) {
                }
            }
            while (this.options.f_92094_.m_90859_()) {
            }
        }
    }

    private void inputTick(Input input) {
        if (this.moverPressToggle) {
            if (!ControllEngine.isKeyDown(this.options.f_92089_)) {
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
                if (this.player.m_20096_()) {
                    this.player.f_20954_ = 0;
                    input.f_108572_ = true;
                }
            } else if (this.moverPressCounter > ClientConfig.longPressCounter) {
                SkillContainer skill = this.playerpatch.getSkill(SkillSlots.MOVER);
                skill.sendExecuteRequest(this.playerpatch, this);
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
            } else {
                this.player.f_20954_ = 2;
                ++this.moverPressCounter;
            }
        }
        if (!this.canPlayerMove(this.playerpatch.getEntityState())) {
            input.f_108567_ = 0.0f;
            input.f_108566_ = 0.0f;
            input.f_108568_ = false;
            input.f_108569_ = false;
            input.f_108570_ = false;
            input.f_108571_ = false;
            input.f_108572_ = false;
            input.f_108573_ = false;
            this.player.f_108583_ = -1;
            this.player.m_6858_(false);
        }
        if (this.player.m_6084_()) {
            this.playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, new MovementInputEvent(this.playerpatch, input));
        }
    }

    private void reserveKey(SkillSlot slot, KeyMapping keyMapping) {
        this.reservedKey = keyMapping;
        this.reservedOrChargingSkillSlot = slot;
        this.reserveCounter = 8;
    }

    private void releaseAllServedKeys() {
        this.chargeKeyUnpressed = true;
        this.currentChargingKey = null;
        this.reservedOrChargingSkillSlot = null;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void setChargingKey(SkillSlot chargingSkillSlot, KeyMapping keyMapping) {
        this.chargeKeyUnpressed = false;
        this.currentChargingKey = keyMapping;
        this.reservedOrChargingSkillSlot = chargingSkillSlot;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void lockHotkeys() {
        this.hotbarLocked = true;
        this.lastHotbarLockedTime = this.player.f_19797_;
        for (int i = 0; i < 9; ++i) {
            while (this.options.f_92056_[i].m_90859_()) {
            }
        }
    }

    public void unlockHotkeys() {
        this.hotbarLocked = false;
    }

    public void addPacketToSend(Object packet) {
        this.packets.add(packet);
    }

    public static boolean isKeyDown(KeyMapping key) {
        if (key.getKey().m_84868_() == InputConstants.Type.KEYSYM) {
            return key.m_90857_() || GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        if (key.getKey().m_84868_() == InputConstants.Type.MOUSE) {
            return key.m_90857_() || GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        return false;
    }

    private static boolean isKeyPressed(KeyMapping key, boolean eventCheck) {
        int mouseButton;
        InputEvent.InteractionKeyMappingTriggered inputEvent;
        boolean consumes = key.m_90859_();
        if (consumes && eventCheck && (inputEvent = ForgeHooksClient.onClickInput((int)(mouseButton = InputConstants.Type.MOUSE == key.getKey().m_84868_() ? key.getKey().m_84873_() : -1), (KeyMapping)key, (InteractionHand)InteractionHand.MAIN_HAND)).isCanceled()) {
            return false;
        }
        return consumes;
    }

    public static void makeUnpressed(KeyMapping keyMapping) {
        while (keyMapping.m_90859_()) {
        }
        ControllEngine.setKeyBind(keyMapping, false);
    }

    public static void setKeyBind(KeyMapping key, boolean setter) {
        KeyMapping.m_90837_((InputConstants.Key)key.getKey(), (boolean)setter);
    }

    public boolean moverToggling() {
        return this.moverPressToggle;
    }

    public boolean sneakToggling() {
        return this.sneakPressToggle;
    }

    public boolean attackToggling() {
        return this.attackLightPressToggle;
    }

    public boolean weaponInnateToggling() {
        return this.weaponInnatePressToggle;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static ControllEngine controllEngine;

        @SubscribeEvent
        public static void mouseScrollEvent(InputEvent.MouseScrollingEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ != null && Events.controllEngine.playerpatch != null && !Events.controllEngine.playerpatch.getEntityState().canSwitchHoldingItem() && Events.controllEngine.minecraft.f_91080_ == null) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void moveInputEvent(MovementInputUpdateEvent event) {
            if (Events.controllEngine.playerpatch == null) {
                return;
            }
            controllEngine.inputTick(event.getInput());
        }

        @SubscribeEvent
        public static void clientTickEndEvent(TickEvent.ClientTickEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.END) {
                for (Object packet : Events.controllEngine.packets) {
                    EpicFightNetworkManager.sendToServer(packet);
                }
                Events.controllEngine.packets.clear();
            }
        }

        @SubscribeEvent
        public static void interactionEvent(InputEvent.InteractionKeyMappingTriggered event) {
            if (Events.controllEngine.minecraft.f_91074_ == null) {
                return;
            }
            if (event.getKeyMapping() == Events.controllEngine.minecraft.f_91066_.f_92096_ && EpicFightKeyMappings.ATTACK.getKey() == Events.controllEngine.minecraft.f_91066_.f_92096_.getKey() && Events.controllEngine.minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK && ClientConfig.combatPreferredItems.contains(Events.controllEngine.player.m_21205_().m_41720_())) {
                BlockPos bp = ((BlockHitResult)Events.controllEngine.minecraft.f_91077_).m_82425_();
                BlockState bs = Events.controllEngine.minecraft.f_91073_.m_8055_(bp);
                if (!Events.controllEngine.player.m_21205_().m_41720_().m_6777_(bs, Events.controllEngine.player.m_9236_(), bp, (Player)Events.controllEngine.player) || Events.controllEngine.player.m_21205_().m_41691_(bs) <= 1.0f) {
                    event.setSwingHand(false);
                    event.setCanceled(true);
                }
            }
        }
    }
}

