/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

@OnlyIn(value=Dist.CLIENT)
public class SkillEditScreen
extends Screen {
    private static final ResourceLocation SKILL_EDIT_UI = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/screen/skill_edit.png");
    private static final MutableComponent NO_SKILLS = Component.m_237115_((String)"gui.epicfight.no_skills");
    private static final int MAX_SHOWING_BUTTONS = 6;
    private final Player player;
    private final CapabilitySkill skills;
    private final Map<SkillSlot, SlotButton> slotButtons = Maps.newHashMap();
    private final List<LearnSkillButton> learnedSkillButtons = Lists.newArrayList();
    private int start;
    private SlotButton selectedSlotButton;

    public SkillEditScreen(Player player, CapabilitySkill skills) {
        super((Component)Component.m_237115_((String)"gui.epicfight.skill_edit"));
        this.player = player;
        this.skills = skills;
    }

    public void m_7856_() {
        int i = this.f_96543_ / 2 - 96;
        int j = this.f_96544_ / 2 - 82;
        this.slotButtons.clear();
        this.learnedSkillButtons.clear();
        for (SkillSlot skillSlot : SkillSlot.ENUM_MANAGER.universalValues()) {
            if (!this.player.m_7500_() && !this.skills.hasCategory(skillSlot.category()) || !skillSlot.category().learnable()) continue;
            SlotButton slotButton = new SlotButton(i, j, 18, 18, skillSlot, this.skills.skillContainers[skillSlot.universalOrdinal()].getSkill(), button -> {
                this.start = 0;
                for (Button button2 : this.learnedSkillButtons) {
                    this.m_6702_().remove(button2);
                }
                this.learnedSkillButtons.clear();
                int k = this.f_96543_ / 2 - 69;
                int n = this.f_96544_ / 2 - 78;
                Collection<Skill> learnedSkillCollection = this.player.m_7500_() ? SkillManager.getSkills(skill -> skill.getCategory() == skillSlot.category()) : this.skills.getLearnedSkills(skillSlot.category());
                for (Skill skill2 : learnedSkillCollection) {
                    void var4_7;
                    this.learnedSkillButtons.add(new LearnSkillButton(k, (int)var4_7, 147, 24, skill2, (Component)Component.m_237115_((String)skill2.getTranslationKey()), pressedButton -> {
                        if (this.f_96541_.f_91074_.f_36078_ >= learnedSkill.getRequiredXp() || this.f_96541_.f_91074_.m_7500_()) {
                            if (!this.canPress(pressedButton)) {
                                return;
                            }
                            this.skills.skillContainers[skillSlot.universalOrdinal()].setSkill(learnedSkill);
                            EpicFightNetworkManager.sendToServer(new CPChangeSkill(skillSlot.universalOrdinal(), -1, learnedSkill.toString(), !this.f_96541_.f_91074_.m_7500_()));
                            if (!this.skills.getLearnedSkills(skillSlot.category()).contains(learnedSkill)) {
                                this.skills.addLearnedSkill(learnedSkill);
                            }
                            this.m_7379_();
                        }
                    }).setActive(this.skills.getSkillContainer(skill2) == null));
                    var4_7 += 26;
                }
                for (Button button3 : this.learnedSkillButtons) {
                    this.m_7787_((GuiEventListener)button3);
                }
                this.selectedSlotButton = (SlotButton)button;
            }, (Component)Component.m_237115_((String)SkillSlot.ENUM_MANAGER.toTranslated(skillSlot)));
            this.slotButtons.put(skillSlot, slotButton);
            this.m_7787_((GuiEventListener)slotButton);
            j += 18;
        }
        if (this.selectedSlotButton != null) {
            this.selectedSlotButton = this.slotButtons.get(this.selectedSlotButton.slot);
            this.selectedSlotButton.m_5691_();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        if (this.canScroll()) {
            int scrollPosition = (int)(140.0f * ((float)this.start / (float)(this.learnedSkillButtons.size() - 6)));
            guiGraphics.m_280411_(SKILL_EDIT_UI, this.f_96543_ / 2 + 80, this.f_96544_ / 2 - 80 + scrollPosition, 12, 15, 231.0f, 2.0f, 12, 15, 256, 256);
        }
        int maxShowingButtons = Math.min(this.learnedSkillButtons.size(), 6);
        for (int i = this.start; i < maxShowingButtons + this.start; ++i) {
            this.learnedSkillButtons.get(i).m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        for (SlotButton sb : this.slotButtons.values()) {
            sb.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.slotButtons.isEmpty()) {
            int lineHeight = 0;
            for (FormattedCharSequence s : this.f_96547_.m_92923_((FormattedText)NO_SKILLS, 140)) {
                guiGraphics.m_280649_(this.f_96547_, s, this.f_96543_ / 2 - 65, this.f_96544_ / 2 - 72 + lineHeight, 0x303030, false);
                lineHeight += 10;
            }
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        guiGraphics.m_280218_(SKILL_EDIT_UI, this.f_96543_ / 2 - 104, this.f_96544_ / 2 - 100, 0, 0, 208, 200);
    }

    private boolean canScroll() {
        return this.learnedSkillButtons.size() > 6;
    }

    private boolean canPress(Button button) {
        int buttonOrder = this.learnedSkillButtons.indexOf(button);
        return buttonOrder >= this.start && buttonOrder <= this.start + 6;
    }

    public boolean m_6050_(double x, double y, double wheel) {
        if (!this.canScroll()) {
            return false;
        }
        if (wheel > 0.0) {
            if (this.start > 0) {
                --this.start;
                for (Button button : this.learnedSkillButtons) {
                    button.m_253211_(button.m_252907_() + 26);
                }
                return true;
            }
        } else if (this.start < this.learnedSkillButtons.size() - 6) {
            ++this.start;
            for (Button button : this.learnedSkillButtons) {
                button.m_253211_(button.m_252907_() - 26);
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    class SlotButton
    extends Button {
        private final Skill iconSkill;
        private final SkillSlot slot;

        public SlotButton(int x, int y, int width, int height, SkillSlot slot, Skill skill, Button.OnPress pressedAction, Component tooltipMessage) {
            super(x, y, width, height, (Component)Component.m_237119_(), pressedAction, Button.f_252438_);
            this.iconSkill = skill;
            this.slot = slot;
            this.m_257544_(Tooltip.m_257550_((Component)tooltipMessage));
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            int y = this.f_93622_ || SkillEditScreen.this.selectedSlotButton == this ? 35 : 17;
            guiGraphics.m_280218_(SKILL_EDIT_UI, this.m_252754_(), this.m_252907_(), 237, y, this.f_93618_, this.f_93619_);
            if (this.iconSkill != null) {
                RenderSystem.enableBlend();
                guiGraphics.m_280411_(this.iconSkill.getSkillTexture(), this.m_252754_() + 1, this.m_252907_() + 1, 16, 16, 0.0f, 0.0f, 128, 128, 128, 128);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class LearnSkillButton
    extends Button {
        private final Skill skill;

        public LearnSkillButton(int x, int y, int width, int height, Skill skill, Component title, Button.OnPress pressedAction) {
            super(x, y, width, height, title, pressedAction, Button.f_252438_);
            this.skill = skill;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            int texY = this.f_93622_ || !this.f_93623_ ? 224 : 200;
            guiGraphics.m_280218_(SKILL_EDIT_UI, this.m_252754_(), this.m_252907_(), 0, texY, this.f_93618_, this.f_93619_);
            RenderSystem.enableBlend();
            guiGraphics.m_280411_(this.skill.getSkillTexture(), this.m_252754_() + 5, this.m_252907_() + 4, 16, 16, 0.0f, 0.0f, 128, 128, 128, 128);
            guiGraphics.m_280614_(SkillEditScreen.this.f_96547_, this.m_6035_(), this.m_252754_() + 26, this.m_252907_() + 2, -1, false);
            if (this.f_93623_) {
                int color = ((SkillEditScreen)SkillEditScreen.this).f_96541_.f_91074_.f_36078_ >= this.skill.getRequiredXp() || ((SkillEditScreen)SkillEditScreen.this).f_96541_.f_91074_.m_7500_() ? 8453920 : 0xFF6060;
                guiGraphics.m_280614_(SkillEditScreen.this.f_96547_, (Component)Component.m_237110_((String)"gui.epicfight.changing_cost", (Object[])new Object[]{this.skill.getRequiredXp()}), this.m_252754_() + 70, this.m_252907_() + 12, color, false);
            } else {
                guiGraphics.m_280614_(SkillEditScreen.this.f_96547_, (Component)Component.m_237113_((String)SkillEditScreen.this.skills.getSkillContainer(this.skill).getSlot().toString().toLowerCase(Locale.ROOT)), this.m_252754_() + 26, this.m_252907_() + 12, 0xFF6060, false);
            }
        }

        public boolean m_6375_(double x, double y, int pressType) {
            boolean flag;
            if (this.f_93624_ && pressType == 1 && (flag = this.clickedNoCountActive(x, y))) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                SkillEditScreen.this.f_96541_.m_91152_((Screen)new SkillBookScreen(SkillEditScreen.this.player, this.skill, null, SkillEditScreen.this));
                return true;
            }
            return super.m_6375_(x, y, pressType);
        }

        protected boolean clickedNoCountActive(double x, double y) {
            return this.f_93624_ && x >= (double)this.m_252754_() && y >= (double)this.m_252907_() && x < (double)(this.m_252754_() + this.f_93618_) && y < (double)(this.m_252907_() + this.f_93619_);
        }

        public LearnSkillButton setActive(boolean active) {
            this.f_93623_ = active;
            return this;
        }
    }
}

