/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractTrailParticle<T extends EntityPatch<?>>
extends TextureSheetParticle {
    protected final TrailInfo trailInfo;
    protected final T owner;
    protected final List<TrailEdge> trailEdges;
    protected float startEdgeCorrection = 0.0f;
    protected Vec3 lastPos;
    protected boolean shouldRemove;

    protected AbstractTrailParticle(ClientLevel level, T entitypatch, TrailInfo trailInfo) {
        super(level, 0.0, 0.0, 0.0);
        this.f_107219_ = false;
        this.owner = entitypatch;
        this.trailEdges = Lists.newLinkedList();
        this.trailInfo = trailInfo;
        Vec3 entityPos = ((EntityPatch)entitypatch).getOriginal().m_20182_();
        this.m_6257_(entityPos.f_82479_, entityPos.f_82480_ + (double)((EntityPatch)entitypatch).getOriginal().m_20192_(), entityPos.f_82481_);
        float size = (float)Math.max(this.trailInfo.start().m_82553_(), this.trailInfo.end().m_82553_()) * 2.0f;
        this.m_107250_(size, size);
        this.f_107227_ = Math.max(this.trailInfo.rCol(), 0.0f);
        this.f_107228_ = Math.max(this.trailInfo.gCol(), 0.0f);
        this.f_107229_ = Math.max(this.trailInfo.bCol(), 0.0f);
        if (this.trailInfo.texturePath() != null) {
            TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
            AbstractTexture abstracttexture = texturemanager.m_118506_(this.trailInfo.texturePath());
            RenderSystem.bindTexture((int)abstracttexture.m_117963_());
            RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
            RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        }
    }

    protected abstract boolean canContinue();

    protected boolean canCreateNextCurve() {
        return this.f_107224_ % this.trailInfo.updateInterval() == 0 && !this.f_107220_;
    }

    protected abstract void createNextCurve();

    public void m_5989_() {
        if (this.shouldRemove) {
            if (this.f_107224_ >= this.f_107225_) {
                this.m_107274_();
            }
        } else if (!this.canContinue()) {
            this.shouldRemove = true;
            this.f_107225_ = this.f_107224_ + this.trailInfo.trailLifetime();
        }
        ++this.f_107224_;
        this.trailEdges.removeIf(v -> !v.isAlive());
        if (!this.canCreateNextCurve()) {
            return;
        }
        double xd = Math.pow(((EntityPatch)this.owner).getOriginal().m_20185_() - this.lastPos.f_82479_, 2.0);
        double yd = Math.pow(((EntityPatch)this.owner).getOriginal().m_20186_() - this.lastPos.f_82480_, 2.0);
        double zd = Math.pow(((EntityPatch)this.owner).getOriginal().m_20189_() - this.lastPos.f_82481_, 2.0);
        float move = (float)Math.sqrt(xd + yd + zd) * 2.0f;
        this.m_107250_(this.f_107221_ + move, this.f_107222_ + move);
        this.createNextCurve();
        this.lastPos = ((EntityPatch)this.owner).getOriginal().m_20318_(1.0f);
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        if (this.trailEdges.isEmpty()) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.trailInfo.texturePath());
        PoseStack poseStack = new PoseStack();
        int light = this.m_6355_(partialTick);
        this.setupPoseStack(poseStack, camera, partialTick);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        int edges = this.trailEdges.size() - 1;
        boolean startFade = this.trailEdges.get((int)0).lifetime == 1;
        boolean endFade = this.trailEdges.get((int)edges).lifetime == this.trailInfo.trailLifetime();
        float startEdge = (startFade ? (float)(this.trailInfo.interpolateCount() * 2) * partialTick : 0.0f) + this.startEdgeCorrection;
        float endEdge = endFade ? Math.min((float)edges - (float)(this.trailInfo.interpolateCount() * 2) * (1.0f - partialTick), (float)(edges - 1)) : (float)(edges - 1);
        float interval = 1.0f / (endEdge - startEdge);
        float fading = 1.0f;
        if (this.shouldRemove) {
            fading = TrailInfo.isValidTime(this.trailInfo.fadeTime()) ? (float)(this.f_107225_ - this.f_107224_) / (float)this.trailInfo.trailLifetime() : Mth.m_14036_((float)(((float)(this.f_107225_ - this.f_107224_) + (1.0f - partialTick)) / (float)this.trailInfo.trailLifetime()), (float)0.0f, (float)1.0f);
        }
        float partialStartEdge = interval * (startEdge % 1.0f);
        float from = -partialStartEdge;
        float to = -partialStartEdge + interval;
        for (int i = (int)startEdge; i < (int)endEdge + 1; ++i) {
            TrailEdge e1 = this.trailEdges.get(i);
            TrailEdge e2 = this.trailEdges.get(i + 1);
            Vector4f pos1 = new Vector4f((float)e1.start.f_82479_, (float)e1.start.f_82480_, (float)e1.start.f_82481_, 1.0f);
            Vector4f pos2 = new Vector4f((float)e1.end.f_82479_, (float)e1.end.f_82480_, (float)e1.end.f_82481_, 1.0f);
            Vector4f pos3 = new Vector4f((float)e2.end.f_82479_, (float)e2.end.f_82480_, (float)e2.end.f_82481_, 1.0f);
            Vector4f pos4 = new Vector4f((float)e2.start.f_82479_, (float)e2.start.f_82480_, (float)e2.start.f_82481_, 1.0f);
            pos1.mul((Matrix4fc)matrix4f);
            pos2.mul((Matrix4fc)matrix4f);
            pos3.mul((Matrix4fc)matrix4f);
            pos4.mul((Matrix4fc)matrix4f);
            float alphaFrom = Mth.m_14036_((float)from, (float)0.0f, (float)1.0f);
            float alphaTo = Mth.m_14036_((float)to, (float)0.0f, (float)1.0f);
            vertexConsumer.m_5483_((double)pos1.x(), (double)pos1.y(), (double)pos1.z()).m_7421_(from, 1.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaFrom * fading).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)pos2.x(), (double)pos2.y(), (double)pos2.z()).m_7421_(from, 0.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaFrom * fading).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)pos3.x(), (double)pos3.y(), (double)pos3.z()).m_7421_(to, 0.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaTo * fading).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)pos4.x(), (double)pos4.y(), (double)pos4.z()).m_7421_(to, 1.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * alphaTo * fading).m_85969_(light).m_5752_();
            from += interval;
            to += interval;
        }
    }

    public boolean shouldCull() {
        return false;
    }

    public ParticleRenderType m_7556_() {
        return EpicFightParticleRenderTypes.TRAIL_EFFECT;
    }

    protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTicks) {
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(-vec3.m_7096_());
        float y = (float)(-vec3.m_7098_());
        float z = (float)(-vec3.m_7094_());
        poseStack.m_252880_(x, y, z);
    }

    protected void makeTrailEdges(List<Vec3> startPositions, List<Vec3> endPositions, List<TrailEdge> dest) {
        for (int i = 0; i < startPositions.size(); ++i) {
            dest.add(new TrailEdge(startPositions.get(i), endPositions.get(i), this.trailInfo.trailLifetime()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrailEdge {
        public final Vec3 start;
        public final Vec3 end;
        public int lifetime;

        public TrailEdge(Vec3 start, Vec3 end, int lifetime) {
            this.start = start;
            this.end = end;
            this.lifetime = lifetime;
        }

        public boolean isAlive() {
            return --this.lifetime > 0;
        }
    }
}

