/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.client.renderer.EpicFightVertexFormatElement;

@OnlyIn(value=Dist.CLIENT)
public class EpicFightVertexFormat {
    public static final VertexFormatElement ELEMENT_POSITION = new EpicFightVertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.POSITION, 3, SkinnedMesh::pointPositionsBuffer);
    public static final VertexFormatElement ELEMENT_UV0 = new EpicFightVertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2, SkinnedMesh::uvPositionsBuffer);
    public static final VertexFormatElement ELEMENT_NORMAL = new EpicFightVertexFormatElement(0, VertexFormatElement.Type.BYTE, VertexFormatElement.Usage.NORMAL, 3, SkinnedMesh::normalPositionsBuffer);
    public static final VertexFormatElement ELEMENT_JOINTS = new EpicFightVertexFormatElement(0, VertexFormatElement.Type.SHORT, VertexFormatElement.Usage.GENERIC, 3, SkinnedMesh::jointPositionsBuffer);
    public static final VertexFormatElement ELEMENT_WEIGHTS = new EpicFightVertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.GENERIC, 3, SkinnedMesh::weightPositionsBuffer);
    private static final Set<VertexFormatElement> FILTERTED_FORMATS = ImmutableSet.of((Object)DefaultVertexFormat.f_85805_, (Object)DefaultVertexFormat.f_85807_, (Object)DefaultVertexFormat.f_85808_);
    private static final Map<VertexFormatElement, VertexFormatElement> VERTEX_FORMAT_MAPPING = ImmutableMap.of((Object)DefaultVertexFormat.f_85804_, (Object)ELEMENT_POSITION, (Object)DefaultVertexFormat.f_85806_, (Object)ELEMENT_UV0, (Object)DefaultVertexFormat.f_85809_, (Object)ELEMENT_NORMAL);

    public static boolean keep(VertexFormatElement vertexFormatElement) {
        return !FILTERTED_FORMATS.contains(vertexFormatElement);
    }

    public static VertexFormatElement convert(VertexFormatElement vertexFormatElement) {
        return VERTEX_FORMAT_MAPPING.getOrDefault(vertexFormatElement, vertexFormatElement);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AnimationVertexFormat
    extends VertexFormat {
        public AnimationVertexFormat(ImmutableMap<String, VertexFormatElement> attributesMap) {
            super(attributesMap);
        }
    }
}

