/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.online.EpicSkins;
import yesman.epicfight.api.client.physics.cloth.ClothSimulator;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;

@OnlyIn(value=Dist.CLIENT)
public class PatchedCapeLayer
extends PatchedLayer<AbstractClientPlayer, AbstractClientPlayerPatch<AbstractClientPlayer>, PlayerModel<AbstractClientPlayer>, CapeLayer> {
    public static final ResourceLocation DUMMY_CLOAK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/entity/cloak.png");

    @Override
    protected void renderLayer(AbstractClientPlayerPatch<AbstractClientPlayer> entitypatch, AbstractClientPlayer entityliving, CapeLayer vanillaLayer, PoseStack poseStack, MultiBufferSource buffer, int packedLight, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTick) {
        ItemStack itemstack;
        if (ClientConfig.enableCosmetics) {
            if (Minecraft.m_91087_().f_91080_ instanceof EffectRenderingInventoryScreen && entityliving == Minecraft.m_91087_().f_91074_ && partialTick == 1.0f) {
                return;
            }
            entitypatch.getClothSimulator().getRunningObject(ClothSimulator.PLAYER_CLOAK).ifPresent(clothObj -> {
                ResourceLocation capeTexture;
                Function<Float, OpenMatrix4f> partialColliderTransformProvider = partialFrame -> {
                    Vec3 pos = ((AbstractClientPlayer)entitypatch.getOriginal()).m_20318_(partialFrame.floatValue());
                    float yRotLerp = Mth.m_14189_((float)partialFrame.floatValue(), (float)entitypatch.getYRotO(), (float)entitypatch.getYRot());
                    return OpenMatrix4f.createTranslation((float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).rotateDeg(180.0f - yRotLerp, Vec3f.Y_AXIS);
                };
                ResourceLocation resourceLocation = capeTexture = entitypatch.isEpicSkinsLoaded() ? entitypatch.getEpicSkinsInformation().cloakTexture().get() : entityliving.m_108561_();
                if (capeTexture != null) {
                    clothObj.tick(entitypatch, partialColliderTransformProvider, partialTick, entitypatch.getArmature(), poses);
                    double entityX = Mth.m_14139_((double)partialTick, (double)entityliving.f_19790_, (double)entityliving.m_20185_());
                    double entityY = Mth.m_14139_((double)partialTick, (double)entityliving.f_19791_, (double)entityliving.m_20186_());
                    double entityZ = Mth.m_14139_((double)partialTick, (double)entityliving.f_19792_, (double)entityliving.m_20189_());
                    PatchedEntityRenderer renderer = ClientEngine.getInstance().renderEngine.getEntityRenderer(EntityType.f_20532_);
                    PoseStack posestack$2 = new PoseStack();
                    renderer.mulPoseStack(posestack$2, entitypatch.getArmature(), entityliving, entitypatch, partialTick);
                    Matrix4f lastposeInv = posestack$2.m_85850_().m_252922_().invert();
                    poseStack.m_85836_();
                    float scaler = entitypatch.getScale();
                    poseStack.m_85841_(scaler, scaler, scaler);
                    if (((AbstractClientPlayer)entitypatch.getOriginal()).m_21033_(EquipmentSlot.CHEST)) {
                        OpenMatrix4f poseMat = poses[((HumanoidArmature)Armatures.BIPED.get()).chest.getId()];
                        poseStack.m_252880_(poseMat.m30, poseMat.m31, poseMat.m32);
                        poseStack.m_85841_(1.17f, 1.17f, 1.17f);
                        poseStack.m_252880_(-poseMat.m30, -poseMat.m31, -poseMat.m32);
                    }
                    clothObj.scaleFromPose(poseStack, poses);
                    poseStack.m_85836_();
                    poseStack.m_252931_(lastposeInv);
                    poseStack.m_85837_((double)(-lastposeInv.m30()) - entityX, (double)(-lastposeInv.m31()) - entityY, (double)(-lastposeInv.m32()) - entityZ);
                    float bodyYRot = Mth.m_14189_((float)partialTick, (float)entitypatch.getYRotO(), (float)entitypatch.getYRot());
                    poseStack.m_85850_().m_252943_().rotate((Quaternionfc)QuaternionUtils.YP.rotationDegrees(bodyYRot));
                    VertexConsumer bufferBuilder = buffer.m_6299_(EpicFightRenderTypes.getTriangulated(RenderType.m_110458_((ResourceLocation)capeTexture)));
                    if (entitypatch.isEpicSkinsLoaded()) {
                        EpicSkins epicskinsInfo = entitypatch.getEpicSkinsInformation();
                        clothObj.drawPosed(poseStack, bufferBuilder, Mesh.DrawingFunction.NEW_ENTITY, packedLight, epicskinsInfo.r(), epicskinsInfo.g(), epicskinsInfo.b(), 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), poses);
                    } else {
                        clothObj.drawPosed(poseStack, bufferBuilder, Mesh.DrawingFunction.NEW_ENTITY, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), poses);
                    }
                    poseStack.m_85849_();
                    poseStack.m_85849_();
                }
            });
        } else if (entityliving.m_108555_() && !entityliving.m_20145_() && entityliving.m_36170_(PlayerModelPart.CAPE) && entityliving.m_108561_() != null && (itemstack = entityliving.m_6844_(EquipmentSlot.CHEST)).m_41720_() != Items.f_42741_) {
            OpenMatrix4f modelMatrix = new OpenMatrix4f();
            modelMatrix.scale(new Vec3f(-1.0f, -1.0f, 1.0f)).mulFront(poses[8]);
            poseStack.m_85836_();
            MathUtils.mulStack(poseStack, modelMatrix);
            poseStack.m_85837_(0.0, -0.4, -0.025);
            vanillaLayer.m_6494_(poseStack, buffer, packedLight, entityliving, entityliving.f_267362_.m_267756_(), entityliving.f_267362_.m_267731_(), partialTick, (float)entityliving.f_19797_, yRot, xRot);
            poseStack.m_85849_();
        }
    }
}

