/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.common;

import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class AnimatorControlPacket {
    protected Action action;
    protected int animationId;
    protected float transitionTimeModifier;
    protected boolean pause;

    public AnimatorControlPacket(Action action, int animationId, float transitionTimeModifier, boolean pause) {
        this.action = action;
        this.animationId = animationId;
        this.transitionTimeModifier = transitionTimeModifier;
        this.pause = pause;
    }

    public <T extends SPAnimatorControl> void process(LivingEntityPatch<?> entitypatch) {
        try {
            switch (this.action) {
                case PLAY: {
                    ((Animator)entitypatch.getAnimator()).playAnimation(this.animationId, this.transitionTimeModifier);
                    break;
                }
                case PLAY_INSTANTLY: {
                    ((Animator)entitypatch.getAnimator()).playAnimationInstantly(this.animationId);
                    break;
                }
                case RESERVE: {
                    ((Animator)entitypatch.getAnimator()).reserveAnimation(this.animationId);
                    break;
                }
                case STOP: {
                    ((Animator)entitypatch.getAnimator()).stopPlaying(this.animationId);
                    break;
                }
                case SHOT: {
                    ((Animator)entitypatch.getAnimator()).playShootingAnimation();
                    break;
                }
                case SOFT_PAUSE: {
                    ((Animator)entitypatch.getAnimator()).setSoftPause(this.pause);
                    break;
                }
                case HARD_PAUSE: {
                    ((Animator)entitypatch.getAnimator()).setHardPause(this.pause);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Action {
        PLAY,
        PLAY_INSTANTLY,
        RESERVE,
        STOP,
        SHOT,
        SOFT_PAUSE,
        HARD_PAUSE;

    }
}

