/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;

public class SPEntityPacket {
    private final int entityId;
    private final FriendlyByteBuf buffer;

    public SPEntityPacket() {
        this.entityId = 0;
        this.buffer = new FriendlyByteBuf(Unpooled.buffer());
    }

    public SPEntityPacket(int entityId) {
        this.entityId = entityId;
        this.buffer = new FriendlyByteBuf(Unpooled.buffer());
    }

    public FriendlyByteBuf getBuffer() {
        return this.buffer;
    }

    public static SPEntityPacket fromBytes(FriendlyByteBuf buf) {
        SPEntityPacket msg = new SPEntityPacket(buf.readInt());
        while (buf.isReadable()) {
            msg.buffer.writeByte((int)buf.readByte());
        }
        return msg;
    }

    public static void toBytes(SPEntityPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        while (msg.buffer.isReadable()) {
            buf.writeByte((int)msg.buffer.readByte());
        }
    }

    public static void handle(SPEntityPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            EntityPatch entitypatch;
            Minecraft mc = Minecraft.m_91087_();
            Entity entity = mc.f_91074_.m_9236_().m_6815_(msg.entityId);
            if (entity != null && (entitypatch = (EntityPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null)) != null) {
                entitypatch.processEntityPacket(msg.getBuffer());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

