/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class AirAttack
extends Skill {
    public static SkillBuilder<AirAttack> createAirAttackBuilder() {
        return ((SkillBuilder)((SkillBuilder)new SkillBuilder().setCategory(SkillCategories.AIR_ATTACK)).setActivateType(Skill.ActivateType.ONE_SHOT)).setResource(Skill.Resource.STAMINA);
    }

    public AirAttack(SkillBuilder<? extends AirAttack> builder) {
        super(builder);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        Player player = (Player)executer.getOriginal();
        return !player.m_20159_() && !player.m_5833_() && !executer.isInAir() && playerState.canBasicAttack();
    }

    @Override
    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> motions = skillContainer.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND).getAutoAttackMotion(skillContainer.getExecutor());
        if (motions == null) {
            return;
        }
        AnimationManager.AnimationAccessor<? extends AttackAnimation> attackMotion = motions.get(motions.size() - 1);
        if (attackMotion != null) {
            super.executeOnServer(skillContainer, args);
            skillContainer.getExecutor().playAnimationSynchronized(attackMotion, 0.0f);
        }
    }
}

