/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPModifySkillData;
import yesman.epicfight.network.server.SPAddOrRemoveSkillData;
import yesman.epicfight.network.server.SPModifySkillData;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;

public class SkillDataManager {
    private final Map<SkillDataKey<?>, Object> data = Maps.newHashMap();
    private final int slotIndex;
    private final SkillContainer container;

    public SkillDataManager(int slotIndex, SkillContainer container) {
        this.slotIndex = slotIndex;
        this.container = container;
    }

    public <T> void registerData(SkillDataKey<T> key) {
        if (this.hasData(key)) {
            throw new IllegalStateException("Skill dat key " + key + " already registered!");
        }
        this.data.put(key, key.defaultValue());
        if (key.syncronizeTrackingPlayers() && !this.container.getExecutor().isLogicalClient()) {
            Player owner = (Player)this.container.getExecutor().getOriginal();
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPAddOrRemoveSkillData(key, this.container.getSlot().universalOrdinal(), key.defaultValue(), SPAddOrRemoveSkillData.AddRemove.ADD, owner.m_19879_()), (Entity)owner, new Object[0]);
        }
    }

    public <T> void removeData(SkillDataKey<T> key) {
        this.data.remove(key);
        if (key.syncronizeTrackingPlayers() && !this.container.getExecutor().isLogicalClient()) {
            Player owner = (Player)this.container.getExecutor().getOriginal();
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPAddOrRemoveSkillData(key, this.container.getSlot().universalOrdinal(), null, SPAddOrRemoveSkillData.AddRemove.REMOVE, owner.m_19879_()), (Entity)owner, new Object[0]);
        }
    }

    public Set<SkillDataKey<?>> keySet() {
        return this.data.keySet();
    }

    @Deprecated
    public void setDataRawtype(SkillDataKey<?> key, Object data) {
        this.data.computeIfPresent(key, (theKey, val) -> data);
    }

    public <T> void setData(SkillDataKey<T> key, T data) {
        this.setDataRawtype(key, data);
    }

    public <T> void setDataF(SkillDataKey<T> key, Function<T, T> dataManipulator) {
        this.setDataRawtype(key, dataManipulator.apply(this.getDataValue(key)));
    }

    public <T> void setDataSync(SkillDataKey<T> key, T data, ServerPlayer player) {
        this.setData(key, data);
        this.syncData(key, player);
    }

    public <T> void setDataSyncF(SkillDataKey<T> key, Function<T, T> dataManipulator, ServerPlayer player) {
        this.setDataF(key, dataManipulator);
        SPModifySkillData msg = new SPModifySkillData(key, this.slotIndex, this.getDataValue(key), player.m_19879_());
        EpicFightNetworkManager.sendToPlayer(msg, player, new Object[0]);
        if (key.syncronizeTrackingPlayers()) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)player, new Object[0]);
        }
    }

    public <T> void syncData(SkillDataKey<T> key, ServerPlayer player) {
        SPModifySkillData msg = new SPModifySkillData(key, this.slotIndex, this.getDataValue(key), player.m_19879_());
        EpicFightNetworkManager.sendToPlayer(msg, player, new Object[0]);
        if (key.syncronizeTrackingPlayers()) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)player, new Object[0]);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> void syncData(SkillDataKey<T> key, LocalPlayer player) {
        CPModifySkillData msg = new CPModifySkillData(key, this.slotIndex, this.getDataValue(key));
        EpicFightNetworkManager.sendToServer(msg);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> void setDataSync(SkillDataKey<T> key, T data, LocalPlayer player) {
        this.setData(key, data);
        this.syncData(key, player);
    }

    public <T> T getDataValue(SkillDataKey<T> key) {
        return (T)(this.hasData(key) ? this.data.get(key) : null);
    }

    public boolean hasData(SkillDataKey<?> key) {
        return this.data.containsKey(key);
    }

    public void clearData() {
        this.data.clear();
    }
}

