/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.dodge;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class DodgeSkill
extends Skill {
    protected final AnimationManager.AnimationAccessor<? extends StaticAnimation>[] animations;

    public static Builder createDodgeBuilder() {
        return (Builder)((SkillBuilder)((SkillBuilder)new Builder().setCategory(SkillCategories.DODGE)).setActivateType(Skill.ActivateType.ONE_SHOT)).setResource(Skill.Resource.STAMINA);
    }

    public DodgeSkill(Builder builder) {
        super(builder);
        this.animations = builder.animations;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(SkillContainer skillContainer, FriendlyByteBuf args) {
        LocalPlayerPatch executor = skillContainer.getClientExecutor();
        Input input = ((LocalPlayer)executor.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)executor.getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float yRot = Minecraft.m_91087_().f_91063_.m_109153_().m_90590_();
        float degree = (float)(-(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot;
        CPExecuteSkill packet = new CPExecuteSkill(skillContainer.getSlotId());
        packet.getBuffer().writeInt(vertic >= 0 ? 0 : 1);
        packet.getBuffer().writeFloat(degree);
        return packet;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(ItemStack.f_41584_.format(this.consumption));
        return list;
    }

    @Override
    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        super.executeOnServer(skillContainer, args);
        ServerPlayerPatch executor = skillContainer.getServerExecutor();
        int i = args.readInt();
        float yRot = args.readFloat();
        executor.playAnimationSynchronized(this.animations[i], 0.0f);
        executor.setModelYRot(yRot, true);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        return !executer.isInAir() && playerState.canUseSkill() && !((Player)executer.getOriginal()).m_20069_() && !((Player)executer.getOriginal()).m_6147_() && ((Player)executer.getOriginal()).m_20202_() == null;
    }

    public static class Builder
    extends SkillBuilder<DodgeSkill> {
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation>[] animations;

        @SafeVarargs
        public final Builder setAnimations(AnimationManager.AnimationAccessor<? extends StaticAnimation> ... animations) {
            this.animations = animations;
            return this;
        }
    }
}

